/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.ui.action.impl;

import com.mucommander.commons.file.AbstractFile;
import com.mucommander.commons.file.impl.local.LocalFile;
import com.mucommander.desktop.DesktopManager;
import com.mucommander.job.TempExecJob;
import com.mucommander.text.Translator;
import com.mucommander.ui.action.AbstractActionDescriptor;
import com.mucommander.ui.action.ActionCategories;
import com.mucommander.ui.action.ActionCategory;
import com.mucommander.ui.action.ActionFactory;
import com.mucommander.ui.action.MuAction;
import com.mucommander.ui.dialog.InformationDialog;
import com.mucommander.ui.dialog.file.ProgressDialog;
import com.mucommander.ui.main.FolderPanel;
import com.mucommander.ui.main.MainFrame;
import com.mucommander.ui.main.quicklist.RecentExecutedFilesQL;
import java.io.IOException;
import java.util.Map;
import javax.swing.KeyStroke;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OpenAction
extends MuAction {
    public OpenAction(MainFrame mainFrame, Map<String, Object> properties) {
        super(mainFrame, properties);
    }

    protected void open(AbstractFile abstractFile, FolderPanel folderPanel) {
        if (abstractFile.isBrowsable()) {
            folderPanel.tryChangeCurrentFolder(abstractFile);
        } else if (abstractFile.getURL().getScheme().equals("file") && abstractFile.hasAncestor(LocalFile.class)) {
            try {
                DesktopManager.open(abstractFile);
                RecentExecutedFilesQL.addFile(abstractFile);
            }
            catch (IOException iOException) {
                InformationDialog.showErrorDialog(this.mainFrame);
            }
        } else {
            ProgressDialog progressDialog = new ProgressDialog(this.mainFrame, Translator.get("copy_dialog.copying", new String[0]));
            TempExecJob tempExecJob = new TempExecJob(progressDialog, this.mainFrame, abstractFile);
            progressDialog.start(tempExecJob);
        }
    }

    @Override
    public void performAction() {
        AbstractFile file = this.mainFrame.getActiveTable().getSelectedFile(true, true);
        if (file == null) {
            return;
        }
        this.open(file, this.mainFrame.getActivePanel());
    }

    public static class Descriptor
    extends AbstractActionDescriptor {
        public String getId() {
            return "Open";
        }

        public ActionCategory getCategory() {
            return ActionCategories.NAVIGATION;
        }

        public KeyStroke getDefaultAltKeyStroke() {
            return KeyStroke.getKeyStroke(39, 0);
        }

        public KeyStroke getDefaultKeyStroke() {
            return KeyStroke.getKeyStroke(10, 0);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Factory
    implements ActionFactory {
        @Override
        public MuAction createAction(MainFrame mainFrame, Map<String, Object> properties) {
            return new OpenAction(mainFrame, properties);
        }
    }
}

