/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.ui.action.impl;

import com.mucommander.commons.file.AbstractFile;
import com.mucommander.ui.action.AbstractActionDescriptor;
import com.mucommander.ui.action.ActionCategories;
import com.mucommander.ui.action.ActionCategory;
import com.mucommander.ui.action.ActionFactory;
import com.mucommander.ui.action.MuAction;
import com.mucommander.ui.action.impl.SelectedFileAction;
import com.mucommander.ui.main.FolderPanel;
import com.mucommander.ui.main.MainFrame;
import com.mucommander.ui.main.table.FileTable;
import com.mucommander.ui.main.table.FileTableModel;
import java.util.Map;
import javax.swing.KeyStroke;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OpenInBothPanelsAction
extends SelectedFileAction {
    public OpenInBothPanelsAction(MainFrame mainFrame, Map<String, Object> properties) {
        super(mainFrame, properties);
        this.setPerformActionInSeparateThread(true);
    }

    @Override
    protected boolean getFileTableCondition(FileTable fileTable) {
        AbstractFile selectedFile = fileTable.getSelectedFile(true, true);
        return selectedFile != null && selectedFile.isBrowsable();
    }

    @Override
    public void performAction() {
        AbstractFile otherFile = null;
        AbstractFile selectedFile = this.mainFrame.getActiveTable().getSelectedFile(true, true);
        if (selectedFile == null || !selectedFile.isBrowsable()) {
            return;
        }
        try {
            FileTableModel otherTableModel = this.mainFrame.getInactiveTable().getFileTableModel();
            if (this.mainFrame.getActiveTable().isParentFolderSelected()) {
                otherFile = otherTableModel.getParentFolder();
            } else {
                int fileCount = otherTableModel.getFileCount();
                String targetFilename = selectedFile.getName();
                for (int i = otherTableModel.getFirstMarkableRow(); i < fileCount && !(otherFile = otherTableModel.getCachedFileAtRow(i)).getName().equalsIgnoreCase(targetFilename); ++i) {
                    if (i != fileCount - 1) continue;
                    otherFile = null;
                }
            }
        }
        catch (Exception e) {
            otherFile = null;
        }
        FolderPanel.ChangeFolderThread openThread = this.mainFrame.getActivePanel().tryChangeCurrentFolder(selectedFile);
        if (otherFile != null) {
            if (openThread != null) {
                while (openThread.isAlive()) {
                    try {
                        openThread.join();
                    }
                    catch (InterruptedException e) {}
                }
            }
            this.mainFrame.getInactivePanel().tryChangeCurrentFolder(otherFile);
        }
    }

    public static class Descriptor
    extends AbstractActionDescriptor {
        public String getId() {
            return "OpenInBothPanels";
        }

        public ActionCategory getCategory() {
            return ActionCategories.NAVIGATION;
        }

        public KeyStroke getDefaultAltKeyStroke() {
            return null;
        }

        public KeyStroke getDefaultKeyStroke() {
            return KeyStroke.getKeyStroke(79, 192);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Factory
    implements ActionFactory {
        @Override
        public MuAction createAction(MainFrame mainFrame, Map<String, Object> properties) {
            return new OpenInBothPanelsAction(mainFrame, properties);
        }
    }
}

