/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.ui.action.impl;

import com.mucommander.bonjour.BonjourService;
import com.mucommander.bookmark.Bookmark;
import com.mucommander.commons.file.AbstractFile;
import com.mucommander.commons.file.FileURL;
import com.mucommander.ui.action.MuAction;
import com.mucommander.ui.main.FolderPanel;
import com.mucommander.ui.main.MainFrame;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OpenLocationAction
extends MuAction {
    private FileURL url;
    private AbstractFile file;
    private String path;

    public OpenLocationAction(MainFrame mainFrame, Map<String, Object> properties, FileURL url) {
        this(mainFrame, properties, url, url.getScheme().equals("file") ? url.getPath() : url.toString(false));
    }

    public OpenLocationAction(MainFrame mainFrame, Map<String, Object> properties, FileURL url, String label) {
        super(mainFrame, properties);
        this.url = url;
        this.setLabel(label);
        this.setToolTipText(url.getScheme().equals("file") ? url.getPath() : url.toString(false));
    }

    public OpenLocationAction(MainFrame mainFrame, Map<String, Object> properties, AbstractFile file) {
        this(mainFrame, properties, file, file.getName());
    }

    public OpenLocationAction(MainFrame mainFrame, Map<String, Object> properties, AbstractFile file, String label) {
        super(mainFrame, properties);
        this.file = file;
        this.setLabel(label);
        this.setToolTipText(file.getAbsolutePath());
    }

    public OpenLocationAction(MainFrame mainFrame, Map<String, Object> properties, String path) {
        this(mainFrame, properties, path, path);
    }

    public OpenLocationAction(MainFrame mainFrame, Map<String, Object> properties, String path, String label) {
        super(mainFrame, properties);
        this.path = path;
        this.setLabel(label);
        this.setToolTipText(path);
    }

    public OpenLocationAction(MainFrame mainFrame, Map<String, Object> properties, Bookmark bookmark) {
        this(mainFrame, properties, bookmark.getLocation(), bookmark.getName());
    }

    public OpenLocationAction(MainFrame mainFrame, Map<String, Object> properties, BonjourService bonjourService) {
        this(mainFrame, properties, bonjourService.getURL(), bonjourService.getNameWithProtocol());
    }

    protected FolderPanel getFolderPanel() {
        return this.mainFrame.getActivePanel();
    }

    @Override
    public void performAction() {
        FolderPanel folderPanel = this.getFolderPanel();
        if (this.url != null) {
            folderPanel.tryChangeCurrentFolder(this.url);
        } else if (this.file != null) {
            folderPanel.tryChangeCurrentFolder(this.file);
        } else if (this.path != null) {
            folderPanel.tryChangeCurrentFolder(this.path);
        }
    }
}

