/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.ui.action.impl;

import com.mucommander.commons.file.AbstractArchiveEntryFile;
import com.mucommander.commons.file.AbstractFile;
import com.mucommander.desktop.DesktopManager;
import com.mucommander.job.TempExecJob;
import com.mucommander.text.Translator;
import com.mucommander.ui.action.AbstractActionDescriptor;
import com.mucommander.ui.action.ActionCategories;
import com.mucommander.ui.action.ActionCategory;
import com.mucommander.ui.action.ActionFactory;
import com.mucommander.ui.action.MuAction;
import com.mucommander.ui.dialog.InformationDialog;
import com.mucommander.ui.dialog.file.ProgressDialog;
import com.mucommander.ui.main.MainFrame;
import com.mucommander.ui.main.quicklist.RecentExecutedFilesQL;
import java.io.IOException;
import java.util.Map;
import javax.swing.KeyStroke;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OpenNativelyAction
extends MuAction {
    public OpenNativelyAction(MainFrame mainFrame, Map<String, Object> properties) {
        super(mainFrame, properties);
    }

    @Override
    public void performAction() {
        AbstractFile abstractFile = this.mainFrame.getActiveTable().getSelectedFile(true, true);
        if (abstractFile == null) {
            return;
        }
        if (!"file".equals(abstractFile.getURL().getScheme()) || abstractFile.hasAncestor(AbstractArchiveEntryFile.class)) {
            ProgressDialog progressDialog = new ProgressDialog(this.mainFrame, Translator.get("copy_dialog.copying", new String[0]));
            TempExecJob tempExecJob = new TempExecJob(progressDialog, this.mainFrame, abstractFile);
            progressDialog.start(tempExecJob);
        } else {
            try {
                DesktopManager.open(abstractFile);
                RecentExecutedFilesQL.addFile(abstractFile);
            }
            catch (IOException iOException) {
                InformationDialog.showErrorDialog(this.mainFrame);
            }
        }
    }

    public static class Descriptor
    extends AbstractActionDescriptor {
        public String getId() {
            return "OpenNatively";
        }

        public ActionCategory getCategory() {
            return ActionCategories.NAVIGATION;
        }

        public KeyStroke getDefaultAltKeyStroke() {
            return null;
        }

        public KeyStroke getDefaultKeyStroke() {
            return KeyStroke.getKeyStroke(10, 64);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Factory
    implements ActionFactory {
        @Override
        public MuAction createAction(MainFrame mainFrame, Map<String, Object> properties) {
            return new OpenNativelyAction(mainFrame, properties);
        }
    }
}

