/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.ui.action.impl;

import com.mucommander.text.Translator;
import com.mucommander.ui.action.AbstractActionDescriptor;
import com.mucommander.ui.action.ActionCategories;
import com.mucommander.ui.action.ActionCategory;
import com.mucommander.ui.action.MuAction;
import com.mucommander.ui.main.MainFrame;
import com.mucommander.ui.main.table.Column;
import java.util.Map;
import javax.swing.KeyStroke;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ToggleColumnAction
extends MuAction {
    protected Column column;

    public ToggleColumnAction(MainFrame mainFrame, Map<String, Object> properties, Column column) {
        super(mainFrame, properties);
        this.column = column;
        this.updateLabel();
    }

    protected boolean isColumnVisible() {
        return this.mainFrame.getActiveTable().isColumnVisible(this.column);
    }

    protected void updateLabel() {
        this.setLabel(Translator.get(this.isColumnVisible() ? "ToggleColumn.hide" : "ToggleColumn.show", this.column.getLabel()));
    }

    @Override
    public void performAction() {
        this.mainFrame.getActiveTable().setColumnEnabled(this.column, !this.isColumnVisible());
    }

    public static abstract class Descriptor
    extends AbstractActionDescriptor {
        private Column column;

        public Descriptor(Column column) {
            this.column = column;
        }

        public String getId() {
            return this.column.getToggleColumnActionId();
        }

        public ActionCategory getCategory() {
            return ActionCategories.VIEW;
        }

        public KeyStroke getDefaultAltKeyStroke() {
            return null;
        }

        public KeyStroke getDefaultKeyStroke() {
            return null;
        }

        public String getLabel() {
            return Translator.get("ToggleColumn.show", this.column.getLabel());
        }
    }
}

