/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.ui.action.impl;

import com.mucommander.conf.MuConfigurations;
import com.mucommander.conf.MuPreference;
import com.mucommander.text.Translator;
import com.mucommander.ui.action.AbstractActionDescriptor;
import com.mucommander.ui.action.ActionCategories;
import com.mucommander.ui.action.ActionCategory;
import com.mucommander.ui.action.ActionFactory;
import com.mucommander.ui.action.MuAction;
import com.mucommander.ui.main.MainFrame;
import com.mucommander.ui.main.StatusBar;
import java.util.Map;
import javax.swing.KeyStroke;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ToggleStatusBarAction
extends MuAction {
    public ToggleStatusBarAction(MainFrame mainFrame, Map<String, Object> properties) {
        super(mainFrame, properties);
        this.updateLabel(MuConfigurations.getPreferences().getVariable(MuPreference.STATUS_BAR_VISIBLE, true));
    }

    private void updateLabel(boolean visible) {
        this.setLabel(Translator.get(visible ? "ToggleStatusBar.hide" : "ToggleStatusBar.show", new String[0]));
    }

    @Override
    public void performAction() {
        StatusBar statusBar = this.mainFrame.getStatusBar();
        boolean visible = !statusBar.isVisible();
        MuConfigurations.getPreferences().setVariable(MuPreference.STATUS_BAR_VISIBLE, visible);
        this.updateLabel(visible);
        statusBar.setVisible(visible);
        this.mainFrame.validate();
    }

    public static class Descriptor
    extends AbstractActionDescriptor {
        public String getId() {
            return "ToggleStatusBar";
        }

        public ActionCategory getCategory() {
            return ActionCategories.VIEW;
        }

        public KeyStroke getDefaultAltKeyStroke() {
            return null;
        }

        public KeyStroke getDefaultKeyStroke() {
            return null;
        }

        public String getLabelKey() {
            return "ToggleStatusBar.show";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Factory
    implements ActionFactory {
        @Override
        public MuAction createAction(MainFrame mainFrame, Map<String, Object> properties) {
            return new ToggleStatusBarAction(mainFrame, properties);
        }
    }
}

