/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.ui.autocomplete;

import com.mucommander.ui.combobox.EditableComboBox;
import java.awt.Rectangle;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Vector;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AutocompleterTextComponent {
    private JTextComponent textComponent;
    private EditableComboBox editableComboBox = null;

    public AutocompleterTextComponent(JTextComponent textComp) {
        this.textComponent = textComp;
    }

    protected AutocompleterTextComponent(EditableComboBox editableComboBox) {
        this.textComponent = editableComboBox.getTextField();
        this.editableComboBox = editableComboBox;
        this.removeAllKeyListeners();
    }

    public abstract void OnEnterPressed(KeyEvent var1);

    public abstract void OnEscPressed(KeyEvent var1);

    private void removeAllKeyListeners() {
        KeyListener[] l = this.editableComboBox.getTextField().getKeyListeners();
        int nbKeyListeners = l.length;
        for (int i = 0; i < nbKeyListeners; ++i) {
            this.editableComboBox.getTextField().removeKeyListener(l[i]);
        }
    }

    public Document getDocument() {
        return this.textComponent.getDocument();
    }

    public boolean isShowing() {
        return this.textComponent.isShowing();
    }

    public void setText(String text) {
        this.textComponent.setText(text);
    }

    public String getText() {
        return this.textComponent.getText();
    }

    public boolean hasFocus() {
        return this.textComponent.hasFocus();
    }

    public boolean isEnabled() {
        return this.textComponent.isEnabled();
    }

    public int getHeight() {
        return this.textComponent.getHeight();
    }

    public Rectangle modelToView() throws BadLocationException {
        return this.textComponent.getUI().modelToView(this.textComponent, this.textComponent.getCaretPosition());
    }

    public void moveCarentToEndOfText() {
        this.textComponent.setCaretPosition(this.textComponent.getText().length());
    }

    public boolean isCarentAtEndOfTextAtInsertion() {
        return this.textComponent.getCaretPosition() == this.textComponent.getText().length() - 1;
    }

    public boolean isCarentAtEndOfTextAtRemoval() {
        return this.textComponent.getCaretPosition() == this.textComponent.getText().length() + 1;
    }

    public JTextComponent getTextComponent() {
        return this.textComponent;
    }

    public void addKeyListener(KeyAdapter adapter) {
        this.textComponent.addKeyListener(adapter);
    }

    public void addFocusListener(FocusListener listener) {
        this.textComponent.addFocusListener(listener);
    }

    public Vector<String> getItemNames() {
        Vector<String> result = new Vector<String>();
        if (this.editableComboBox != null) {
            int nbItems = this.editableComboBox.getItemCount();
            for (int i = 0; i < nbItems; ++i) {
                result.add(this.editableComboBox.getItemAt(i).toString());
            }
        }
        return result;
    }

    public void setComponentsPopupUnvisibe() {
        if (this.editableComboBox != null) {
            this.editableComboBox.setPopupVisible(false);
        }
    }
}

