/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.ui.autocomplete;

import com.mucommander.ui.autocomplete.AutocompleterTextComponent;
import com.mucommander.ui.autocomplete.CompletionType;
import com.mucommander.ui.autocomplete.completers.Completer;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.JPopupMenu;
import javax.swing.text.BadLocationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TextFieldCompletion
extends CompletionType {
    private static final Logger LOGGER = LoggerFactory.getLogger(TextFieldCompletion.class);

    public TextFieldCompletion(AutocompleterTextComponent comp, Completer completer) {
        super(comp, completer);
        this.autocompletedtextComp.getDocument().addDocumentListener(this.documentListener);
        this.autocompletedtextComp.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                switch (keyEvent.getKeyCode()) {
                    case 10: {
                        if (TextFieldCompletion.this.isItemSelectedAtPopupList()) {
                            TextFieldCompletion.this.hideAutocompletionPopup();
                            TextFieldCompletion.this.acceptListItem((String)TextFieldCompletion.this.list.getSelectedValue());
                            keyEvent.consume();
                            break;
                        }
                        TextFieldCompletion.this.autocompletedtextComp.OnEnterPressed(keyEvent);
                        break;
                    }
                    case 27: {
                        if (TextFieldCompletion.this.isPopupListShowing()) {
                            if (TextFieldCompletion.this.autocompletedtextComp.isEnabled()) {
                                TextFieldCompletion.this.hideAutocompletionPopup();
                            }
                            keyEvent.consume();
                            break;
                        }
                        TextFieldCompletion.this.autocompletedtextComp.OnEscPressed(keyEvent);
                        break;
                    }
                    case 38: {
                        if (!TextFieldCompletion.this.autocompletedtextComp.isEnabled() || !TextFieldCompletion.this.popup.isVisible()) break;
                        TextFieldCompletion.this.selectPreviousPossibleValue();
                        keyEvent.consume();
                        break;
                    }
                    case 32: {
                        if (!keyEvent.isControlDown() || TextFieldCompletion.this.popup.isVisible()) break;
                        TextFieldCompletion.this.autocompletedtextComp.moveCarentToEndOfText();
                        TextFieldCompletion.this.createNewShowingThread(0);
                        break;
                    }
                    case 40: {
                        if (!TextFieldCompletion.this.autocompletedtextComp.isEnabled()) break;
                        if (TextFieldCompletion.this.popup.isVisible()) {
                            TextFieldCompletion.this.selectNextPossibleValue();
                            keyEvent.consume();
                            break;
                        }
                        TextFieldCompletion.this.autocompletedtextComp.moveCarentToEndOfText();
                        TextFieldCompletion.this.createNewShowingThread(0);
                        break;
                    }
                    case 34: {
                        if (!TextFieldCompletion.this.autocompletedtextComp.isEnabled() || !TextFieldCompletion.this.isPopupListShowing()) break;
                        TextFieldCompletion.this.selectNextPage();
                        keyEvent.consume();
                        break;
                    }
                    case 33: {
                        if (!TextFieldCompletion.this.autocompletedtextComp.isEnabled() || !TextFieldCompletion.this.isItemSelectedAtPopupList()) break;
                        TextFieldCompletion.this.selectPreviousPage();
                        keyEvent.consume();
                        break;
                    }
                    case 36: {
                        if (!TextFieldCompletion.this.autocompletedtextComp.isEnabled() || !TextFieldCompletion.this.isPopupListShowing()) break;
                        TextFieldCompletion.this.selectFirstValue();
                        keyEvent.consume();
                        break;
                    }
                    case 35: {
                        if (!TextFieldCompletion.this.autocompletedtextComp.isEnabled() || !TextFieldCompletion.this.isPopupListShowing()) break;
                        TextFieldCompletion.this.selectLastValue();
                        keyEvent.consume();
                        break;
                    }
                    case 37: {
                        TextFieldCompletion.this.hideAutocompletionPopup();
                        break;
                    }
                }
            }
        });
    }

    protected void startNewShowingThread(int delay) {
        this.showingThread = new ShowingThreadImp(delay);
        this.showingThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void hideAutocompletionPopup() {
        JPopupMenu jPopupMenu = this.popup;
        synchronized (jPopupMenu) {
            if (this.popup.isVisible()) {
                this.popup.setVisible(false);
            }
        }
    }

    private class ShowingThreadImp
    extends CompletionType.ShowingThread {
        public ShowingThreadImp(int delay) {
            super(delay);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void showAutocompletionPopup() {
            if (TextFieldCompletion.this.autocompletedtextComp.isShowing() && TextFieldCompletion.this.autocompletedtextComp.isEnabled() && TextFieldCompletion.this.updateListData(TextFieldCompletion.this.list)) {
                int x;
                TextFieldCompletion.this.list.setVisibleRowCount(Math.min(TextFieldCompletion.this.list.getModel().getSize(), 10));
                try {
                    x = TextFieldCompletion.this.autocompletedtextComp.modelToView().x;
                }
                catch (BadLocationException e) {
                    LOGGER.debug("Caught exception", e);
                    return;
                }
                if (TextFieldCompletion.this.autocompletedtextComp.hasFocus() && !this.isStopped) {
                    TextFieldCompletion.this.list.ensureIndexIsVisible(0);
                    JPopupMenu jPopupMenu = TextFieldCompletion.this.popup;
                    synchronized (jPopupMenu) {
                        TextFieldCompletion.this.popup.show(TextFieldCompletion.this.autocompletedtextComp.getTextComponent(), x, TextFieldCompletion.this.autocompletedtextComp.getHeight());
                        TextFieldCompletion.this.popup.repaint();
                    }
                }
            }
        }
    }
}

