/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.ui.autocomplete.completers;

import com.mucommander.commons.file.FileURL;
import com.mucommander.ui.autocomplete.AutocompleterTextComponent;
import com.mucommander.ui.autocomplete.completers.services.CompletionService;
import java.net.MalformedURLException;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.Vector;
import javax.swing.JList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Completer {
    private Set<CompletionService> services = new LinkedHashSet<CompletionService>();

    protected abstract Vector<String> getUpdatedSuggestions(AutocompleterTextComponent var1);

    public boolean updateListData(JList list, AutocompleterTextComponent comp) {
        list.setListData(this.getUpdatedSuggestions(comp));
        if (list.getModel().getSize() == 1) {
            try {
                String typedFilename = FileURL.getFileURL(comp.getText()).getFilename();
                if (typedFilename == null || typedFilename.equalsIgnoreCase((String)list.getModel().getElementAt(0))) {
                    return false;
                }
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return list.getModel().getSize() > 0;
    }

    public abstract void updateTextComponent(String var1, AutocompleterTextComponent var2);

    protected void registerService(CompletionService service) {
        this.services.add(service);
    }

    protected Vector<String> getPossibleCompletionsFromServices(String path) {
        Vector<String> result = new Vector<String>();
        for (CompletionService service : this.services) {
            result.addAll(service.getPossibleCompletions(path));
        }
        return result;
    }

    protected String tryToCompleteFromServices(String selectedString) {
        CompletionService service;
        String location = null;
        Iterator<CompletionService> i$ = this.services.iterator();
        while (i$.hasNext() && (location = (service = i$.next()).complete(selectedString)) == null) {
        }
        return location;
    }
}

