/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.ui.autocomplete.completers.services;

import com.mucommander.commons.file.AbstractFile;
import com.mucommander.commons.file.FileFactory;
import com.mucommander.ui.autocomplete.completers.services.CompletionService;
import com.mucommander.ui.autocomplete.completers.services.PrefixFilter;
import java.io.IOException;
import java.util.Arrays;
import java.util.Vector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class FilesService
implements CompletionService {
    private static final Logger LOGGER = LoggerFactory.getLogger(FilesService.class);
    private String cachedDirectoryName;
    private String[] cachedDirectoryFileNames = new String[0];
    private long cachedDirectoryDate = -1L;

    protected abstract AbstractFile[] getFiles(AbstractFile var1) throws IOException;

    @Override
    public Vector<String> getPossibleCompletions(String path) {
        String currentDirectoryName;
        AbstractFile currentDirectory;
        Vector<String> result = new Vector<String>();
        int index = Math.max(path.lastIndexOf(92), path.lastIndexOf(47));
        if (index != -1 && (currentDirectory = FileFactory.getFile(currentDirectoryName = path.substring(0, index + 1))) != null && currentDirectory.exists()) {
            long currentDirectoryDate = currentDirectory.getDate();
            if (this.cachedDirectoryName == null || !this.cachedDirectoryName.equals(currentDirectoryName) || currentDirectoryDate != this.cachedDirectoryDate) {
                AbstractFile[] currentDirectoryFiles;
                try {
                    currentDirectoryFiles = this.getFiles(currentDirectory);
                }
                catch (IOException e) {
                    LOGGER.debug("Caught exception", e);
                    return new Vector<String>();
                }
                int nbCurrentDirectoryFiles = currentDirectoryFiles.length;
                this.cachedDirectoryFileNames = new String[nbCurrentDirectoryFiles];
                for (int i = 0; i < nbCurrentDirectoryFiles; ++i) {
                    AbstractFile abstractFileI = currentDirectoryFiles[i];
                    this.cachedDirectoryFileNames[i] = abstractFileI.getName() + (abstractFileI.isDirectory() ? abstractFileI.getSeparator() : "");
                }
                Arrays.sort(this.cachedDirectoryFileNames, String.CASE_INSENSITIVE_ORDER);
                this.cachedDirectoryName = currentDirectory.getAbsolutePath() + (currentDirectory.isDirectory() ? "" : currentDirectory.getSeparator());
                this.cachedDirectoryDate = currentDirectoryDate;
            }
            String prefix = index == path.length() - 1 ? null : path.substring(index + 1).toLowerCase();
            result = PrefixFilter.createPrefixFilter(prefix).filter(this.cachedDirectoryFileNames);
        }
        return result;
    }

    @Override
    public String complete(String selectedCompletion) {
        String result = null;
        int nbCachedFileNames = this.cachedDirectoryFileNames.length;
        for (int i = 0; i < nbCachedFileNames; ++i) {
            if (!this.cachedDirectoryFileNames[i].equalsIgnoreCase(selectedCompletion)) continue;
            result = this.cachedDirectoryName + this.cachedDirectoryFileNames[i];
            break;
        }
        return result;
    }
}

