/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.ui.autocomplete.completers.services;

import com.mucommander.ui.autocomplete.completers.services.CompletionService;
import com.mucommander.ui.autocomplete.completers.services.PrefixFilter;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SystemVariablesService
implements CompletionService {
    private String[] cachedKeyNames;

    public SystemVariablesService() {
        Set<String> keys = System.getenv().keySet();
        int nbKeys = keys.size();
        this.cachedKeyNames = new String[nbKeys];
        Iterator<String> iter = keys.iterator();
        for (int i = 0; i < nbKeys; ++i) {
            this.cachedKeyNames[i] = "$" + iter.next();
        }
        Arrays.sort(this.cachedKeyNames, String.CASE_INSENSITIVE_ORDER);
    }

    @Override
    public Vector<String> getPossibleCompletions(String path) {
        return PrefixFilter.createPrefixFilter(path).filter(this.cachedKeyNames);
    }

    @Override
    public String complete(String selectedCompletion) {
        String result = null;
        int nbKeyNames = this.cachedKeyNames.length;
        for (int i = 0; i < nbKeyNames; ++i) {
            if (!this.cachedKeyNames[i].equalsIgnoreCase(selectedCompletion)) continue;
            result = this.cachedKeyNames[i];
            break;
        }
        return result;
    }
}

