/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.ui.autocomplete.completers.services;

import com.mucommander.commons.file.AbstractFile;
import com.mucommander.commons.file.impl.local.LocalFile;
import com.mucommander.ui.autocomplete.completers.services.CompletionService;
import com.mucommander.ui.autocomplete.completers.services.PrefixFilter;
import java.util.Arrays;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VolumesService
implements CompletionService {
    private Vector<String> lastSuggestedCompletions = new Vector();

    @Override
    public Vector<String> getPossibleCompletions(String path) {
        this.lastSuggestedCompletions.clear();
        int index = Math.max(path.lastIndexOf(92), path.lastIndexOf(47));
        if (index == -1) {
            AbstractFile[] fileRoots = LocalFile.getVolumes();
            int nbFolders = fileRoots.length;
            String[] rootFolderNames = new String[nbFolders];
            for (int i = 0; i < nbFolders; ++i) {
                rootFolderNames[i] = fileRoots[i].getAbsolutePath();
            }
            Arrays.sort(rootFolderNames, String.CASE_INSENSITIVE_ORDER);
            this.lastSuggestedCompletions = PrefixFilter.createPrefixFilter(path).filter(rootFolderNames);
        }
        return this.lastSuggestedCompletions;
    }

    @Override
    public String complete(String selectedCompletion) {
        String result = null;
        int nbLastReturnedCompletions = this.lastSuggestedCompletions.size();
        for (int i = 0; i < nbLastReturnedCompletions; ++i) {
            if (!this.lastSuggestedCompletions.elementAt(i).equalsIgnoreCase(selectedCompletion)) continue;
            result = this.lastSuggestedCompletions.elementAt(i);
            break;
        }
        return result;
    }
}

