/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.ui.button;

import com.mucommander.ui.button.ArrowButton;
import java.awt.Component;
import java.awt.Container;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;

public class CollapseExpandButton
extends ArrowButton
implements ActionListener,
KeyListener {
    private Component comp;
    private boolean expandedState;

    public CollapseExpandButton(String label, Component component, boolean expanded) {
        this.comp = component;
        this.setText(label);
        this.setExpandedState(expanded, false);
        this.addActionListener(this);
        this.addKeyListener(this);
    }

    public void setExpandedState(boolean expanded) {
        this.setExpandedState(expanded, true);
    }

    public boolean getExpandedState() {
        return this.expandedState;
    }

    private void setExpandedState(boolean expanded, boolean packWindow) {
        Container tla;
        if (expanded) {
            this.setArrowDirection(1);
            this.comp.setVisible(true);
        } else {
            this.setArrowDirection(3);
            this.comp.setVisible(false);
        }
        this.expandedState = expanded;
        if (packWindow && (tla = this.getTopLevelAncestor()) instanceof Window) {
            ((Window)tla).pack();
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.setExpandedState(!this.expandedState, true);
    }

    public void keyPressed(KeyEvent keyEvent) {
        int keyCode = keyEvent.getKeyCode();
        if (keyCode == 39 && !this.expandedState) {
            this.setExpandedState(true, true);
        } else if (keyCode == 37 && this.expandedState) {
            this.setExpandedState(false, true);
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
    }
}

