/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.ui.button;

import com.mucommander.commons.runtime.OsFamilies;
import com.mucommander.commons.runtime.OsVersions;
import com.mucommander.ui.icon.IconManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.AbstractButton;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

public class ToolbarMoreButton
extends JToggleButton
implements ActionListener {
    private static JToolBar moreToolbar;
    JToolBar toolbar;

    protected ToolbarMoreButton(final JToolBar toolbar) {
        super(IconManager.getIcon(3, "more.png"));
        this.toolbar = toolbar;
        this.addActionListener(this);
        this.setFocusPainted(false);
        this.setMargin(new Insets(0, 0, 0, 0));
        this.setContentAreaFilled(false);
        this.setBorderPainted(false);
        if (OsFamilies.MAC_OS_X.isCurrent() && OsVersions.MAC_OS_X_10_5.isCurrentOrHigher()) {
            this.putClientProperty("JComponent.sizeVariant", "small");
            this.putClientProperty("JButton.buttonType", "textured");
        }
        this.addMouseListener(new MouseAdapter(){

            public void mouseExited(MouseEvent e) {
                ToolbarMoreButton.this.setBorderPainted(false);
            }

            public void mouseEntered(MouseEvent e) {
                ToolbarMoreButton.this.setBorderPainted(true);
            }
        });
        toolbar.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent e) {
                int nbToolbarComponents = toolbar.getComponentCount();
                boolean aFlag = nbToolbarComponents > 0 && !ToolbarMoreButton.this.isVisible(toolbar.getComponent(nbToolbarComponents - 1), null);
                ToolbarMoreButton.this.setVisible(aFlag);
                moreToolbar.setVisible(aFlag);
            }
        });
    }

    private boolean isVisible(Component comp, Rectangle rect) {
        if (rect == null) {
            rect = this.toolbar.getVisibleRect();
        }
        return (double)(comp.getLocation().x + comp.getWidth()) <= rect.getWidth();
    }

    public void actionPerformed(ActionEvent e) {
        Component[] comp = this.toolbar.getComponents();
        Rectangle visibleRect = this.toolbar.getVisibleRect();
        for (int i = 0; i < comp.length; ++i) {
            if (this.isVisible(comp[i], visibleRect)) continue;
            JPopupMenu popup = new JPopupMenu();
            while (i < comp.length) {
                if (comp[i] instanceof AbstractButton) {
                    AbstractButton button = (AbstractButton)comp[i];
                    if (button.getAction() != null) {
                        popup.add(button.getAction());
                    }
                } else if (comp[i] instanceof JSeparator) {
                    popup.addSeparator();
                }
                ++i;
            }
            popup.addPopupMenuListener(new PopupMenuListener(){

                public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                    ToolbarMoreButton.this.setSelected(false);
                }

                public void popupMenuCanceled(PopupMenuEvent e) {
                }

                public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                }
            });
            popup.show(this, 0, this.getHeight());
        }
    }

    public static JPanel wrapToolBar(JToolBar toolbar) {
        moreToolbar = new JToolBar();
        moreToolbar.setRollover(true);
        moreToolbar.setFloatable(false);
        moreToolbar.add(new ToolbarMoreButton(toolbar));
        moreToolbar.setBorderPainted(false);
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)toolbar, "Center");
        panel.add((Component)moreToolbar, "East");
        return panel;
    }
}

