/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.ui.chooser;

import com.mucommander.text.Translator;
import com.mucommander.ui.layout.YBoxPanel;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.WeakHashMap;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class FontChooser
extends YBoxPanel
implements ActionListener {
    private static final int[] FONT_SIZES = new int[]{8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 20, 22, 24, 28};
    private JComboBox families;
    private JComboBox sizes;
    private JCheckBox italic;
    private JCheckBox bold;
    private JLabel preview;
    private Font font;
    private WeakHashMap<ChangeListener, ?> listeners = new WeakHashMap();

    public FontChooser(Font selection) {
        this.initUI(selection);
    }

    private void initUI(Font selection) {
        this.setAlignmentX(0.0f);
        this.families = new JComboBox();
        String[] familyNames = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
        int selectedIndex = 0;
        for (int i = 0; i < familyNames.length; ++i) {
            this.families.addItem(familyNames[i]);
            if (!selection.getFamily().equalsIgnoreCase(familyNames[i])) continue;
            selectedIndex = i;
        }
        this.families.setSelectedIndex(selectedIndex);
        this.families.addActionListener(this);
        JPanel panel = new JPanel(new FlowLayout(0));
        panel.add(this.families);
        this.add(panel);
        this.sizes = new JComboBox();
        for (int fontSize : FONT_SIZES) {
            this.sizes.addItem(Integer.toString(fontSize));
        }
        this.sizes.setSelectedItem(Integer.toString(selection.getSize()));
        this.sizes.addActionListener(this);
        this.bold = new JCheckBox(Translator.get("font_chooser.font_bold", new String[0]));
        this.italic = new JCheckBox(Translator.get("font_chooser.font_italic", new String[0]));
        this.bold.setSelected(selection.isBold());
        this.bold.addActionListener(this);
        this.italic.setSelected(selection.isItalic());
        this.italic.addActionListener(this);
        panel = new JPanel(new FlowLayout(0));
        panel.add(new JLabel(Translator.get("font_chooser.font_size", new String[0]) + ": "));
        panel.add(this.sizes);
        panel.add(Box.createRigidArea(new Dimension(10, 0)));
        panel.add(this.bold);
        panel.add(this.italic);
        this.add(panel);
        this.font = selection;
        panel = new JPanel(new FlowLayout(0));
        panel.add(new JLabel(Translator.get("preview", new String[0]) + ": "));
        this.preview = new JLabel("aBcDeFgHiJkLmNoPqRsTuVwXyZ");
        this.updatePreview();
        panel.add(this.preview);
        this.add(panel);
    }

    private Font createFont() {
        return new Font((String)this.families.getSelectedItem(), (this.bold.isSelected() ? 1 : 0) | (this.italic.isSelected() ? 2 : 0), Integer.parseInt((String)this.sizes.getSelectedItem()));
    }

    public Font getCurrentFont() {
        return this.font;
    }

    private void updatePreview() {
        this.preview.setFont(this.font);
        this.preview.repaint();
    }

    public void actionPerformed(ActionEvent e) {
        this.font = this.createFont();
        this.updatePreview();
        ChangeEvent event = new ChangeEvent(this);
        for (ChangeListener listener : this.listeners.keySet()) {
            listener.stateChanged(event);
        }
    }

    public void addChangeListener(ChangeListener listener) {
        this.listeners.put(listener, null);
    }
}

