/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.ui.chooser;

import com.mucommander.text.SizeFormat;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.WeakHashMap;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class SizeChooser
extends JPanel {
    private JSpinner valueSpinner;
    private JComboBox unitComboBox;
    private WeakHashMap<ChangeListener, ?> listeners = new WeakHashMap();

    public SizeChooser(boolean speedUnits) {
        JFormattedTextField textField;
        int nbColumns;
        this.setLayout(new BoxLayout(this, 0));
        this.valueSpinner = new JSpinner(new SpinnerNumberModel(0, 0, Integer.MAX_VALUE, 100));
        this.valueSpinner.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                SizeChooser.this.fireChangeEvent();
            }
        });
        JComponent editor = this.valueSpinner.getEditor();
        if (editor instanceof JSpinner.DefaultEditor && (nbColumns = (textField = ((JSpinner.DefaultEditor)editor).getTextField()).getColumns()) > 7) {
            textField.setColumns(7);
        }
        this.add(this.valueSpinner);
        this.unitComboBox = new JComboBox();
        for (int i = 0; i <= 3; ++i) {
            this.unitComboBox.addItem(SizeFormat.getUnitString(i, speedUnits));
        }
        this.unitComboBox.setSelectedIndex(1);
        this.unitComboBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                SizeChooser.this.fireChangeEvent();
            }
        });
        this.add(this.unitComboBox);
    }

    public long getValue() {
        return SizeFormat.getUnitBytes(this.unitComboBox.getSelectedIndex()) * (long)((Integer)this.valueSpinner.getValue()).intValue();
    }

    public synchronized void addChangeListener(ChangeListener listener) {
        this.listeners.put(listener, null);
    }

    public synchronized void fireChangeEvent() {
        for (ChangeListener listener : this.listeners.keySet()) {
            listener.stateChanged(new ChangeEvent(this));
        }
    }

    public void setEnabled(boolean enabled) {
        this.valueSpinner.setEnabled(enabled);
        this.unitComboBox.setEnabled(enabled);
    }
}

