/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.ui.dialog;

import com.mucommander.commons.runtime.OsFamilies;
import com.mucommander.ui.dialog.DialogToolkit;
import com.mucommander.ui.helper.FocusRequester;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.border.EmptyBorder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FocusDialog
extends JDialog
implements WindowListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(FocusDialog.class);
    private Dimension minimumDimension;
    private Dimension maximumDimension;
    private boolean firstTimeActivated;
    private JComponent initialFocusComponent;
    private Component locationRelativeComp;
    private boolean keyboardDisposalEnabled = true;

    public FocusDialog(Frame owner, String title, Component locationRelativeComp) {
        super(owner, title, true);
        this.init(locationRelativeComp);
    }

    public FocusDialog(Dialog owner, String title, Component locationRelativeComp) {
        super(owner, title, true);
        this.init(locationRelativeComp);
    }

    private void init(Component locationRelativeComp) {
        this.locationRelativeComp = locationRelativeComp;
        this.setLocationRelativeTo(locationRelativeComp);
        JPanel contentPane = (JPanel)this.getContentPane();
        contentPane.setBorder(new EmptyBorder(6, 8, 6, 8));
        this.setResizable(true);
        this.setDefaultCloseOperation(2);
        InputMap inputMap = contentPane.getInputMap(2);
        ActionMap actionMap = contentPane.getActionMap();
        AbstractAction disposeAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                if (FocusDialog.this.keyboardDisposalEnabled) {
                    FocusDialog.this.cancel();
                }
            }
        };
        inputMap.put(KeyStroke.getKeyStroke(27, 0), "CUSTOM_DISPOSE_EVENT");
        actionMap.put("CUSTOM_DISPOSE_EVENT", disposeAction);
        if (OsFamilies.MAC_OS_X.isCurrent()) {
            inputMap.put(KeyStroke.getKeyStroke(87, 4), "CUSTOM_DISPOSE_EVENT");
        }
    }

    public void cancel() {
        this.dispose();
    }

    public void setInitialFocusComponent(JComponent initialFocusComponent) {
        this.initialFocusComponent = initialFocusComponent;
        if (initialFocusComponent == null) {
            this.removeWindowListener(this);
        } else {
            this.addWindowListener(this);
        }
    }

    public void setMaximumSize(Dimension dimension) {
        this.maximumDimension = dimension;
    }

    public void setMinimumSize(Dimension dimension) {
        this.minimumDimension = dimension;
    }

    public void setKeyboardDisposalEnabled(boolean enabled) {
        this.keyboardDisposalEnabled = enabled;
    }

    public void pack() {
        super.pack();
        if (this.maximumDimension != null) {
            DialogToolkit.fitToMaxDimension(this, this.maximumDimension);
        } else {
            DialogToolkit.fitToScreen(this);
        }
        if (this.minimumDimension != null) {
            DialogToolkit.fitToMinDimension(this, this.minimumDimension);
        }
    }

    public void showDialog() {
        this.pack();
        if (this.locationRelativeComp == null) {
            DialogToolkit.centerOnScreen(this);
        } else {
            this.setLocation(this.locationRelativeComp.getX() + (this.locationRelativeComp.getWidth() - this.getWidth()) / 2, this.locationRelativeComp.getY() + (this.locationRelativeComp.getHeight() - this.getHeight()) / 2);
        }
        this.setVisible(true);
    }

    public void windowOpened(WindowEvent e) {
    }

    public void windowActivated(WindowEvent e) {
        if (!this.firstTimeActivated && this.initialFocusComponent != null) {
            LOGGER.trace("requesting focus on initial focus component");
            if (!this.initialFocusComponent.requestFocusInWindow()) {
                LOGGER.trace("requestFocusInWindow failed, calling requestFocus");
                FocusRequester.requestFocus(this.initialFocusComponent);
            }
            this.firstTimeActivated = true;
        }
    }

    public void windowClosing(WindowEvent e) {
    }

    public void windowClosed(WindowEvent e) {
    }

    public void windowDeactivated(WindowEvent e) {
    }

    public void windowIconified(WindowEvent e) {
    }

    public void windowDeiconified(WindowEvent e) {
    }
}

