/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.ui.dialog.about;

import com.mucommander.RuntimeConstants;
import com.mucommander.desktop.DesktopManager;
import com.mucommander.text.Translator;
import com.mucommander.ui.action.ActionProperties;
import com.mucommander.ui.dialog.FocusDialog;
import com.mucommander.ui.dialog.about.LicenseDialog;
import com.mucommander.ui.icon.IconManager;
import com.mucommander.ui.main.MainFrame;
import com.mucommander.ui.theme.ThemeManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.net.URL;
import java.util.Locale;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;
import javax.swing.text.StyledDocument;

public class AboutDialog
extends FocusDialog
implements ActionListener {
    private static final String LINE_BREAK = System.getProperty("line.separator");
    private JButton okButton;
    private JButton homeButton;
    private JButton licenseButton;
    private JScrollPane textPanel;

    public AboutDialog(MainFrame mainFrame) {
        super((Frame)mainFrame, ActionProperties.getActionLabel("ShowAbout"), (Component)mainFrame);
        Container contentPane = this.getContentPane();
        contentPane.add((Component)this.createIconPanel(), "West");
        contentPane.add((Component)this.createCreditsPanel(), "East");
        this.setResizable(false);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                AboutDialog.this.textPanel.getViewport().setViewPosition(new Point(0, 0));
            }
        });
        this.pack();
        this.setInitialFocusComponent(this.okButton);
        this.getRootPane().setDefaultButton(this.okButton);
    }

    private JScrollPane createCreditsPanel() {
        JTextPane text = new JTextPane();
        StyledDocument doc = text.getStyledDocument();
        text.setBackground(ThemeManager.getCurrentColor(1));
        AboutDialog.setStyles(doc);
        text.setEditable(false);
        try {
            AboutDialog.insertTitle(doc, "The muCommander team");
            AboutDialog.insertHeader(doc, "Core developers");
            AboutDialog.insertNormalString(doc, "Maxence Bernard");
            AboutDialog.insertNormalString(doc, "Arik Hadas");
            AboutDialog.insertNormalString(doc, "Mariusz Jakubowski");
            AboutDialog.insertNormalString(doc, "Nicolas Rinaudo");
            AboutDialog.insertLineBreak(doc);
            AboutDialog.insertHeader(doc, "Contributors");
            AboutDialog.insertNormalString(doc, "Ivan Baidakov");
            AboutDialog.insertNormalString(doc, "Vassil Dichev");
            AboutDialog.insertNormalString(doc, "Karel Klic");
            AboutDialog.insertNormalString(doc, "David Kovar");
            AboutDialog.insertNormalString(doc, "Joshua Lebo");
            AboutDialog.insertNormalString(doc, "LeO");
            AboutDialog.insertNormalString(doc, "Xavier Martin");
            AboutDialog.insertNormalString(doc, "Alejandro Scandroli");
            AboutDialog.insertNormalString(doc, "Alexander Yerenkow");
            AboutDialog.insertNormalString(doc, "Johann Schmitz");
            AboutDialog.insertLineBreak(doc);
            AboutDialog.insertHeader(doc, "QA");
            AboutDialog.insertNormalString(doc, "Joshua Lebo");
            AboutDialog.insertLineBreak(doc);
            AboutDialog.insertHeader(doc, "Translators");
            AboutDialog.insertDetailedString(doc, "4X_Pro", "Russian");
            AboutDialog.insertDetailedString(doc, "Roberto Angeletti", "Italian");
            AboutDialog.insertDetailedString(doc, "Emre Ayta\u00e7", "Turkish");
            AboutDialog.insertDetailedString(doc, "Tam\u00e1s Balogh-Walder", "Hungarian");
            AboutDialog.insertDetailedString(doc, "Mykola Bilovus", "Ukrainian");
            AboutDialog.insertDetailedString(doc, "ChArLoK_16", "Arabic");
            AboutDialog.insertDetailedString(doc, "Gy\u00f6rgy Varga", "Hungarian");
            AboutDialog.insertDetailedString(doc, "Frank Berger", "German");
            AboutDialog.insertDetailedString(doc, "Tony Kl\u00fcver", "German");
            AboutDialog.insertDetailedString(doc, "Marcos Cobe\u00f1a", "Spanish");
            AboutDialog.insertDetailedString(doc, "Cristiano Duarte", "Brazilian Portuguese");
            AboutDialog.insertDetailedString(doc, "Jakob Ekstr\u00f6m", "Swedish");
            AboutDialog.insertDetailedString(doc, "Catalin Hritcu", "Romanian");
            AboutDialog.insertDetailedString(doc, "Kent Hsu", "Traditional Chinese");
            AboutDialog.insertDetailedString(doc, "Jioh L. Jung", "Korean");
            AboutDialog.insertDetailedString(doc, "Andrzej Kosi\u0144ski", "Polish");
            AboutDialog.insertDetailedString(doc, "Joze Kovacic", "Slovenian");
            AboutDialog.insertDetailedString(doc, "Oleksandr Kovalchuk", "Ukrainian");
            AboutDialog.insertDetailedString(doc, "Pieter Kristensen", "Dutch");
            AboutDialog.insertDetailedString(doc, "J\u00e1n \u013dudv\u00edk", "Slovak");
            AboutDialog.insertDetailedString(doc, "Jarom\u00edr M\u00e1ra", "Czech");
            AboutDialog.insertDetailedString(doc, "Xavi Mir\u00f3", "Spanish");
            AboutDialog.insertDetailedString(doc, "Evgeny Morozov", "Russian");
            AboutDialog.insertDetailedString(doc, "Jonathan Murphy", "British English");
            AboutDialog.insertDetailedString(doc, "Nardog", "Japanese");
            AboutDialog.insertDetailedString(doc, "Jordi Plantalech", "Catalan");
            AboutDialog.insertDetailedString(doc, "Alexey Sirotov", "Russian");
            AboutDialog.insertDetailedString(doc, "Jeppe Toustrup", "Danish");
            AboutDialog.insertDetailedString(doc, "Peter Vasko", "Czech");
            AboutDialog.insertDetailedString(doc, "vboo", "Belarusian");
            AboutDialog.insertDetailedString(doc, "whiteriver", "Simplified Chinese");
            AboutDialog.insertLineBreak(doc);
            AboutDialog.insertHeader(doc, "Special thanks");
            AboutDialog.insertDetailedString(doc, "Semyon Filippov", "muCommander icon");
            AboutDialog.insertDetailedString(doc, "Stefano Perelli", "Former muCommander icon");
            AboutDialog.insertLineBreak(doc);
            AboutDialog.insertLineBreak(doc);
            AboutDialog.insertTitle(doc, "Powered by");
            AboutDialog.insertHeader(doc, "Libraries");
            AboutDialog.insertDetailedUrl(doc, "Ant", "Apache License", "http://ant.apache.org");
            AboutDialog.insertDetailedUrl(doc, "Apache Commons", "Apache License", "http://commons.apache.org");
            AboutDialog.insertDetailedUrl(doc, "Apache Hadoop", "Apache License", "http://hadoop.apache.org");
            AboutDialog.insertDetailedUrl(doc, "Furbelow", "LGPL", "http://sourceforge.net/projects/furbelow");
            AboutDialog.insertDetailedUrl(doc, "ICU4J", "ICU License", "http://www.icu-project.org");
            AboutDialog.insertDetailedUrl(doc, "J2SSH", "LGPL", "http://sourceforge.net/projects/sshtools");
            AboutDialog.insertDetailedUrl(doc, "J7Zip", "LGPL", "http://sourceforge.net/projects/p7zip/");
            AboutDialog.insertDetailedUrl(doc, "jCIFS", "LGPL", "http://jcifs.samba.org");
            AboutDialog.insertDetailedUrl(doc, "JetS3t", "Apache License", "http://jets3t.s3.amazonaws.com/index.html");
            AboutDialog.insertDetailedUrl(doc, "JmDNS", "LGPL", "http://jmdns.sourceforge.net");
            AboutDialog.insertDetailedUrl(doc, "JNA", "LGPL", "http://jna.dev.java.net");
            AboutDialog.insertDetailedUrl(doc, "JUnRar", "Freeware", "http://sourceforge.net/projects/java-unrar");
            AboutDialog.insertDetailedUrl(doc, "Yanfs", "BSD", "http://yanfs.dev.java.net");
            AboutDialog.insertDetailedUrl(doc, "Mark James' icons", "Creative Commons Attribution License", "http://famfamfam.com");
            AboutDialog.insertLineBreak(doc);
            AboutDialog.insertHeader(doc, "Tools");
            AboutDialog.insertDetailedUrl(doc, "Ant", "Apache Software License", "http://ant.apache.org");
            AboutDialog.insertDetailedUrl(doc, "AntDoclet", "GPL", "http://antdoclet.neuroning.com/");
            AboutDialog.insertDetailedUrl(doc, "jdeb", "Apache Software License", "http://vafer.org/projects/jdeb/");
            AboutDialog.insertDetailedUrl(doc, "Launch4j", "GPL", "http://launch4j.sourceforge.net");
            AboutDialog.insertDetailedUrl(doc, "NSIS", "zlib/libpng license", "http://nsis.sourceforge.net");
            AboutDialog.insertDetailedUrl(doc, "p7zip", "LGPL", "http://p7zip.sourceforge.net");
            AboutDialog.insertDetailedUrl(doc, "ProGuard", "GPL", "http://proguard.sourceforge.net");
            AboutDialog.insertLineBreak(doc);
            AboutDialog.insertLineBreak(doc);
            AboutDialog.insertTitle(doc, "Version information");
            AboutDialog.insertHeader(doc, "muCommander");
            AboutDialog.insertNormalString(doc, "Version: " + RuntimeConstants.VERSION);
            AboutDialog.insertNormalString(doc, "Build date: " + this.getFormatedDate());
            AboutDialog.insertLineBreak(doc);
            AboutDialog.insertHeader(doc, "Java");
            AboutDialog.insertNormalString(doc, "Runtime version: " + System.getProperty("java.version"));
            AboutDialog.insertNormalString(doc, "VM name: " + System.getProperty("java.vm.name"));
            AboutDialog.insertNormalString(doc, "VM version: " + System.getProperty("java.vm.version"));
            AboutDialog.insertNormalString(doc, "VM vendor: " + System.getProperty("java.vm.vendor"));
            AboutDialog.insertLineBreak(doc);
            AboutDialog.insertHeader(doc, "OS");
            AboutDialog.insertNormalString(doc, "Name: " + System.getProperty("os.name"));
            AboutDialog.insertNormalString(doc, "Version: " + System.getProperty("os.version"));
            AboutDialog.insertNormalString(doc, "Architecture: " + System.getProperty("os.arch"));
            AboutDialog.insertLineBreak(doc);
            Locale locale = Locale.getDefault();
            AboutDialog.insertHeader(doc, "Locale");
            AboutDialog.insertNormalString(doc, "Language: " + locale.getLanguage());
            AboutDialog.insertNormalString(doc, "Country: " + locale.getCountry());
            AboutDialog.insertNormalString(doc, "Encoding: " + System.getProperty("file.encoding"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.textPanel = new JScrollPane(text, 20, 31);
        this.textPanel.getViewport().setPreferredSize(new Dimension((int)text.getPreferredSize().getWidth(), 300));
        return this.textPanel;
    }

    private JPanel createIconPanel() {
        JPanel mainPanel = new JPanel(new BorderLayout()){

            public Insets getInsets() {
                return new Insets(10, 10, 0, 10);
            }
        };
        JPanel tempPanel = new JPanel(new BorderLayout());
        tempPanel.add((Component)new JLabel(IconManager.getIcon(7, "icon128_24.png")), "North");
        JPanel flowPanel = new JPanel(new FlowLayout(1));
        flowPanel.add(this.createBoldLabel(RuntimeConstants.APP_STRING));
        tempPanel.add((Component)flowPanel, "Center");
        flowPanel = new JPanel(new FlowLayout(1));
        flowPanel.add(new JLabel("\u00a9" + RuntimeConstants.COPYRIGHT + " Maxence Bernard"));
        tempPanel.add((Component)flowPanel, "South");
        mainPanel.add((Component)tempPanel, "North");
        tempPanel = new JPanel(new BorderLayout());
        if (DesktopManager.canBrowse()) {
            this.homeButton = new JButton(ActionProperties.getActionLabel("GoToWebsite"));
            tempPanel.add((Component)this.homeButton, "North");
            this.homeButton.addActionListener(this);
        } else {
            flowPanel = new JPanel(new FlowLayout(1));
            flowPanel.add(new JLabel("http://www.mucommander.com"));
            tempPanel.add((Component)flowPanel, "North");
        }
        this.licenseButton = new JButton(Translator.get("license", new String[0]));
        tempPanel.add((Component)this.licenseButton, "Center");
        this.licenseButton.addActionListener(this);
        this.okButton = new JButton(Translator.get("ok", new String[0]));
        tempPanel.add((Component)this.okButton, "South");
        this.okButton.addActionListener(this);
        mainPanel.add((Component)tempPanel, "South");
        return mainPanel;
    }

    private static void setStyles(StyledDocument styledDocument) {
        Style style = StyleContext.getDefaultStyleContext().getStyle("default");
        Font font = ThemeManager.getCurrentFont(0);
        style = styledDocument.addStyle("normal", style);
        StyleConstants.setFontFamily(style, font.getFamily());
        StyleConstants.setFontSize(style, font.getSize());
        StyleConstants.setForeground(style, ThemeManager.getCurrentColor(29));
        StyleConstants.setBackground(style, ThemeManager.getCurrentColor(1));
        StyleConstants.setLeftIndent(style, 10.0f);
        StyleConstants.setRightIndent(style, 10.0f);
        StyleConstants.setLineSpacing(style, 0.2f);
        styledDocument.setParagraphAttributes(0, 0, style, true);
        Style style2 = styledDocument.addStyle("header", style);
        StyleConstants.setBold(style2, true);
        StyleConstants.setFontSize(style2, font.getSize() + 2);
        StyleConstants.setForeground(style2, ThemeManager.getCurrentColor(13));
        StyleConstants.setBackground(style2, ThemeManager.getCurrentColor(1));
        style2 = styledDocument.addStyle("title", style2);
        StyleConstants.setAlignment(style2, 1);
        StyleConstants.setForeground(style2, ThemeManager.getCurrentColor(17));
        StyleConstants.setBackground(style2, ThemeManager.getCurrentColor(1));
        style2 = styledDocument.addStyle("details", style);
        StyleConstants.setForeground(style2, ThemeManager.getCurrentColor(9));
        StyleConstants.setBackground(style2, ThemeManager.getCurrentColor(1));
        style2 = styledDocument.addStyle("url", style);
        StyleConstants.setForeground(style2, ThemeManager.getCurrentColor(21));
        StyleConstants.setBackground(style2, ThemeManager.getCurrentColor(1));
        StyleConstants.setUnderline(style2, true);
    }

    private static void insertHeader(StyledDocument styledDocument, String string) throws BadLocationException {
        styledDocument.insertString(styledDocument.getLength(), string + LINE_BREAK, styledDocument.getStyle("header"));
    }

    private static void insertNormalString(StyledDocument doc, String string) throws BadLocationException {
        doc.insertString(doc.getLength(), string + LINE_BREAK, doc.getStyle("normal"));
    }

    private static void insertDetailedString(StyledDocument styledDocument, String string, String string2) throws BadLocationException {
        styledDocument.insertString(styledDocument.getLength(), string + " ", styledDocument.getStyle("normal"));
        styledDocument.insertString(styledDocument.getLength(), "(" + string2 + ")" + LINE_BREAK, styledDocument.getStyle("details"));
    }

    private static void insertUrl(StyledDocument styledDocument, String string) throws BadLocationException {
        styledDocument.insertString(styledDocument.getLength(), "    ", styledDocument.getStyle("normal"));
        styledDocument.insertString(styledDocument.getLength(), string + LINE_BREAK, styledDocument.getStyle("url"));
    }

    private static void insertLineBreak(StyledDocument doc) throws BadLocationException {
        doc.insertString(doc.getLength(), LINE_BREAK, doc.getStyle("normal"));
    }

    private static void insertDetailedUrl(StyledDocument doc, String string, String details, String url) throws BadLocationException {
        AboutDialog.insertDetailedString(doc, string, details);
        AboutDialog.insertUrl(doc, url);
    }

    private static void insertTitle(StyledDocument styledDocument, String string) throws BadLocationException {
        string = string + LINE_BREAK;
        int n = styledDocument.getLength();
        Style style = styledDocument.getStyle("title");
        styledDocument.insertString(n, string, style);
        styledDocument.setParagraphAttributes(n, string.length(), style, true);
        styledDocument.setParagraphAttributes(styledDocument.getLength(), 0, styledDocument.getStyle("normal"), true);
        AboutDialog.insertLineBreak(styledDocument);
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.okButton) {
            this.dispose();
        } else if (e.getSource() == this.homeButton) {
            try {
                DesktopManager.browse(new URL("http://www.mucommander.com"));
            }
            catch (IOException iOException) {}
        } else if (e.getSource() == this.licenseButton) {
            new LicenseDialog(this).showDialog();
        }
    }

    private String getFormatedDate() {
        StringBuilder buffer = new StringBuilder(RuntimeConstants.BUILD_DATE.substring(0, 4));
        buffer.append('/');
        buffer.append(RuntimeConstants.BUILD_DATE.substring(4, 6));
        buffer.append('/');
        buffer.append(RuntimeConstants.BUILD_DATE.substring(6, 8));
        return buffer.toString();
    }

    private JLabel createBoldLabel(String text) {
        JLabel label = new JLabel(text);
        Font font = label.getFont();
        label.setFont(new Font(font.getFontName(), font.getStyle() | 1, font.getSize()));
        return label;
    }
}

