/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.ui.dialog.auth;

import com.mucommander.auth.CredentialsManager;
import com.mucommander.auth.CredentialsMapping;
import com.mucommander.commons.file.Credentials;
import com.mucommander.commons.file.FileURL;
import com.mucommander.commons.util.StringUtils;
import com.mucommander.text.Translator;
import com.mucommander.ui.combobox.EditableComboBox;
import com.mucommander.ui.combobox.EditableComboBoxListener;
import com.mucommander.ui.combobox.SaneComboBox;
import com.mucommander.ui.dialog.DialogToolkit;
import com.mucommander.ui.dialog.FocusDialog;
import com.mucommander.ui.helper.FocusRequester;
import com.mucommander.ui.layout.InformationPane;
import com.mucommander.ui.layout.XAlignedComponentPanel;
import com.mucommander.ui.layout.YBoxPanel;
import com.mucommander.ui.main.MainFrame;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JTextField;

public class AuthDialog
extends FocusDialog
implements EditableComboBoxListener,
ActionListener {
    private JButton okButton;
    private JButton cancelButton;
    private JRadioButton guestRadioButton;
    private JRadioButton userRadioButton;
    private JTextField loginField;
    private EditableComboBox loginComboBox;
    private JPasswordField passwordField;
    private JCheckBox saveCredentialsCheckBox;
    private CredentialsMapping selectedCredentialsMapping;
    private boolean guestCredentialsSelected;
    private FileURL fileURL;
    private CredentialsMapping[] credentialsMappings;
    private static final Dimension MINIMUM_DIALOG_DIMENSION = new Dimension(320, 0);
    private static final Dimension MAXIMUM_DIALOG_DIMENSION = new Dimension(480, 10000);

    public AuthDialog(MainFrame mainFrame, FileURL fileURL, boolean authFailed, String errorMessage) {
        super((Frame)mainFrame, Translator.get("auth_dialog.title", new String[0]), (Component)mainFrame);
        JComponent loginComponent;
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        YBoxPanel yPanel = new YBoxPanel();
        if (authFailed) {
            yPanel.add(new InformationPane(Translator.get("auth_dialog.authentication_failed", new String[0]), errorMessage, errorMessage == null ? 0 : 1, 1));
            yPanel.addSpace(5);
            yPanel.add(new JSeparator());
        }
        yPanel.addSpace(5);
        this.fileURL = fileURL;
        Credentials guestCredentials = fileURL.getGuestCredentials();
        Credentials urlCredentials = fileURL.getCredentials();
        if (urlCredentials != null && guestCredentials != null && urlCredentials.equals(guestCredentials)) {
            urlCredentials = null;
        }
        this.credentialsMappings = CredentialsManager.getMatchingCredentials(fileURL);
        XAlignedComponentPanel compPanel = new XAlignedComponentPanel(10);
        if (guestCredentials != null) {
            this.guestRadioButton = new JRadioButton(StringUtils.capitalize(guestCredentials.getLogin()));
            this.guestRadioButton.addActionListener(this);
            compPanel.addRow(Translator.get("auth_dialog.connect_as", new String[0]), (JComponent)this.guestRadioButton, 0);
            this.userRadioButton = new JRadioButton(Translator.get("user", new String[0]));
            this.userRadioButton.addActionListener(this);
            compPanel.addRow("", (JComponent)this.userRadioButton, 15);
            ButtonGroup buttonGroup = new ButtonGroup();
            buttonGroup.add(this.guestRadioButton);
            buttonGroup.add(this.userRadioButton);
        } else {
            yPanel.add(new JLabel(Translator.get("auth_dialog.desc", new String[0])));
            yPanel.addSpace(15);
        }
        compPanel.addRow(Translator.get("auth_dialog.server", new String[0]), (JComponent)new JLabel(fileURL.toString(false)), 10);
        int nbCredentials = this.credentialsMappings.length;
        if (nbCredentials > 0) {
            this.loginComboBox = new EditableComboBox();
            this.loginField = this.loginComboBox.getTextField();
            for (int i = 0; i < nbCredentials; ++i) {
                this.loginComboBox.addItem(this.credentialsMappings[i].getCredentials().getLogin());
            }
            this.loginComboBox.addEditableComboBoxListener(this);
            loginComponent = this.loginComboBox;
        } else {
            loginComponent = this.loginField = new JTextField();
        }
        compPanel.addRow(Translator.get("login", new String[0]), loginComponent, 5);
        this.passwordField = new JPasswordField();
        this.passwordField.addActionListener(this);
        compPanel.addRow(Translator.get("password", new String[0]), (JComponent)this.passwordField, 10);
        Credentials selectedCredentials = null;
        boolean saveCredentialsCheckBoxSelected = false;
        if (urlCredentials != null) {
            selectedCredentials = urlCredentials;
        } else if (nbCredentials > 0) {
            CredentialsMapping bestCredentialsMapping = this.credentialsMappings[0];
            selectedCredentials = bestCredentialsMapping.getCredentials();
            saveCredentialsCheckBoxSelected = bestCredentialsMapping.isPersistent();
        }
        yPanel.add(compPanel);
        this.saveCredentialsCheckBox = new JCheckBox(Translator.get("auth_dialog.store_credentials", new String[0]), saveCredentialsCheckBoxSelected);
        yPanel.add(this.saveCredentialsCheckBox);
        yPanel.addSpace(5);
        contentPane.add((Component)yPanel, "Center");
        if (selectedCredentials != null) {
            this.loginField.setText(selectedCredentials.getLogin());
            this.passwordField.setText(selectedCredentials.getPassword());
            this.loginField.selectAll();
            this.passwordField.selectAll();
            if (this.userRadioButton != null) {
                this.userRadioButton.setSelected(true);
            }
        } else {
            this.loginField.setText(System.getProperty("user.name"));
            if (this.guestRadioButton != null) {
                this.guestRadioButton.setSelected(true);
                this.loginField.setEnabled(false);
                this.passwordField.setEnabled(false);
                this.saveCredentialsCheckBox.setEnabled(false);
            }
        }
        this.okButton = new JButton(Translator.get("ok", new String[0]));
        this.cancelButton = new JButton(Translator.get("cancel", new String[0]));
        contentPane.add((Component)DialogToolkit.createOKCancelPanel(this.okButton, this.cancelButton, this.getRootPane(), this), "South");
        this.setInitialFocusComponent(this.guestRadioButton == null ? this.loginField : (this.guestRadioButton.isSelected() ? this.guestRadioButton : this.loginField));
        this.setMinimumSize(MINIMUM_DIALOG_DIMENSION);
        this.setMaximumSize(MAXIMUM_DIALOG_DIMENSION);
    }

    public CredentialsMapping getCredentialsMapping() {
        return this.selectedCredentialsMapping;
    }

    public boolean guestCredentialsSelected() {
        return this.guestCredentialsSelected;
    }

    private void setCredentialMapping() {
        if (this.guestRadioButton != null && this.guestRadioButton.isSelected()) {
            this.guestCredentialsSelected = true;
            this.selectedCredentialsMapping = new CredentialsMapping(this.fileURL.getGuestCredentials(), this.fileURL, false);
        } else {
            Credentials enteredCredentials = new Credentials(this.loginField.getText(), new String(this.passwordField.getPassword()));
            this.guestCredentialsSelected = false;
            boolean isPersistent = this.saveCredentialsCheckBox.isSelected();
            this.selectedCredentialsMapping = new CredentialsMapping(enteredCredentials, this.fileURL, isPersistent);
            for (CredentialsMapping cm : this.credentialsMappings) {
                if (!cm.getCredentials().equals(enteredCredentials, true)) continue;
                this.selectedCredentialsMapping = new CredentialsMapping(cm.getCredentials(), cm.getRealm(), isPersistent);
                break;
            }
        }
    }

    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.okButton || source == this.loginField || source == this.passwordField) {
            this.setCredentialMapping();
            this.dispose();
        } else if (source == this.cancelButton) {
            this.dispose();
        } else if (source == this.guestRadioButton) {
            this.loginField.setEnabled(false);
            this.passwordField.setEnabled(false);
            this.saveCredentialsCheckBox.setEnabled(false);
        } else if (source == this.userRadioButton) {
            this.loginField.setEnabled(true);
            this.passwordField.setEnabled(true);
            this.saveCredentialsCheckBox.setEnabled(true);
            this.loginField.selectAll();
            FocusRequester.requestFocus(this.loginField);
        }
    }

    public void comboBoxSelectionChanged(SaneComboBox source) {
        CredentialsMapping selectedCredentialsMapping = this.credentialsMappings[this.loginComboBox.getSelectedIndex()];
        Credentials selectedCredentials = selectedCredentialsMapping.getCredentials();
        this.loginField.setText(selectedCredentials.getLogin());
        this.passwordField.setText(selectedCredentials.getPassword());
        if (this.saveCredentialsCheckBox != null) {
            this.saveCredentialsCheckBox.setSelected(selectedCredentialsMapping.isPersistent());
        }
    }

    public void textFieldValidated(EditableComboBox source) {
        this.setCredentialMapping();
        this.dispose();
    }

    public void textFieldCancelled(EditableComboBox source) {
    }
}

