/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.ui.dialog.auth;

import com.mucommander.auth.CredentialsManager;
import com.mucommander.auth.CredentialsMapping;
import com.mucommander.commons.collections.AlteredVector;
import com.mucommander.commons.file.Credentials;
import com.mucommander.text.Translator;
import com.mucommander.ui.action.ActionProperties;
import com.mucommander.ui.dialog.FocusDialog;
import com.mucommander.ui.helper.MnemonicHelper;
import com.mucommander.ui.layout.XAlignedComponentPanel;
import com.mucommander.ui.layout.XBoxPanel;
import com.mucommander.ui.layout.YBoxPanel;
import com.mucommander.ui.list.DynamicList;
import com.mucommander.ui.list.SortableListPanel;
import com.mucommander.ui.main.MainFrame;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EditCredentialsDialog
extends FocusDialog
implements ActionListener,
ListSelectionListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(EditCredentialsDialog.class);
    private MainFrame mainFrame;
    private JButton removeButton;
    private JButton goToButton;
    private JButton closeButton;
    private JTextField loginField;
    private JPasswordField passwordField;
    private AlteredVector<CredentialsMapping> credentials;
    private DynamicList<CredentialsMapping> credentialsList;
    private CredentialsMapping lastSelectedItem;
    private static final Dimension MINIMUM_DIALOG_DIMENSION = new Dimension(440, 330);
    private static final Dimension MAXIMUM_DIALOG_DIMENSION = new Dimension(600, 400);

    public EditCredentialsDialog(MainFrame mainFrame) {
        super((Frame)mainFrame, ActionProperties.getActionLabel("EditCredentials"), (Component)mainFrame);
        this.mainFrame = mainFrame;
        Container contentPane = this.getContentPane();
        this.credentials = CredentialsManager.getPersistentCredentialMappings();
        SortableListPanel<CredentialsMapping> listPanel = new SortableListPanel<CredentialsMapping>(this.credentials);
        this.credentialsList = listPanel.getDynamicList();
        this.lastSelectedItem = (CredentialsMapping)this.credentialsList.getSelectedValue();
        contentPane.add(listPanel, "Center");
        XAlignedComponentPanel compPanel = new XAlignedComponentPanel();
        this.loginField = new JTextField();
        compPanel.addRow(Translator.get("login", new String[0]) + ":", (JComponent)this.loginField, 5);
        this.passwordField = new JPasswordField();
        compPanel.addRow(Translator.get("password", new String[0]) + ":", (JComponent)this.passwordField, 10);
        YBoxPanel yPanel = new YBoxPanel(10);
        yPanel.add(compPanel);
        XBoxPanel buttonsPanel = new XBoxPanel();
        MnemonicHelper mnemonicHelper = new MnemonicHelper();
        this.removeButton = new JButton(this.credentialsList.getRemoveAction());
        this.removeButton.setMnemonic(mnemonicHelper.getMnemonic(this.removeButton));
        buttonsPanel.add(this.removeButton);
        this.goToButton = new JButton(Translator.get("go_to", new String[0]));
        this.goToButton.setMnemonic(mnemonicHelper.getMnemonic(this.goToButton));
        this.goToButton.addActionListener(this);
        buttonsPanel.add(this.goToButton);
        this.closeButton = new JButton(Translator.get("close", new String[0]));
        this.closeButton.setMnemonic(mnemonicHelper.getMnemonic(this.closeButton));
        this.closeButton.addActionListener(this);
        buttonsPanel.add(Box.createHorizontalGlue());
        buttonsPanel.add(this.closeButton);
        yPanel.add(buttonsPanel);
        contentPane.add((Component)yPanel, "South");
        this.updateComponents();
        this.credentialsList.addListSelectionListener(this);
        this.setInitialFocusComponent(this.credentialsList);
        this.getRootPane().setDefaultButton(this.closeButton);
        this.setMinimumSize(MINIMUM_DIALOG_DIMENSION);
        this.setMaximumSize(MAXIMUM_DIALOG_DIMENSION);
        this.setDefaultCloseOperation(2);
        this.showDialog();
    }

    private void updateComponents() {
        String loginValue = null;
        String passwordValue = null;
        boolean componentsEnabled = false;
        if (!this.credentialsList.isSelectionEmpty() && this.credentials.size() > 0) {
            componentsEnabled = true;
            CredentialsMapping credentialsMapping = (CredentialsMapping)this.credentialsList.getSelectedValue();
            Credentials credentials = credentialsMapping.getCredentials();
            loginValue = credentials.getLogin();
            passwordValue = credentials.getPassword();
        }
        this.loginField.setText(loginValue);
        this.loginField.setEnabled(componentsEnabled);
        this.passwordField.setText(passwordValue);
        this.passwordField.setEnabled(componentsEnabled);
        this.removeButton.setEnabled(componentsEnabled);
    }

    private void modifyCredentials() {
        int itemIndex = this.credentials.indexOf(this.lastSelectedItem);
        if (this.lastSelectedItem != null && itemIndex != -1) {
            this.credentials.setElementAt(new CredentialsMapping(new Credentials(this.loginField.getText(), new String(this.passwordField.getPassword())), this.lastSelectedItem.getRealm(), true), itemIndex);
        }
        this.lastSelectedItem = (CredentialsMapping)this.credentialsList.getSelectedValue();
    }

    public void dispose() {
        super.dispose();
        try {
            CredentialsManager.writeCredentials(false);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.closeButton) {
            this.modifyCredentials();
            this.dispose();
        } else if (source == this.goToButton) {
            this.dispose();
            this.mainFrame.getActivePanel().tryChangeCurrentFolder(((CredentialsMapping)this.credentialsList.getSelectedValue()).getRealm());
        }
    }

    public void valueChanged(ListSelectionEvent e) {
        LOGGER.trace("called, e.getValueIsAdjusting=" + e.getValueIsAdjusting() + " getSelectedIndex=" + this.credentialsList.getSelectedIndex());
        if (e.getValueIsAdjusting()) {
            return;
        }
        this.modifyCredentials();
        this.updateComponents();
    }
}

