/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.ui.dialog.bookmark;

import com.mucommander.bookmark.Bookmark;
import com.mucommander.bookmark.BookmarkManager;
import com.mucommander.commons.file.AbstractFile;
import com.mucommander.text.Translator;
import com.mucommander.ui.action.ActionProperties;
import com.mucommander.ui.dialog.DialogToolkit;
import com.mucommander.ui.dialog.FocusDialog;
import com.mucommander.ui.layout.XAlignedComponentPanel;
import com.mucommander.ui.layout.YBoxPanel;
import com.mucommander.ui.main.MainFrame;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class AddBookmarkDialog
extends FocusDialog
implements ActionListener,
DocumentListener {
    private JTextField nameField;
    private JTextField locationField;
    private JButton addButton;
    private JButton cancelButton;
    private static final Dimension MINIMUM_DIALOG_DIMENSION = new Dimension(320, 0);
    private static final Dimension MAXIMUM_DIALOG_DIMENSION = new Dimension(400, 10000);

    public AddBookmarkDialog(MainFrame mainFrame) {
        super((Frame)mainFrame, ActionProperties.getActionLabel("AddBookmark"), (Component)mainFrame);
        Container contentPane = this.getContentPane();
        YBoxPanel mainPanel = new YBoxPanel(5);
        AbstractFile currentFolder = mainFrame.getActiveTable().getCurrentFolder();
        XAlignedComponentPanel compPanel = new XAlignedComponentPanel();
        this.nameField = new JTextField(currentFolder.getName());
        this.nameField.setEditable(true);
        this.nameField.getDocument().addDocumentListener(this);
        compPanel.addRow(Translator.get("name", new String[0]) + ":", (JComponent)this.nameField, 10);
        this.locationField = new JTextField(currentFolder.getCanonicalPath());
        compPanel.addRow(Translator.get("location", new String[0]) + ":", (JComponent)this.locationField, 10);
        mainPanel.add(compPanel);
        contentPane.add((Component)mainPanel, "North");
        this.addButton = new JButton(Translator.get("add_bookmark_dialog.add", new String[0]));
        this.cancelButton = new JButton(Translator.get("cancel", new String[0]));
        contentPane.add((Component)DialogToolkit.createOKCancelPanel(this.addButton, this.cancelButton, this.getRootPane(), this), "South");
        this.nameField.selectAll();
        this.setInitialFocusComponent(this.nameField);
        this.setMinimumSize(MINIMUM_DIALOG_DIMENSION);
        this.setMaximumSize(MAXIMUM_DIALOG_DIMENSION);
        this.showDialog();
    }

    private void checkEmptyName() {
        if (this.nameField.getText().trim().equals("")) {
            if (this.addButton.isEnabled()) {
                this.addButton.setEnabled(false);
            }
        } else if (!this.addButton.isEnabled()) {
            this.addButton.setEnabled(true);
        }
    }

    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.addButton) {
            this.dispose();
            BookmarkManager.addBookmark(new Bookmark(this.nameField.getText(), this.locationField.getText()));
            try {
                BookmarkManager.writeBookmarks(false);
            }
            catch (Exception exception) {}
        } else if (source == this.cancelButton) {
            this.dispose();
        }
    }

    public void changedUpdate(DocumentEvent e) {
        this.checkEmptyName();
    }

    public void insertUpdate(DocumentEvent e) {
        this.checkEmptyName();
    }

    public void removeUpdate(DocumentEvent e) {
        this.checkEmptyName();
    }
}

