/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.ui.dialog.customization;

import com.mucommander.commons.collections.AlteredVector;
import com.mucommander.text.Translator;
import com.mucommander.ui.action.ActionManager;
import com.mucommander.ui.action.ActionProperties;
import com.mucommander.ui.dialog.customization.CustomizeDialog;
import com.mucommander.ui.layout.YBoxPanel;
import com.mucommander.ui.list.DynamicHorizontalWrapList;
import com.mucommander.ui.list.DynamicList;
import com.mucommander.ui.main.MainFrame;
import com.mucommander.ui.main.commandbar.CommandBarAttributes;
import com.mucommander.ui.main.commandbar.CommandBarButtonForDisplay;
import com.mucommander.ui.main.commandbar.CommandBarIO;
import com.mucommander.ui.text.RecordingKeyStrokeTextField;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.KeyEvent;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DropMode;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.TransferHandler;
import javax.swing.UIManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommandBarDialog
extends CustomizeDialog {
    private DynamicHorizontalWrapList<JButton> commandBarAvailableButtonsList;
    private DynamicList<JButton> commandBarButtonsList;
    private DynamicList<JButton> commandBarAlternateButtonsList;
    private AlteredVector<JButton> commandBarAvailableButtons;
    private AlteredVector<JButton> commandBarButtons;
    private AlteredVector<JButton> commandBarAlternateButtons;
    private RecordingKeyStrokeTextField modifierField;
    private static final Color JBUTTON_BACKGROUND_COLOR = UIManager.getColor("button.background");
    private static final Comparator<JButton> BUTTONS_COMPARATOR = new Comparator<JButton>(){

        @Override
        public int compare(JButton b1, JButton b2) {
            if (b1.getText() == null) {
                return 1;
            }
            if (b2.getText() == null) {
                return -1;
            }
            return b1.getText().compareTo(b2.getText());
        }
    };

    public CommandBarDialog(MainFrame mainFrame) {
        super((Frame)mainFrame, ActionProperties.getActionLabel("CustomizeCommandBar"));
    }

    protected void componentChanged() {
        this.setCommitButtonsEnabled(this.getNumberOfButtons() > 0 && (this.areActionsChanged() || this.areAlternativeActionsChanged() || this.isModifierChanged()));
    }

    @Override
    protected void commit() {
        int nbNewActions = this.getNumberOfButtons();
        String[] newActionIds = new String[nbNewActions];
        for (int i = 0; i < nbNewActions; ++i) {
            newActionIds[i] = ((CommandBarButtonForDisplay)this.commandBarButtons.get(i)).getActionId();
        }
        int nbNewAlternativeActions = this.commandBarAlternateButtons.size();
        String[] newAlternativeActionIds = new String[nbNewAlternativeActions];
        for (int i = 0; i < nbNewAlternativeActions; ++i) {
            Object button = this.commandBarAlternateButtons.get(i);
            newAlternativeActionIds[i] = button != null ? ((CommandBarButtonForDisplay)button).getActionId() : null;
        }
        CommandBarAttributes.setAttributes(newActionIds, newAlternativeActionIds, this.modifierField.getKeyStroke());
        CommandBarIO.setModified();
    }

    @Override
    protected JPanel createCustomizationPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        this.commandBarAvailableButtons = new AlteredVector();
        this.commandBarButtons = new AlteredVector();
        this.commandBarAlternateButtons = new AlteredVector();
        HashSet<String> usedActions = new HashSet<String>();
        usedActions.addAll(this.initCommandBarActionsList());
        usedActions.addAll(this.initCommandBarAlternateActionsList());
        this.initActionsPoolList(usedActions);
        panel.add((Component)this.createAvailableButtonsPanel(), "Center");
        panel.add((Component)this.createCommandBarPanel(), "South");
        return panel;
    }

    private boolean areActionsChanged() {
        String[] commandBarActionIds = CommandBarAttributes.getActions();
        int nbActions = commandBarActionIds.length;
        if (nbActions != this.getNumberOfButtons()) {
            return true;
        }
        for (int i = 0; i < nbActions; ++i) {
            CommandBarButtonForDisplay buttonI = (CommandBarButtonForDisplay)this.commandBarButtons.get(i);
            if (!(buttonI == null ? commandBarActionIds[i] != null : !buttonI.getActionId().equals(commandBarActionIds[i]))) continue;
            return true;
        }
        return false;
    }

    private boolean areAlternativeActionsChanged() {
        String[] commandBarAlternativeActionIds = CommandBarAttributes.getAlternateActions();
        int nbActions = commandBarAlternativeActionIds.length;
        if (nbActions != this.commandBarAlternateButtons.size()) {
            return true;
        }
        for (int i = 0; i < nbActions; ++i) {
            CommandBarButtonForDisplay buttonI = (CommandBarButtonForDisplay)this.commandBarAlternateButtons.get(i);
            if (!(buttonI == null ? commandBarAlternativeActionIds[i] != null : !buttonI.getActionId().equals(commandBarAlternativeActionIds[i]))) continue;
            return true;
        }
        return false;
    }

    private boolean isModifierChanged() {
        return !this.modifierField.getKeyStroke().equals(CommandBarAttributes.getModifier());
    }

    private Collection<String> initCommandBarActionsList() {
        String[] commandBarActionIds = CommandBarAttributes.getActions();
        int nbCommandBarActionIds = commandBarActionIds.length;
        for (int i = 0; i < nbCommandBarActionIds; ++i) {
            this.commandBarButtons.add(CommandBarButtonForDisplay.create(commandBarActionIds[i]));
        }
        this.commandBarButtonsList = new DynamicList<JButton>(this.commandBarButtons);
        this.commandBarButtonsList.setCellRenderer(new CommandBarButtonListCellRenderer());
        this.commandBarButtonsList.setLayoutOrientation(2);
        this.commandBarButtonsList.setVisibleRowCount(1);
        this.commandBarButtonsList.setDragEnabled(true);
        this.commandBarButtonsList.setTransferHandler(new TransferHandler(){

            public int getSourceActions(JComponent c) {
                return 2;
            }

            public Transferable createTransferable(JComponent c) {
                if (c instanceof JList) {
                    JList list = (JList)c;
                    return new TransferableButton((JButton)list.getSelectedValue());
                }
                return null;
            }

            public void exportDone(JComponent c, Transferable t, int action) {
                if (action == 2) {
                    JList list = (JList)c;
                    CommandBarDialog.this.removeCommandBarButtonAtIndex(list.getSelectedIndex());
                    CommandBarDialog.this.componentChanged();
                }
            }

            public boolean canImport(TransferHandler.TransferSupport support) {
                return support.isDataFlavorSupported(TransferableButton.buttonFlavor);
            }

            public boolean importData(TransferHandler.TransferSupport support) {
                if (!this.canImport(support)) {
                    return false;
                }
                try {
                    Point dropLocation = support.getDropLocation().getDropPoint();
                    JButton button = (JButton)support.getTransferable().getTransferData(TransferableButton.buttonFlavor);
                    int index = CommandBarDialog.this.addCommandBarButtonAtLocation(dropLocation, button);
                    CommandBarDialog.this.commandBarButtonsList.ensureIndexIsVisible(index);
                    CommandBarDialog.this.commandBarButtonsList.repaint();
                    return true;
                }
                catch (UnsupportedFlavorException e) {
                    e.printStackTrace();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                return false;
            }
        });
        this.commandBarButtonsList.setBackground(JBUTTON_BACKGROUND_COLOR);
        this.commandBarButtonsList.setDropMode(DropMode.INSERT);
        return Arrays.asList(commandBarActionIds);
    }

    private void removeCommandBarButtonAtIndex(int index) {
        JButton alternateButtonAtIndex;
        this.commandBarButtons.remove(index);
        if (this.commandBarButtons.size() == 0) {
            this.commandBarButtons.add(null);
            this.commandBarButtonsList.setDropMode(DropMode.ON);
        }
        if ((alternateButtonAtIndex = this.commandBarAlternateButtons.remove(index)) != null) {
            CommandBarDialog.insertInOrder(this.commandBarAvailableButtons, alternateButtonAtIndex);
        }
    }

    private int getNumberOfButtons() {
        int commandBarButtonsSize = this.commandBarButtons.size();
        return commandBarButtonsSize == 1 && this.commandBarButtons.get(0) == null ? 0 : commandBarButtonsSize;
    }

    private int addCommandBarButtonAtLocation(Point dropLocation, JButton button) {
        int index;
        if (this.getNumberOfButtons() == 0) {
            index = 0;
            this.commandBarButtons.set(index, button);
            this.commandBarAlternateButtons.add(index, null);
            this.commandBarButtonsList.setDropMode(DropMode.INSERT);
        } else {
            index = this.commandBarButtonsList.locationToIndex(dropLocation);
            this.commandBarButtons.add(index += dropLocation.x > this.commandBarButtonsList.indexToLocation((int)index).x + CommandBarButtonForDisplay.PREFERRED_SIZE.width / 2 ? 1 : 0, button);
            this.commandBarAlternateButtons.add(index, null);
        }
        return index;
    }

    private Collection<String> initCommandBarAlternateActionsList() {
        String[] commandBarActionIds = CommandBarAttributes.getAlternateActions();
        int nbCommandBarActionIds = commandBarActionIds.length;
        for (int i = 0; i < nbCommandBarActionIds; ++i) {
            this.commandBarAlternateButtons.add(CommandBarButtonForDisplay.create(commandBarActionIds[i]));
        }
        this.commandBarAlternateButtonsList = new DynamicList<JButton>(this.commandBarAlternateButtons);
        this.commandBarAlternateButtonsList.setCellRenderer(new CommandBarAlternativeButtonListRenderer());
        this.commandBarAlternateButtonsList.setLayoutOrientation(2);
        this.commandBarAlternateButtonsList.setVisibleRowCount(1);
        this.commandBarAlternateButtonsList.setDragEnabled(true);
        this.commandBarAlternateButtonsList.setTransferHandler(new TransferHandler(){

            public int getSourceActions(JComponent c) {
                return 2;
            }

            public Transferable createTransferable(JComponent c) {
                if (c instanceof JList) {
                    JList list = (JList)c;
                    return new TransferableButton((JButton)list.getSelectedValue());
                }
                return null;
            }

            public void exportDone(JComponent c, Transferable t, int action) {
                if (action == 2) {
                    JList list = (JList)c;
                    CommandBarDialog.this.commandBarAlternateButtons.set(list.getSelectedIndex(), null);
                    CommandBarDialog.this.componentChanged();
                }
            }

            public boolean canImport(TransferHandler.TransferSupport support) {
                return support.isDataFlavorSupported(TransferableButton.buttonFlavor);
            }

            public boolean importData(TransferHandler.TransferSupport support) {
                if (!this.canImport(support)) {
                    return false;
                }
                try {
                    Point dropLocation = support.getDropLocation().getDropPoint();
                    int index = CommandBarDialog.this.commandBarButtonsList.locationToIndex(dropLocation);
                    JButton prevButton = (JButton)CommandBarDialog.this.commandBarAlternateButtons.get(index);
                    if (prevButton != null) {
                        CommandBarDialog.insertInOrder(CommandBarDialog.this.commandBarAvailableButtons, prevButton);
                    }
                    CommandBarDialog.this.commandBarAlternateButtons.set(index, (JButton)support.getTransferable().getTransferData(TransferableButton.buttonFlavor));
                    CommandBarDialog.this.commandBarAlternateButtonsList.ensureIndexIsVisible(index);
                    CommandBarDialog.this.commandBarAlternateButtonsList.repaint();
                    return true;
                }
                catch (UnsupportedFlavorException e) {
                    e.printStackTrace();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                return false;
            }
        });
        this.commandBarAlternateButtonsList.setBackground(JBUTTON_BACKGROUND_COLOR);
        this.commandBarAlternateButtonsList.setDropMode(DropMode.ON);
        return Arrays.asList(commandBarActionIds);
    }

    private void initActionsPoolList(Set<String> usedActions) {
        Iterator<String> actionIds = ActionManager.getActionIds();
        while (actionIds.hasNext()) {
            String actionId = actionIds.next();
            if (usedActions.contains(actionId) || ActionProperties.getActionDescriptor(actionId).isParameterized()) continue;
            CommandBarDialog.insertInOrder(this.commandBarAvailableButtons, CommandBarButtonForDisplay.create(actionId));
        }
        this.commandBarAvailableButtonsList = new DynamicHorizontalWrapList<JButton>(this.commandBarAvailableButtons, CommandBarButtonForDisplay.PREFERRED_SIZE.width, 6);
        this.commandBarAvailableButtonsList.setCellRenderer(new AvailableButtonCellListRenderer());
        this.commandBarAvailableButtonsList.setDragEnabled(true);
        this.commandBarAvailableButtonsList.setTransferHandler(new TransferHandler(){

            public int getSourceActions(JComponent c) {
                return 2;
            }

            public Transferable createTransferable(JComponent c) {
                if (c instanceof JList) {
                    return new TransferableButton((JButton)((JList)c).getSelectedValue());
                }
                return null;
            }

            public void exportDone(JComponent c, Transferable t, int action) {
                if (action == 2) {
                    if (c instanceof JList) {
                        CommandBarDialog.this.commandBarAvailableButtons.remove(((JList)c).getSelectedValue());
                    }
                    CommandBarDialog.this.componentChanged();
                }
            }

            public boolean canImport(TransferHandler.TransferSupport support) {
                return support.isDataFlavorSupported(TransferableButton.buttonFlavor);
            }

            public boolean importData(TransferHandler.TransferSupport support) {
                if (!this.canImport(support)) {
                    return false;
                }
                try {
                    int insertedIndex = CommandBarDialog.insertInOrder(CommandBarDialog.this.commandBarAvailableButtons, (JButton)support.getTransferable().getTransferData(TransferableButton.buttonFlavor));
                    CommandBarDialog.this.commandBarAvailableButtonsList.ensureIndexIsVisible(insertedIndex);
                    return true;
                }
                catch (UnsupportedFlavorException e) {
                    e.printStackTrace();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                return false;
            }
        });
        this.commandBarAvailableButtonsList.setBackground(JBUTTON_BACKGROUND_COLOR);
        this.commandBarAvailableButtonsList.setDropMode(DropMode.ON);
    }

    protected JPanel createAvailableButtonsPanel() {
        JPanel panel = new JPanel(new GridLayout(1, 0));
        panel.setBorder(BorderFactory.createTitledBorder(Translator.get("command_bar_customize_dialog.available_actions", new String[0])));
        JScrollPane scrollPane = new JScrollPane(this.commandBarAvailableButtonsList, 20, 31);
        scrollPane.setBorder(null);
        panel.add(scrollPane);
        return panel;
    }

    private JPanel createCommandBarPanel() {
        YBoxPanel panel = new YBoxPanel();
        panel.setBorder(BorderFactory.createTitledBorder(Translator.get("preview", new String[0])));
        panel.add(Box.createRigidArea(new Dimension(0, 5)));
        YBoxPanel listsPanel = new YBoxPanel();
        listsPanel.add(this.commandBarButtonsList);
        listsPanel.add(this.commandBarAlternateButtonsList);
        JScrollPane scrollPane = new JScrollPane(listsPanel, 21, 32);
        scrollPane.setBorder(null);
        panel.add(scrollPane);
        panel.add(Box.createRigidArea(new Dimension(0, 5)));
        panel.add(new JLabel("(" + Translator.get("command_bar_dialog.help", new String[0]) + ")"));
        panel.add(Box.createRigidArea(new Dimension(0, 5)));
        JPanel modifierPanel = new JPanel(new FlowLayout(0));
        this.modifierField = new RecordingKeyStrokeTextField(6, CommandBarAttributes.getModifier()){

            public void setText(String t) {
                super.setText(t);
                CommandBarDialog.this.componentChanged();
            }

            public void keyPressed(KeyEvent e) {
                int pressedKeyCode = e.getKeyCode();
                if (pressedKeyCode == 17 || pressedKeyCode == 18 || pressedKeyCode == 157 || pressedKeyCode == 16) {
                    super.keyPressed(e);
                }
            }
        };
        modifierPanel.add(new JLabel(Translator.get("command_bar_customize_dialog.modifier", new String[0])));
        modifierPanel.add(this.modifierField);
        panel.add(modifierPanel);
        return panel;
    }

    private static Box.Filler createBoxFiller() {
        Box.Filler filler = (Box.Filler)Box.createHorizontalGlue();
        filler.setPreferredSize(CommandBarButtonForDisplay.PREFERRED_SIZE);
        return filler;
    }

    private static int insertInOrder(List<JButton> vector, JButton element) {
        if (vector.size() != 0) {
            int index = CommandBarDialog.findPlace(vector, element, BUTTONS_COMPARATOR, 0, vector.size() - 1);
            vector.add(index, element);
            return index;
        }
        vector.add(element);
        return vector.size();
    }

    private static int findPlace(List<JButton> vector, JButton element, Comparator<JButton> comparator, int first, int last) {
        if (comparator.compare(vector.get(last), element) < 0) {
            return last + 1;
        }
        if (comparator.compare(vector.get(first), element) > 0) {
            return first;
        }
        if (last - first == 1) {
            return last;
        }
        int middle = (first + last) / 2;
        int result = comparator.compare(vector.get(middle), element);
        return result > 0 ? CommandBarDialog.findPlace(vector, element, comparator, first, middle) : CommandBarDialog.findPlace(vector, element, comparator, middle, last);
    }

    private static class AvailableButtonCellListRenderer
    implements ListCellRenderer {
        private AvailableButtonCellListRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            JPanel panel = new JPanel(new BorderLayout());
            CommandBarButtonForDisplay button = (CommandBarButtonForDisplay)value;
            panel.add((Component)button, "Center");
            panel.setToolTipText(button.getToolTipText());
            return panel;
        }
    }

    private static class CommandBarAlternativeButtonListRenderer
    implements ListCellRenderer {
        private CommandBarAlternativeButtonListRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            return value == null ? CommandBarDialog.createBoxFiller() : (CommandBarButtonForDisplay)value;
        }
    }

    private static class CommandBarButtonListCellRenderer
    implements ListCellRenderer {
        private CommandBarButtonListCellRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            return value == null ? CommandBarDialog.createBoxFiller() : (CommandBarButtonForDisplay)value;
        }
    }

    private static class TransferableButton
    implements Transferable {
        public static DataFlavor buttonFlavor = new DataFlavor(CommandBarButtonForDisplay.class, null);
        private JButton button;

        public TransferableButton(JButton button) {
            this.button = button;
        }

        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
            return this.button;
        }

        public DataFlavor[] getTransferDataFlavors() {
            return new DataFlavor[]{buttonFlavor};
        }

        public boolean isDataFlavorSupported(DataFlavor flavor) {
            return buttonFlavor.equals(flavor);
        }
    }
}

