/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.ui.dialog.customization;

import com.mucommander.text.Translator;
import com.mucommander.ui.dialog.FocusDialog;
import com.mucommander.ui.layout.XBoxPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JPanel;

public abstract class CustomizeDialog
extends FocusDialog
implements ActionListener {
    public static final Dimension PREFERRED_SIZE = new Dimension(700, 500);
    private JButton applyButton;
    private JButton okButton;
    private JButton cancelButton;

    public CustomizeDialog(Frame parent, String title) {
        super(parent, title, (Component)parent);
        this.initUI();
    }

    public CustomizeDialog(Dialog parent, String title) {
        super(parent, title, (Component)parent);
        this.initUI();
    }

    private void initUI() {
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        contentPane.add((Component)this.createCustomizationPanel(), "Center");
        XBoxPanel buttonsPanel = new XBoxPanel();
        this.applyButton = new JButton(Translator.get("apply", new String[0]));
        buttonsPanel.add(this.applyButton);
        buttonsPanel.addSpace(20);
        this.okButton = new JButton(Translator.get("ok", new String[0]));
        buttonsPanel.add(this.okButton);
        this.cancelButton = new JButton(Translator.get("cancel", new String[0]));
        buttonsPanel.add(this.cancelButton);
        this.applyButton.setEnabled(false);
        this.okButton.setEnabled(false);
        this.applyButton.addActionListener(this);
        this.okButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
        JPanel tempPanel = new JPanel(new FlowLayout(2));
        tempPanel.add(buttonsPanel);
        contentPane.add((Component)tempPanel, "South");
        this.getRootPane().setDefaultButton(this.cancelButton);
        this.setPreferredSize(PREFERRED_SIZE);
    }

    protected abstract JPanel createCustomizationPanel();

    protected abstract void commit();

    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.okButton || source == this.applyButton) {
            this.commit();
        }
        if (source == this.applyButton) {
            this.setCommitButtonsEnabled(false);
        }
        if (source == this.okButton || source == this.cancelButton) {
            this.dispose();
        }
    }

    protected void setCommitButtonsEnabled(boolean enabled) {
        this.applyButton.setEnabled(enabled);
        this.okButton.setEnabled(enabled);
        this.getRootPane().setDefaultButton(enabled ? this.okButton : this.cancelButton);
    }
}

