/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.ui.dialog.debug;

import com.mucommander.MuLogging;
import com.mucommander.text.Translator;
import com.mucommander.ui.action.ActionProperties;
import com.mucommander.ui.action.impl.RefreshAction;
import com.mucommander.ui.dialog.FocusDialog;
import com.mucommander.ui.dialog.debug.DebugConsoleAppender;
import com.mucommander.ui.dialog.debug.LoggingEvent;
import com.mucommander.ui.main.MainFrame;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;

public class DebugConsoleDialog
extends FocusDialog
implements ActionListener,
ItemListener {
    private JList loggingEventsList;
    private JComboBox levelComboBox;
    private JButton closeButton;
    private JButton refreshButton;
    private static final Dimension MINIMUM_DIALOG_DIMENSION = new Dimension(600, 400);
    private static final Dimension MAXIMUM_DIALOG_DIMENSION = new Dimension(700, 500);

    public DebugConsoleDialog(MainFrame mainFrame) {
        super((Frame)mainFrame, ActionProperties.getActionLabel("ShowDebugConsole"), (Component)mainFrame);
        Container contentPane = this.getContentPane();
        this.loggingEventsList = new JList();
        this.loggingEventsList.setAutoscrolls(true);
        this.loggingEventsList.setSelectionMode(2);
        this.loggingEventsList.setCellRenderer(new DebugListCellRenderer());
        this.refreshLogRecords();
        JScrollPane scrollPane = new JScrollPane(this.loggingEventsList, 20, 30);
        contentPane.add((Component)scrollPane, "Center");
        JPanel southPanel = new JPanel(new BorderLayout());
        southPanel.add((Component)this.createComboPanel(), "West");
        JPanel buttonPanel = new JPanel(new FlowLayout());
        this.refreshButton = new JButton(Translator.get(new RefreshAction.Descriptor().getLabel(), new String[0]));
        this.refreshButton.addActionListener(this);
        buttonPanel.add(this.refreshButton);
        this.closeButton = new JButton(Translator.get("close", new String[0]));
        this.closeButton.addActionListener(this);
        buttonPanel.add(this.closeButton);
        southPanel.add((Component)buttonPanel, "East");
        contentPane.add((Component)southPanel, "South");
        this.setInitialFocusComponent(this.closeButton);
        this.setMinimumSize(MINIMUM_DIALOG_DIMENSION);
        this.setMaximumSize(MAXIMUM_DIALOG_DIMENSION);
        this.setInitialFocusComponent(this.closeButton);
    }

    private JPanel createComboPanel() {
        JPanel comboPanel = new JPanel(new FlowLayout());
        comboPanel.add(new JLabel(Translator.get("debug_console_dialog.level", new String[0]) + ":"));
        MuLogging.LogLevel logLevel = MuLogging.getLogLevel();
        this.levelComboBox = new JComboBox();
        for (MuLogging.LogLevel level : MuLogging.LogLevel.values()) {
            this.levelComboBox.addItem(level);
        }
        this.levelComboBox.setSelectedItem((Object)logLevel);
        this.levelComboBox.addItemListener(this);
        comboPanel.add(this.levelComboBox);
        return comboPanel;
    }

    private void refreshLogRecords() {
        DefaultListModel<LoggingEvent> listModel = new DefaultListModel<LoggingEvent>();
        DebugConsoleAppender handler = MuLogging.getDebugConsoleAppender();
        final LoggingEvent[] records = handler.getLogRecords();
        MuLogging.LogLevel currentLogLevel = MuLogging.getLogLevel();
        for (LoggingEvent record : records) {
            if (!record.isLevelEqualOrHigherThan(currentLogLevel)) continue;
            listModel.addElement(record);
        }
        this.loggingEventsList.setModel(listModel);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                DebugConsoleDialog.this.loggingEventsList.ensureIndexIsVisible(records.length - 1);
            }
        });
    }

    private void updateLogLevel() {
        MuLogging.LogLevel newLevel = (MuLogging.LogLevel)((Object)this.levelComboBox.getSelectedItem());
        MuLogging.setLogLevel(newLevel);
    }

    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.refreshButton) {
            this.refreshLogRecords();
        } else if (source == this.closeButton) {
            this.dispose();
        }
    }

    public void itemStateChanged(ItemEvent e) {
        int selectedIndex = this.levelComboBox.getSelectedIndex();
        if (selectedIndex != -1) {
            this.updateLogLevel();
            this.refreshLogRecords();
        }
    }

    private class DebugListCellRenderer
    extends DefaultListCellRenderer {
        private DebugListCellRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (value == null) {
                return null;
            }
            JLabel label = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (!isSelected) {
                MuLogging.LogLevel level = ((LoggingEvent)value).getLevel();
                Color color = level.equals((Object)MuLogging.LogLevel.SEVERE) ? Color.RED : (level.equals((Object)MuLogging.LogLevel.WARNING) ? new Color(255, 100, 0) : (level.equals((Object)MuLogging.LogLevel.CONFIG) ? Color.BLUE : (level.equals((Object)MuLogging.LogLevel.INFO) ? Color.BLACK : (level.equals((Object)MuLogging.LogLevel.FINE) ? Color.DARK_GRAY : new Color(110, 110, 110)))));
                label.setForeground(color);
            }
            if (DebugConsoleDialog.this.loggingEventsList.getVisibleRect().getWidth() < label.getPreferredSize().getWidth()) {
                label.setToolTipText(label.getText());
            } else {
                label.setToolTipText(null);
            }
            return label;
        }
    }
}

