/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.ui.dialog.file;

import com.mucommander.commons.file.AbstractFile;
import com.mucommander.commons.file.FileFactory;
import com.mucommander.commons.file.util.FileSet;
import com.mucommander.desktop.DesktopManager;
import com.mucommander.ui.dialog.file.PathFieldContent;
import com.mucommander.ui.dialog.file.TransferDestinationDialog;
import com.mucommander.ui.main.MainFrame;

public abstract class AbstractCopyDialog
extends TransferDestinationDialog {
    public AbstractCopyDialog(MainFrame mainFrame, FileSet files, String title, String labelText, String okText, String errorDialogTitle) {
        super(mainFrame, files, title, labelText, okText, errorDialogTitle, true);
    }

    public static PathFieldContent selectDestinationFilename(AbstractFile file, String path, int filenameStart) {
        int endPosition;
        endPosition = file.isDirectory() && !DesktopManager.isApplication(file) ? path.length() : ((endPosition = path.lastIndexOf(46)) > filenameStart ? endPosition : path.length());
        return new PathFieldContent(path, filenameStart, endPosition);
    }

    protected PathFieldContent computeInitialPath(FileSet files) {
        int endPosition;
        int startPosition;
        int nbFiles = files.size();
        String fieldText = this.mainFrame.getInactiveTable().getCurrentFolder().getAbsolutePath(true);
        if (nbFiles == 1) {
            AbstractFile destFile;
            AbstractFile file = (AbstractFile)files.elementAt(0);
            startPosition = fieldText.length();
            if (!(file.isDirectory() && (destFile = FileFactory.getFile(fieldText + file.getName())) != null && destFile.exists() && destFile.isDirectory())) {
                return AbstractCopyDialog.selectDestinationFilename(file, fieldText + file.getName(), startPosition);
            }
            endPosition = fieldText.length();
        } else {
            endPosition = fieldText.length();
            startPosition = 0;
        }
        return new PathFieldContent(fieldText, startPosition, endPosition);
    }
}

