/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.ui.dialog.file;

import com.mucommander.commons.file.AbstractFile;
import com.mucommander.commons.file.FileFactory;
import com.mucommander.commons.file.util.FileSet;
import com.mucommander.commons.file.util.PathUtils;
import com.mucommander.commons.io.security.MuProvider;
import com.mucommander.job.CalculateChecksumJob;
import com.mucommander.text.Translator;
import com.mucommander.ui.action.ActionProperties;
import com.mucommander.ui.dialog.DialogToolkit;
import com.mucommander.ui.dialog.file.JobDialog;
import com.mucommander.ui.dialog.file.ProgressDialog;
import com.mucommander.ui.layout.AsyncPanel;
import com.mucommander.ui.layout.YBoxPanel;
import com.mucommander.ui.main.MainFrame;
import com.mucommander.ui.text.FilePathField;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Security;
import java.util.Comparator;
import java.util.TreeSet;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

public class CalculateChecksumDialog
extends JobDialog
implements ActionListener,
ItemListener {
    private JComboBox algorithmComboBox;
    private JRadioButton specificLocationRadioButton;
    private JTextField specificLocationTextField;
    private JButton okButton;
    private MessageDigest[] messageDigests;
    private static String lastUsedAlgorithm = "MD5";
    private static final Dimension MINIMUM_DIALOG_DIMENSION = new Dimension(320, 0);

    public CalculateChecksumDialog(MainFrame mainFrame, FileSet files) {
        super(mainFrame, ActionProperties.getActionLabel("CalculateChecksum"), files);
        YBoxPanel mainPanel = new YBoxPanel();
        TreeSet<MessageDigest> algorithmSortedSet = new TreeSet<MessageDigest>(new Comparator<MessageDigest>(){

            @Override
            public int compare(MessageDigest md1, MessageDigest md2) {
                return md1.getAlgorithm().compareTo(md2.getAlgorithm());
            }
        });
        for (String algo : Security.getAlgorithms("MessageDigest")) {
            try {
                algorithmSortedSet.add(MessageDigest.getInstance(algo));
            }
            catch (NoSuchAlgorithmException e) {}
        }
        this.messageDigests = new MessageDigest[algorithmSortedSet.size()];
        algorithmSortedSet.toArray(this.messageDigests);
        this.algorithmComboBox = new JComboBox();
        for (MessageDigest messageDigest : this.messageDigests) {
            this.algorithmComboBox.addItem(messageDigest.getAlgorithm());
        }
        this.algorithmComboBox.setSelectedItem(lastUsedAlgorithm);
        this.algorithmComboBox.addItemListener(this);
        FlowLayout flowLayout = new FlowLayout(3, 0, 0);
        JPanel tempPanel = new JPanel(flowLayout);
        tempPanel.add(new JLabel(Translator.get("calculate_checksum_dialog.checksum_algorithm", new String[0]) + " : "));
        tempPanel.add(this.algorithmComboBox);
        mainPanel.add(tempPanel);
        mainPanel.addSpace(10);
        mainPanel.add(new JLabel(Translator.get("destination", new String[0]) + " :"));
        mainPanel.addSpace(5);
        JRadioButton tempLocationRadioButton = new JRadioButton(Translator.get("calculate_checksum_dialog.temporary_file", new String[0]), true);
        mainPanel.add(tempLocationRadioButton);
        this.specificLocationRadioButton = new JRadioButton("", false);
        tempPanel = new JPanel(new BorderLayout());
        tempPanel.add((Component)this.specificLocationRadioButton, "West");
        this.specificLocationRadioButton.addItemListener(this);
        this.specificLocationTextField = new FilePathField(this.getChecksumFilename(lastUsedAlgorithm));
        this.specificLocationTextField.setEnabled(false);
        tempPanel.add((Component)this.specificLocationTextField, "Center");
        JPanel tempPanel2 = new JPanel(new BorderLayout());
        tempPanel2.add((Component)tempPanel, "North");
        mainPanel.add(tempPanel2);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(tempLocationRadioButton);
        buttonGroup.add(this.specificLocationRadioButton);
        AsyncPanel fileDetailsPanel = this.createFileDetailsPanel();
        this.okButton = new JButton(Translator.get("ok", new String[0]));
        JButton cancelButton = new JButton(Translator.get("cancel", new String[0]));
        mainPanel.add(this.createButtonsPanel(this.createFileDetailsButton(fileDetailsPanel), DialogToolkit.createOKCancelPanel(this.okButton, cancelButton, this.getRootPane(), this)));
        mainPanel.add(fileDetailsPanel);
        this.getContentPane().add(mainPanel);
        this.setInitialFocusComponent(this.algorithmComboBox);
        this.setDefaultCloseOperation(2);
        this.setMinimumSize(MINIMUM_DIALOG_DIMENSION);
        this.setResizable(true);
    }

    private MessageDigest getSelectedMessageDigest() {
        return this.messageDigests[this.algorithmComboBox.getSelectedIndex()];
    }

    private String getChecksumFilename(String algorithm) {
        if ((algorithm = algorithm.toUpperCase()).equals("SHA")) {
            return "SHA1SUMS";
        }
        if (algorithm.equals("CRC32")) {
            return (this.files.size() == 1 ? (AbstractFile)this.files.elementAt(0) : this.files.getBaseFolder()).getName() + ".sfv";
        }
        return algorithm.replace("-", "") + "SUMS";
    }

    public void actionPerformed(ActionEvent e) {
        this.dispose();
        if (e.getSource() == this.okButton) {
            try {
                AbstractFile checksumFile;
                MessageDigest digest = this.getSelectedMessageDigest();
                String algorithm = digest.getAlgorithm();
                if (this.specificLocationRadioButton.isSelected()) {
                    String enteredPath = this.specificLocationTextField.getText();
                    PathUtils.ResolvedDestination resolvedDest = PathUtils.resolveDestination(enteredPath, this.mainFrame.getActiveTable().getCurrentFolder());
                    if (resolvedDest == null) {
                        this.showErrorDialog(Translator.get("invalid_path", enteredPath));
                        return;
                    }
                    checksumFile = resolvedDest.getDestinationType() == 0 ? resolvedDest.getDestinationFile().getDirectChild(this.getChecksumFilename(algorithm)) : resolvedDest.getDestinationFile();
                } else {
                    checksumFile = FileFactory.getTemporaryFile(this.getChecksumFilename(algorithm), true);
                }
                lastUsedAlgorithm = algorithm;
                ProgressDialog progressDialog = new ProgressDialog(this.mainFrame, Translator.get("properties_dialog.calculating", new String[0]));
                CalculateChecksumJob job = new CalculateChecksumJob(progressDialog, this.mainFrame, this.files, checksumFile, digest);
                progressDialog.start(job);
            }
            catch (IOException ex) {
                this.showErrorDialog(Translator.get("invalid_path", this.specificLocationTextField.getText()));
            }
        }
    }

    public void itemStateChanged(ItemEvent e) {
        Object source = e.getSource();
        if (source == this.specificLocationRadioButton) {
            this.specificLocationTextField.setEnabled(this.specificLocationRadioButton.isSelected());
            this.specificLocationTextField.requestFocus();
        } else if (source == this.algorithmComboBox) {
            this.specificLocationTextField.setText(this.getChecksumFilename(this.getSelectedMessageDigest().getAlgorithm()));
        }
    }

    static {
        MuProvider.registerProvider();
    }
}

