/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.ui.dialog.file;

import com.mucommander.commons.file.AbstractFile;
import com.mucommander.commons.file.FileOperation;
import com.mucommander.commons.file.util.FileSet;
import com.mucommander.job.ChangeFileAttributesJob;
import com.mucommander.text.CustomDateFormat;
import com.mucommander.text.Translator;
import com.mucommander.ui.action.ActionProperties;
import com.mucommander.ui.dialog.DialogToolkit;
import com.mucommander.ui.dialog.file.JobDialog;
import com.mucommander.ui.dialog.file.ProgressDialog;
import com.mucommander.ui.layout.AsyncPanel;
import com.mucommander.ui.layout.YBoxPanel;
import com.mucommander.ui.main.MainFrame;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Date;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.SpinnerDateModel;

public class ChangeDateDialog
extends JobDialog
implements ActionListener,
ItemListener {
    private JRadioButton nowRadioButton;
    private JSpinner dateSpinner;
    private JCheckBox recurseDirCheckBox;
    private JButton okButton;
    private JButton cancelButton;

    public ChangeDateDialog(MainFrame mainFrame, FileSet files) {
        super(mainFrame, ActionProperties.getActionLabel("ChangeDate"), files);
        YBoxPanel mainPanel = new YBoxPanel();
        mainPanel.add(new JLabel(ActionProperties.getActionLabel("ChangeDate") + " :"));
        mainPanel.addSpace(5);
        ButtonGroup buttonGroup = new ButtonGroup();
        AbstractFile destFile = files.size() == 1 ? (AbstractFile)files.elementAt(0) : files.getBaseFolder();
        boolean canChangeDate = destFile.isFileOperationSupported(FileOperation.CHANGE_DATE);
        JPanel tempPanel = new JPanel(new FlowLayout(0));
        this.nowRadioButton = new JRadioButton(Translator.get("change_date_dialog.now", new String[0]));
        this.nowRadioButton.setSelected(true);
        this.nowRadioButton.addItemListener(this);
        tempPanel.add(this.nowRadioButton);
        mainPanel.add(tempPanel);
        buttonGroup.add(this.nowRadioButton);
        JRadioButton specificDateRadioButton = new JRadioButton(Translator.get("change_date_dialog.specific_date", new String[0]));
        buttonGroup.add(specificDateRadioButton);
        tempPanel = new JPanel(new FlowLayout(0));
        tempPanel.add(specificDateRadioButton);
        this.dateSpinner = new JSpinner(new SpinnerDateModel());
        this.dateSpinner.setEditor(new JSpinner.DateEditor(this.dateSpinner, CustomDateFormat.getDateFormatString()));
        this.dateSpinner.setValue(new Date(destFile.getDate()));
        this.dateSpinner.setEnabled(false);
        tempPanel.add(this.dateSpinner);
        mainPanel.add(tempPanel);
        mainPanel.addSpace(10);
        this.recurseDirCheckBox = new JCheckBox(Translator.get("recurse_directories", new String[0]));
        mainPanel.add(this.recurseDirCheckBox);
        mainPanel.addSpace(15);
        AsyncPanel fileDetailsPanel = this.createFileDetailsPanel();
        this.okButton = new JButton(Translator.get("change", new String[0]));
        this.cancelButton = new JButton(Translator.get("cancel", new String[0]));
        mainPanel.add(this.createButtonsPanel(this.createFileDetailsButton(fileDetailsPanel), DialogToolkit.createOKCancelPanel(this.okButton, this.cancelButton, this.getRootPane(), this)));
        mainPanel.add(fileDetailsPanel);
        this.getContentPane().add((Component)mainPanel, "North");
        if (!canChangeDate) {
            this.nowRadioButton.setEnabled(false);
            specificDateRadioButton.setEnabled(false);
            this.dateSpinner.setEnabled(false);
            this.recurseDirCheckBox.setEnabled(false);
            this.okButton.setEnabled(false);
        }
        this.getRootPane().setDefaultButton(canChangeDate ? this.okButton : this.cancelButton);
        this.setInitialFocusComponent(canChangeDate ? this.nowRadioButton : this.cancelButton);
        this.setResizable(false);
    }

    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.okButton) {
            this.dispose();
            ProgressDialog progressDialog = new ProgressDialog(this.mainFrame, Translator.get("progress_dialog.processing_files", new String[0]));
            ChangeFileAttributesJob job = new ChangeFileAttributesJob(progressDialog, this.mainFrame, this.files, this.nowRadioButton.isSelected() ? System.currentTimeMillis() : ((SpinnerDateModel)this.dateSpinner.getModel()).getDate().getTime(), this.recurseDirCheckBox.isSelected());
            progressDialog.start(job);
        } else if (source == this.cancelButton) {
            this.dispose();
        }
    }

    public void itemStateChanged(ItemEvent e) {
        if (e.getSource() == this.nowRadioButton) {
            this.dateSpinner.setEnabled(!this.nowRadioButton.isSelected());
        }
    }
}

