/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.ui.dialog.file;

import com.mucommander.commons.file.AbstractFile;
import com.mucommander.commons.file.util.FileSet;
import com.mucommander.desktop.AbstractTrash;
import com.mucommander.desktop.DesktopManager;
import com.mucommander.job.DeleteJob;
import com.mucommander.text.Translator;
import com.mucommander.ui.action.ActionManager;
import com.mucommander.ui.action.ActionProperties;
import com.mucommander.ui.dialog.DialogToolkit;
import com.mucommander.ui.dialog.file.JobDialog;
import com.mucommander.ui.dialog.file.ProgressDialog;
import com.mucommander.ui.layout.AsyncPanel;
import com.mucommander.ui.layout.InformationPane;
import com.mucommander.ui.layout.YBoxPanel;
import com.mucommander.ui.main.MainFrame;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;

public class DeleteDialog
extends JobDialog
implements ActionListener,
ItemListener {
    private boolean moveToTrash;
    private JCheckBox moveToTrashCheckBox;
    private InformationPane informationPane;
    private JButton deleteButton;
    private static final Dimension MINIMUM_DIALOG_DIMENSION = new Dimension(360, 0);

    public DeleteDialog(MainFrame mainFrame, FileSet files, boolean deletePermanently) {
        super(mainFrame, ActionProperties.getActionLabel("Delete"), files);
        this.mainFrame = mainFrame;
        YBoxPanel mainPanel = new YBoxPanel();
        AbstractTrash trash = DesktopManager.getTrash();
        AbstractFile baseFolder = files.getBaseFolder();
        if (trash != null && !baseFolder.isArchive() && !trash.isTrashFile(baseFolder) && trash.canMoveToTrash(baseFolder)) {
            this.moveToTrash = !deletePermanently;
            this.moveToTrashCheckBox = new JCheckBox(Translator.get("delete_dialog.move_to_trash.option", new String[0]), this.moveToTrash);
            this.moveToTrashCheckBox.addItemListener(this);
        }
        this.informationPane = new InformationPane();
        mainPanel.add(this.informationPane);
        mainPanel.addSpace(10);
        AsyncPanel fileDetailsPanel = this.createFileDetailsPanel();
        this.deleteButton = new JButton(Translator.get("delete", new String[0]));
        JButton cancelButton = new JButton(Translator.get("cancel", new String[0]));
        mainPanel.add(this.createButtonsPanel(this.createFileDetailsButton(fileDetailsPanel), DialogToolkit.createOKCancelPanel(this.deleteButton, cancelButton, this.getRootPane(), this)));
        mainPanel.add(fileDetailsPanel);
        if (this.moveToTrashCheckBox != null) {
            mainPanel.add(this.moveToTrashCheckBox);
        }
        this.getContentPane().add(mainPanel);
        this.setInitialFocusComponent(this.deleteButton);
        this.setDefaultCloseOperation(2);
        this.updateDialog();
        this.setMinimumSize(MINIMUM_DIALOG_DIMENSION);
        this.setResizable(false);
    }

    private void updateDialog() {
        this.informationPane.getMainLabel().setText(Translator.get(this.moveToTrash ? "delete_dialog.move_to_trash.confirmation" : "delete_dialog.permanently_delete.confirmation", new String[0]));
        this.informationPane.getCaptionLabel().setText(Translator.get(this.moveToTrash ? "delete_dialog.move_to_trash.confirmation_details" : "this_operation_cannot_be_undone", new String[0]));
        this.informationPane.setIcon(this.moveToTrash ? null : InformationPane.getPredefinedIcon(3));
        this.setTitle(ActionManager.getActionInstance(this.moveToTrash ? "Delete" : "PermanentDelete", this.mainFrame).getLabel());
    }

    public void itemStateChanged(ItemEvent e) {
        this.moveToTrash = this.moveToTrashCheckBox.isSelected();
        this.updateDialog();
        this.pack();
    }

    public void actionPerformed(ActionEvent e) {
        this.dispose();
        if (e.getSource() == this.deleteButton) {
            ProgressDialog progressDialog = new ProgressDialog(this.mainFrame, Translator.get("delete_dialog.deleting", new String[0]));
            DeleteJob deleteJob = new DeleteJob(progressDialog, this.mainFrame, this.files, this.moveToTrash);
            progressDialog.start(deleteJob);
        }
    }
}

