/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.ui.dialog.file;

import com.mucommander.commons.file.AbstractFile;
import com.mucommander.job.ui.DialogResult;
import com.mucommander.text.Translator;
import com.mucommander.ui.dialog.DialogToolkit;
import com.mucommander.ui.dialog.FocusDialog;
import com.mucommander.ui.dialog.file.AbstractCopyDialog;
import com.mucommander.ui.layout.YBoxPanel;
import com.mucommander.ui.main.MainFrame;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JTextField;

public class FileCollisionRenameDialog
extends FocusDialog
implements DialogResult,
ActionListener {
    private JTextField edtNewName;
    private JButton okButton;
    private String newName;
    private static final Dimension MINIMUM_DIALOG_DIMENSION = new Dimension(320, 0);
    private static final Dimension MAXIMUM_DIALOG_DIMENSION = new Dimension(400, 10000);

    public FileCollisionRenameDialog(MainFrame mainFrame, AbstractFile file) {
        super((Frame)mainFrame, Translator.get("rename", new String[0]), (Component)mainFrame);
        Container contentPane = this.getContentPane();
        YBoxPanel mainPanel = new YBoxPanel();
        mainPanel.add(new JLabel(Translator.get("rename_dialog.new_name", new String[0]) + ":"));
        this.edtNewName = new JTextField();
        this.edtNewName.addActionListener(this);
        AbstractCopyDialog.selectDestinationFilename(file, file.getName(), 0).feedToPathField(this.edtNewName);
        mainPanel.add(this.edtNewName);
        mainPanel.addSpace(10);
        contentPane.add((Component)mainPanel, "North");
        this.okButton = new JButton(Translator.get("rename", new String[0]));
        JButton cancelButton = new JButton(Translator.get("cancel", new String[0]));
        contentPane.add((Component)DialogToolkit.createOKCancelPanel(this.okButton, cancelButton, this.getRootPane(), this), "South");
        this.setInitialFocusComponent(this.edtNewName);
        this.setMinimumSize(MINIMUM_DIALOG_DIMENSION);
        this.setMaximumSize(MAXIMUM_DIALOG_DIMENSION);
    }

    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        this.newName = source == this.okButton || source == this.edtNewName ? this.edtNewName.getText() : null;
        this.dispose();
    }

    public Object getUserInput() {
        this.showDialog();
        return this.newName;
    }
}

