/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.ui.dialog.file;

import com.mucommander.commons.file.filter.AbstractFileFilter;
import com.mucommander.commons.file.filter.AndFileFilter;
import com.mucommander.commons.file.filter.AttributeFileFilter;
import com.mucommander.commons.file.filter.ContainsFilenameFilter;
import com.mucommander.commons.file.filter.EndsWithFilenameFilter;
import com.mucommander.commons.file.filter.EqualsFilenameFilter;
import com.mucommander.commons.file.filter.PassThroughFileFilter;
import com.mucommander.commons.file.filter.RegexpFilenameFilter;
import com.mucommander.commons.file.filter.StartsWithFilenameFilter;
import com.mucommander.text.Translator;
import com.mucommander.ui.dialog.DialogToolkit;
import com.mucommander.ui.dialog.FocusDialog;
import com.mucommander.ui.layout.YBoxPanel;
import com.mucommander.ui.main.MainFrame;
import com.mucommander.ui.main.table.FileTable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.regex.PatternSyntaxException;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileSelectionDialog
extends FocusDialog
implements ActionListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileSelectionDialog.class);
    private boolean addToSelection;
    private JComboBox comparisonComboBox;
    private JTextField selectionField;
    private JCheckBox caseSensitiveCheckBox;
    private JCheckBox includeFoldersCheckBox;
    private JButton okButton;
    private MainFrame mainFrame;
    private static boolean caseSensitive = false;
    private static boolean includeFolders = false;
    private static int comparison = 0;
    private static String keywordString = "*";
    private static final Dimension MINIMUM_DIALOG_DIMENSION = new Dimension(320, 0);
    private static final Dimension MAXIMUM_DIALOG_DIMENSION = new Dimension(400, 10000);

    public FileSelectionDialog(MainFrame mainFrame, boolean addToSelection) {
        super((Frame)mainFrame, Translator.get(addToSelection ? "file_selection_dialog.mark" : "file_selection_dialog.unmark", new String[0]), (Component)mainFrame);
        this.mainFrame = mainFrame;
        this.addToSelection = addToSelection;
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        YBoxPanel northPanel = new YBoxPanel(5);
        JLabel label = new JLabel(Translator.get(addToSelection ? "file_selection_dialog.mark_description" : "file_selection_dialog.unmark_description", new String[0]) + " :");
        northPanel.add(label);
        JPanel tempPanel = new JPanel();
        tempPanel.setLayout(new BoxLayout(tempPanel, 0));
        this.comparisonComboBox = new JComboBox();
        this.comparisonComboBox.addItem(Translator.get("file_selection_dialog.contains", new String[0]));
        this.comparisonComboBox.addItem(Translator.get("file_selection_dialog.starts_with", new String[0]));
        this.comparisonComboBox.addItem(Translator.get("file_selection_dialog.ends_with", new String[0]));
        this.comparisonComboBox.addItem(Translator.get("file_selection_dialog.is", new String[0]));
        this.comparisonComboBox.addItem(Translator.get("file_selection_dialog.matches_regexp", new String[0]));
        this.comparisonComboBox.setSelectedIndex(comparison);
        tempPanel.add(this.comparisonComboBox);
        this.selectionField = new JTextField(keywordString);
        this.selectionField.addActionListener(this);
        this.selectionField.setSelectionStart(0);
        this.selectionField.setSelectionEnd(keywordString.length());
        tempPanel.add(this.selectionField);
        northPanel.add(tempPanel);
        northPanel.addSpace(10);
        this.caseSensitiveCheckBox = new JCheckBox(Translator.get("file_selection_dialog.case_sensitive", new String[0]), caseSensitive);
        northPanel.add(this.caseSensitiveCheckBox);
        this.includeFoldersCheckBox = new JCheckBox(Translator.get("file_selection_dialog.include_folders", new String[0]), includeFolders);
        northPanel.add(this.includeFoldersCheckBox);
        northPanel.addSpace(10);
        northPanel.add(Box.createVerticalGlue());
        contentPane.add((Component)northPanel, "North");
        this.okButton = new JButton(Translator.get(addToSelection ? "file_selection_dialog.mark" : "file_selection_dialog.unmark", new String[0]));
        contentPane.add((Component)DialogToolkit.createOKCancelPanel(this.okButton, new JButton(Translator.get("cancel", new String[0])), this.getRootPane(), this), "South");
        this.setInitialFocusComponent(this.selectionField);
        this.setMinimumSize(MINIMUM_DIALOG_DIMENSION);
        this.setMaximumSize(MAXIMUM_DIALOG_DIMENSION);
    }

    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        FileTable activeTable = this.mainFrame.getActiveTable();
        if (source == this.okButton || source == this.selectionField) {
            AbstractFileFilter filter;
            caseSensitive = this.caseSensitiveCheckBox.isSelected();
            includeFolders = this.includeFoldersCheckBox.isSelected();
            comparison = this.comparisonComboBox.getSelectedIndex();
            keywordString = this.selectionField.getText();
            String testString = comparison != 4 ? keywordString.replace("*", "") : keywordString;
            switch (comparison) {
                case 0: {
                    filter = new ContainsFilenameFilter(testString, caseSensitive);
                    break;
                }
                case 1: {
                    filter = new StartsWithFilenameFilter(testString, caseSensitive);
                    break;
                }
                case 2: {
                    filter = new EndsWithFilenameFilter(testString, caseSensitive);
                    break;
                }
                case 3: {
                    filter = new EqualsFilenameFilter(testString, caseSensitive);
                    break;
                }
                default: {
                    try {
                        filter = new RegexpFilenameFilter(testString, caseSensitive);
                        break;
                    }
                    catch (PatternSyntaxException ex) {
                        LOGGER.debug("Invalid regexp", ex);
                        filter = new PassThroughFileFilter(false);
                    }
                }
            }
            if (!includeFolders) {
                filter = new AndFileFilter(new AttributeFileFilter(1), filter);
            }
            activeTable.getFileTableModel().setFilesMarked(filter, this.addToSelection);
            activeTable.fireMarkedFilesChangedEvent();
            activeTable.repaint();
        }
        this.dispose();
    }
}

