/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.ui.dialog.file;

import com.mucommander.commons.file.AbstractFile;
import com.mucommander.commons.file.util.FileSet;
import com.mucommander.commons.file.util.PathUtils;
import com.mucommander.job.MkdirJob;
import com.mucommander.text.Translator;
import com.mucommander.ui.action.ActionManager;
import com.mucommander.ui.action.ActionProperties;
import com.mucommander.ui.chooser.SizeChooser;
import com.mucommander.ui.dialog.DialogToolkit;
import com.mucommander.ui.dialog.FocusDialog;
import com.mucommander.ui.dialog.InformationDialog;
import com.mucommander.ui.dialog.file.ProgressDialog;
import com.mucommander.ui.layout.YBoxPanel;
import com.mucommander.ui.main.MainFrame;
import com.mucommander.ui.text.FilePathField;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class MkdirDialog
extends FocusDialog
implements ActionListener,
ItemListener {
    private MainFrame mainFrame;
    private JTextField pathField;
    private JCheckBox allocateSpaceCheckBox;
    private SizeChooser allocateSpaceChooser;
    private JButton okButton;
    private boolean mkfileMode;
    private static final Dimension MINIMUM_DIALOG_DIMENSION = new Dimension(320, 0);
    private static final Dimension MAXIMUM_DIALOG_DIMENSION = new Dimension(400, 10000);

    public MkdirDialog(MainFrame mainFrame, boolean mkfileMode) {
        super((Frame)mainFrame, ActionManager.getActionInstance(mkfileMode ? "Mkfile" : "Mkdir", mainFrame).getLabel(), (Component)mainFrame);
        this.mainFrame = mainFrame;
        this.mkfileMode = mkfileMode;
        Container contentPane = this.getContentPane();
        YBoxPanel mainPanel = new YBoxPanel();
        mainPanel.add(new JLabel(ActionProperties.getActionTooltip(mkfileMode ? "Mkfile" : "Mkdir") + " :"));
        this.pathField = new FilePathField();
        this.pathField.addActionListener(this);
        AbstractFile currentFile = mainFrame.getActiveTable().getSelectedFile();
        if (currentFile != null) {
            String initialValue;
            if (mkfileMode) {
                initialValue = currentFile.getName();
                if (initialValue != null) {
                    this.pathField.setText(initialValue);
                }
            } else {
                initialValue = currentFile.getNameWithoutExtension();
                if (initialValue != null) {
                    this.pathField.setText(initialValue);
                }
            }
        }
        this.pathField.setSelectionStart(0);
        this.pathField.setSelectionEnd(this.pathField.getText().length());
        mainPanel.add(this.pathField);
        if (mkfileMode) {
            JPanel tempPanel = new JPanel(new BorderLayout());
            this.allocateSpaceCheckBox = new JCheckBox(Translator.get("mkfile_dialog.allocate_space", new String[0]) + ":", false);
            this.allocateSpaceCheckBox.addItemListener(this);
            tempPanel.add((Component)this.allocateSpaceCheckBox, "West");
            this.allocateSpaceChooser = new SizeChooser(false);
            this.allocateSpaceChooser.setEnabled(false);
            tempPanel.add((Component)this.allocateSpaceChooser, "East");
            mainPanel.add(tempPanel);
        }
        mainPanel.addSpace(10);
        contentPane.add((Component)mainPanel, "North");
        this.okButton = new JButton(Translator.get("create", new String[0]));
        JButton cancelButton = new JButton(Translator.get("cancel", new String[0]));
        contentPane.add((Component)DialogToolkit.createOKCancelPanel(this.okButton, cancelButton, this.getRootPane(), this), "South");
        this.setInitialFocusComponent(this.pathField);
        this.setMinimumSize(MINIMUM_DIALOG_DIMENSION);
        this.setMaximumSize(MAXIMUM_DIALOG_DIMENSION);
    }

    public void startJob() {
        String enteredPath = this.pathField.getText();
        PathUtils.ResolvedDestination resolvedDest = PathUtils.resolveDestination(enteredPath, this.mainFrame.getActiveTable().getCurrentFolder());
        if (resolvedDest == null) {
            InformationDialog.showErrorDialog(this.mainFrame, Translator.get("invalid_path", enteredPath));
            return;
        }
        int destinationType = resolvedDest.getDestinationType();
        if (destinationType == 0) {
            InformationDialog.showErrorDialog(this.mainFrame, Translator.get("directory_already_exists", enteredPath));
            return;
        }
        AbstractFile destFile = resolvedDest.getDestinationFile();
        FileSet fileSet = new FileSet(destFile.getParent());
        fileSet.add(destFile);
        ProgressDialog progressDialog = new ProgressDialog(this.mainFrame, this.getTitle());
        MkdirJob job = this.mkfileMode ? new MkdirJob(progressDialog, this.mainFrame, fileSet, this.allocateSpaceCheckBox.isSelected() ? this.allocateSpaceChooser.getValue() : -1L) : new MkdirJob(progressDialog, this.mainFrame, fileSet);
        progressDialog.start(job);
    }

    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        this.dispose();
        if (source == this.okButton || source == this.pathField) {
            this.startJob();
        }
    }

    public void itemStateChanged(ItemEvent e) {
        this.allocateSpaceChooser.setEnabled(this.allocateSpaceCheckBox.isSelected());
    }
}

