/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.ui.dialog.file;

import com.mucommander.commons.file.AbstractFile;
import com.mucommander.commons.file.archiver.Archiver;
import com.mucommander.commons.file.util.FileSet;
import com.mucommander.commons.file.util.PathUtils;
import com.mucommander.desktop.DesktopManager;
import com.mucommander.job.ArchiveJob;
import com.mucommander.job.TransferFileJob;
import com.mucommander.text.Translator;
import com.mucommander.ui.action.ActionProperties;
import com.mucommander.ui.dialog.file.PathFieldContent;
import com.mucommander.ui.dialog.file.ProgressDialog;
import com.mucommander.ui.dialog.file.TransferDestinationDialog;
import com.mucommander.ui.layout.YBoxPanel;
import com.mucommander.ui.main.MainFrame;
import com.mucommander.ui.main.table.FileTable;
import com.mucommander.ui.text.FilePathField;
import java.awt.FlowLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;

public class PackDialog
extends TransferDestinationDialog
implements ItemListener {
    private JComboBox formatsComboBox;
    private int[] formats;
    private JTextArea commentArea;
    private int lastFormatIndex;
    private static int lastFormat = 0;

    public PackDialog(MainFrame mainFrame, FileSet files) {
        super(mainFrame, files, ActionProperties.getActionLabel("Pack"), Translator.get("pack_dialog_description", new String[0]), Translator.get("pack", new String[0]), Translator.get("pack_dialog.error_title", new String[0]), false);
        int nbFiles = files.size();
        this.formats = Archiver.getFormats(nbFiles > 1 || nbFiles > 0 && ((AbstractFile)files.elementAt(0)).isDirectory());
        int nbFormats = this.formats.length;
        int initialFormat = this.formats[0];
        int initialFormatIndex = 0;
        for (int i = 0; i < nbFormats; ++i) {
            if (this.formats[i] != lastFormat) continue;
            initialFormat = this.formats[i];
            initialFormatIndex = i;
            break;
        }
        lastFormat = initialFormat;
        this.lastFormatIndex = initialFormatIndex;
        JPanel tempPanel = new JPanel(new FlowLayout(0));
        tempPanel.add(new JLabel(Translator.get("pack_dialog.archive_format", new String[0])));
        this.formatsComboBox = new JComboBox();
        for (int i = 0; i < nbFormats; ++i) {
            this.formatsComboBox.addItem(Archiver.getFormatName(this.formats[i]));
        }
        this.formatsComboBox.setSelectedIndex(this.lastFormatIndex);
        this.formatsComboBox.addItemListener(this);
        tempPanel.add(this.formatsComboBox);
        YBoxPanel mainPanel = this.getMainPanel();
        mainPanel.add(tempPanel);
        mainPanel.addSpace(10);
        mainPanel.add(new JLabel(Translator.get("comment", new String[0])));
        this.commentArea = new JTextArea();
        this.commentArea.setRows(4);
        mainPanel.add(this.commentArea);
    }

    protected PathFieldContent computeInitialPath(FileSet files) {
        AbstractFile file;
        FileTable activeTable = this.mainFrame.getInactiveTable();
        String initialPath = activeTable.getCurrentFolder().getAbsolutePath(true);
        String fileName = files.size() == 1 ? ((file = (AbstractFile)files.elementAt(0)).isDirectory() && !DesktopManager.isApplication(file) ? file.getName() : file.getNameWithoutExtension()) : ((file = files.getBaseFolder()).isRoot() ? "" : (DesktopManager.isApplication(file) ? file.getNameWithoutExtension() : file.getName()));
        return new PathFieldContent(initialPath + fileName + "." + Archiver.getFormatExtension(lastFormat), initialPath.length(), initialPath.length() + fileName.length());
    }

    protected TransferFileJob createTransferFileJob(ProgressDialog progressDialog, PathUtils.ResolvedDestination resolvedDest, int defaultFileExistsAction) {
        lastFormat = this.formats[this.formatsComboBox.getSelectedIndex()];
        return new ArchiveJob(progressDialog, this.mainFrame, this.files, resolvedDest.getDestinationFile(), lastFormat, Archiver.formatSupportsComment(lastFormat) ? this.commentArea.getText() : null);
    }

    protected String getProgressDialogTitle() {
        return Translator.get("pack_dialog.packing", new String[0]);
    }

    protected boolean isValidDestination(PathUtils.ResolvedDestination resolvedDest, String destPath) {
        if (resolvedDest == null) {
            return false;
        }
        int destType = resolvedDest.getDestinationType();
        return destType == 2 || destType == 1;
    }

    public void itemStateChanged(ItemEvent e) {
        FilePathField pathField = this.getPathField();
        int newFormatIndex = this.formatsComboBox.getSelectedIndex();
        if (this.lastFormatIndex != newFormatIndex) {
            String fileName = pathField.getText();
            String oldFormatExtension = Archiver.getFormatExtension(this.formats[this.lastFormatIndex]);
            if (fileName.endsWith("." + oldFormatExtension)) {
                int selectionStart = pathField.getSelectionStart();
                int selectionEnd = pathField.getSelectionEnd();
                fileName = fileName.substring(0, fileName.length() - oldFormatExtension.length()) + Archiver.getFormatExtension(this.formats[newFormatIndex]);
                if (selectionEnd == pathField.getText().length()) {
                    selectionEnd = fileName.length();
                }
                pathField.setText(fileName);
                pathField.setSelectionStart(selectionStart);
                pathField.setSelectionEnd(selectionEnd);
            }
            this.commentArea.setEnabled(Archiver.formatSupportsComment(this.formats[this.formatsComboBox.getSelectedIndex()]));
            this.lastFormatIndex = newFormatIndex;
        }
        pathField.requestFocus();
    }
}

