/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.ui.dialog.file;

import com.mucommander.conf.MuConfigurations;
import com.mucommander.conf.MuPreference;
import com.mucommander.job.FileJob;
import com.mucommander.job.FileJobListener;
import com.mucommander.job.TransferFileJob;
import com.mucommander.job.progress.JobProgress;
import com.mucommander.job.progress.JobProgressListener;
import com.mucommander.job.progress.JobProgressMonitor;
import com.mucommander.text.DurationFormat;
import com.mucommander.text.SizeFormat;
import com.mucommander.text.Translator;
import com.mucommander.ui.button.ButtonChoicePanel;
import com.mucommander.ui.button.CollapseExpandButton;
import com.mucommander.ui.chooser.SizeChooser;
import com.mucommander.ui.dialog.FocusDialog;
import com.mucommander.ui.icon.IconManager;
import com.mucommander.ui.layout.YBoxPanel;
import com.mucommander.ui.main.MainFrame;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowEvent;
import java.util.List;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProgressDialog
extends FocusDialog
implements FileJobListener,
JobProgressListener,
ActionListener,
ItemListener,
ChangeListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProgressDialog.class);
    private JLabel currentFileLabel;
    private JLabel totalTransferredLabel;
    private JProgressBar totalProgressBar;
    private JProgressBar currentFileProgressBar;
    private JLabel currentSpeedLabel;
    private JCheckBox limitSpeedCheckBox;
    private SizeChooser speedChooser;
    private JLabel elapsedTimeLabel;
    private SpeedGraph speedGraph;
    private CollapseExpandButton collapseExpandButton;
    private ButtonChoicePanel buttonsChoicePanel;
    private JButton pauseResumeButton;
    private JButton skipButton;
    private JButton stopButton;
    private JCheckBox closeWhenFinishedCheckBox;
    private FileJob job;
    private TransferFileJob transferFileJob;
    private boolean firstTimeActivated = true;
    private static final Dimension MAXIMUM_DIALOG_DIMENSION = new Dimension(320, 10000);
    private static final Dimension MINIMUM_DIALOG_DIMENSION = new Dimension(320, 0);

    public ProgressDialog(MainFrame mainFrame, String title) {
        super((Frame)mainFrame, title, (Component)mainFrame);
        this.setMaximumSize(MAXIMUM_DIALOG_DIMENSION);
        this.setMinimumSize(MINIMUM_DIALOG_DIMENSION);
        this.setResizable(false);
    }

    private void initUI() {
        JButton[] jButtonArray;
        Container contentPane = this.getContentPane();
        this.totalProgressBar = new JProgressBar();
        this.totalProgressBar.setStringPainted(true);
        this.totalProgressBar.setAlignmentX(0.0f);
        this.currentFileLabel = new JLabel(this.job.getStatusString());
        this.currentFileLabel.setAlignmentX(0.0f);
        YBoxPanel yPanel = new YBoxPanel();
        if (this.transferFileJob != null) {
            yPanel.add(this.currentFileLabel);
            this.currentFileProgressBar = new JProgressBar();
            this.currentFileProgressBar.setStringPainted(true);
            yPanel.add(this.currentFileProgressBar);
            yPanel.addSpace(10);
            this.totalTransferredLabel = new JLabel(Translator.get("progress_dialog.starting", new String[0]));
            yPanel.add(this.totalTransferredLabel);
            yPanel.add(this.totalProgressBar);
        } else {
            yPanel.add(this.currentFileLabel);
            yPanel.add(this.totalProgressBar);
        }
        yPanel.addSpace(10);
        this.elapsedTimeLabel = new JLabel(Translator.get("progress_dialog.elapsed_time", new String[0]) + ": ");
        this.elapsedTimeLabel.setIcon(IconManager.getIcon(2, "waiting.png"));
        yPanel.add(this.elapsedTimeLabel);
        if (this.transferFileJob != null) {
            JPanel tempPanel = new JPanel(new BorderLayout());
            this.currentSpeedLabel = new JLabel();
            this.updateCurrentSpeedLabel("");
            this.currentSpeedLabel.setIcon(IconManager.getIcon(5, "speed.png"));
            tempPanel.add((Component)this.currentSpeedLabel, "West");
            YBoxPanel advancedPanel = new YBoxPanel();
            this.speedGraph = new SpeedGraph();
            this.speedGraph.setPreferredSize(new Dimension(0, 80));
            advancedPanel.add(this.speedGraph);
            advancedPanel.addSpace(5);
            JPanel tempPanel2 = new JPanel(new BorderLayout());
            this.limitSpeedCheckBox = new JCheckBox(Translator.get("progress_dialog.limit_speed", new String[0]) + ":", false);
            this.limitSpeedCheckBox.addItemListener(this);
            tempPanel2.add((Component)this.limitSpeedCheckBox, "West");
            this.speedChooser = new SizeChooser(true);
            this.speedChooser.setEnabled(false);
            this.speedChooser.addChangeListener(this);
            tempPanel2.add((Component)this.speedChooser, "East");
            advancedPanel.add(tempPanel2);
            advancedPanel.addSpace(5);
            this.collapseExpandButton = new CollapseExpandButton(Translator.get("progress_dialog.advanced", new String[0]), advancedPanel, true);
            this.collapseExpandButton.setExpandedState(MuConfigurations.getPreferences().getVariable(MuPreference.PROGRESS_DIALOG_EXPANDED, true));
            tempPanel.add((Component)this.collapseExpandButton, "East");
            yPanel.add(tempPanel);
            yPanel.addSpace(5);
            yPanel.add(advancedPanel);
        }
        this.closeWhenFinishedCheckBox = new JCheckBox(Translator.get("progress_dialog.close_when_finished", new String[0]));
        this.closeWhenFinishedCheckBox.setSelected(MuConfigurations.getPreferences().getVariable(MuPreference.PROGRESS_DIALOG_CLOSE_WHEN_FINISHED, true));
        yPanel.add(this.closeWhenFinishedCheckBox);
        yPanel.add(Box.createVerticalGlue());
        contentPane.add((Component)yPanel, "Center");
        this.pauseResumeButton = new JButton(Translator.get("pause", new String[0]), IconManager.getIcon(5, "pause.png"));
        this.pauseResumeButton.addActionListener(this);
        if (this.transferFileJob != null) {
            this.skipButton = new JButton(Translator.get("skip", new String[0]), IconManager.getIcon(5, "skip.png"));
            this.skipButton.addActionListener(this);
        }
        this.stopButton = new JButton(Translator.get("stop", new String[0]), IconManager.getIcon(5, "stop.png"));
        this.stopButton.addActionListener(this);
        if (this.skipButton == null) {
            JButton[] jButtonArray2 = new JButton[2];
            jButtonArray2[0] = this.pauseResumeButton;
            jButtonArray = jButtonArray2;
            jButtonArray2[1] = this.stopButton;
        } else {
            JButton[] jButtonArray3 = new JButton[3];
            jButtonArray3[0] = this.pauseResumeButton;
            jButtonArray3[1] = this.skipButton;
            jButtonArray = jButtonArray3;
            jButtonArray3[2] = this.stopButton;
        }
        this.buttonsChoicePanel = new ButtonChoicePanel(jButtonArray, 0, this.getRootPane());
        contentPane.add((Component)this.buttonsChoicePanel, "South");
        this.setInitialFocusComponent(this.stopButton);
        this.getRootPane().setDefaultButton(this.stopButton);
    }

    public void start(FileJob job) {
        this.job = job;
        job.addFileJobListener(this);
        if (job instanceof TransferFileJob) {
            this.transferFileJob = (TransferFileJob)job;
        }
        this.initUI();
        JobProgressMonitor.getInstance().addJob(job);
        JobProgressMonitor.getInstance().addJobProgressListener(this);
        this.showDialog();
    }

    public void stop() {
        JobProgressMonitor.getInstance().removeJobProgressListener(this);
    }

    private void updateThroughputLimit() {
        this.transferFileJob.setThroughputLimit(this.limitSpeedCheckBox.isSelected() ? this.speedChooser.getValue() : -1L);
    }

    private void updateCurrentSpeedLabel(String value) {
        this.currentSpeedLabel.setText(Translator.get("progress_dialog.current_speed", new String[0]) + ": " + value);
    }

    public void jobStateChanged(FileJob source, int oldState, int newState) {
        LOGGER.debug("currentThread=" + Thread.currentThread() + " oldState=" + oldState + " newState=" + newState);
        if (newState == 3) {
            this.stop();
            this.dispose();
        } else if (newState == 4) {
            if (this.closeWhenFinishedCheckBox.isSelected()) {
                this.stop();
                this.dispose();
            } else {
                this.stopButton.setText(Translator.get("close", new String[0]));
                this.pauseResumeButton.setEnabled(false);
                if (this.transferFileJob != null) {
                    this.skipButton.setEnabled(false);
                    this.limitSpeedCheckBox.setEnabled(false);
                    this.speedChooser.setEnabled(false);
                }
            }
        } else if (newState == 2) {
            this.pauseResumeButton.setText(Translator.get("resume", new String[0]));
            this.pauseResumeButton.setIcon(IconManager.getIcon(5, "resume.png"));
            this.buttonsChoicePanel.updateMnemonics();
            if (this.transferFileJob != null) {
                this.updateCurrentSpeedLabel("N/A");
            }
        } else if (newState == 1) {
            this.pauseResumeButton.setText(Translator.get("pause", new String[0]));
            this.pauseResumeButton.setIcon(IconManager.getIcon(5, "pause.png"));
            this.buttonsChoicePanel.updateMnemonics();
        }
    }

    private void updateProgressLabel(JobProgress progress) {
        this.currentFileLabel.setText(progress.getJobStatusString());
    }

    private void updateProgressUI(JobProgress progress) {
        if (progress.isTransferFileJob()) {
            this.currentFileProgressBar.setValue(progress.getFilePercentInt());
            this.currentFileProgressBar.setString(progress.getFileProgressText());
            this.totalTransferredLabel.setText(Translator.get("progress_dialog.transferred", SizeFormat.format(progress.getBytesTotal(), 146), SizeFormat.format(progress.getTotalBps(), 170)));
            if (progress.getLastTime() > progress.getJobPauseStartDate()) {
                this.speedGraph.addSample(progress.getCurrentBps());
                this.updateCurrentSpeedLabel(SizeFormat.format(progress.getCurrentBps(), 42));
            }
        }
        this.totalProgressBar.setValue(progress.getTotalPercentInt());
        this.totalProgressBar.setString(progress.getTotalProgressText());
        this.elapsedTimeLabel.setText(Translator.get("progress_dialog.elapsed_time", new String[0]) + ": " + DurationFormat.format(progress.getEffectiveJobTime()));
    }

    public void jobAdded(FileJob source, int idx) {
    }

    public void jobRemoved(FileJob source, int idx) {
    }

    public void jobProgress(FileJob source, int idx, boolean fullUpdate) {
        if (this.job.equals(source)) {
            this.updateProgressLabel(source.getJobProgress());
            if (fullUpdate) {
                this.updateProgressUI(source.getJobProgress());
            }
        }
    }

    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.stopButton) {
            int jobState = this.job.getState();
            if (jobState == 4 || jobState == 3) {
                this.dispose();
            } else {
                this.job.interrupt();
            }
        } else if (source == this.skipButton) {
            this.transferFileJob.skipCurrentFile();
        } else if (source == this.pauseResumeButton) {
            this.job.setPaused(this.job.getState() != 2);
        }
    }

    public void itemStateChanged(ItemEvent e) {
        Object source = e.getSource();
        if (source == this.limitSpeedCheckBox) {
            boolean isEnabled = this.limitSpeedCheckBox.isSelected();
            this.speedChooser.setEnabled(isEnabled);
            this.updateThroughputLimit();
        }
    }

    public void stateChanged(ChangeEvent e) {
        if (e.getSource() == this.speedChooser) {
            this.updateThroughputLimit();
        }
    }

    public void windowActivated(WindowEvent e) {
        super.windowActivated(e);
        if (this.firstTimeActivated) {
            this.firstTimeActivated = false;
            this.job.start();
        }
    }

    public void windowClosed(WindowEvent e) {
        super.windowClosed(e);
        this.stop();
        int jobState = this.job.getState();
        if (jobState != 4 && jobState != 3) {
            this.job.interrupt();
        }
        if (this.collapseExpandButton != null) {
            MuConfigurations.getPreferences().setVariable(MuPreference.PROGRESS_DIALOG_EXPANDED, this.collapseExpandButton.getExpandedState());
        }
        MuConfigurations.getPreferences().setVariable(MuPreference.PROGRESS_DIALOG_CLOSE_WHEN_FINISHED, this.closeWhenFinishedCheckBox.isSelected());
    }

    static {
        UIManager.put("ProgressBar.repaintInterval", Integer.MAX_VALUE);
    }

    private class SpeedGraph
    extends JPanel {
        private final Color GRAPH_OUTLINE_COLOR = new Color(70, 70, 70);
        private final Color GRAPH_FILL_COLOR = new Color(215, 215, 215);
        private final Color BPS_LIMIT_COLOR = new Color(204, 0, 0);
        private List<Long> samples = new Vector<Long>(320);
        private Stroke lineStroke = new BasicStroke(1.0f);

        private SpeedGraph() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void addSample(long bytesPerSecond) {
            List<Long> list = this.samples;
            synchronized (list) {
                if (this.samples.size() == 320) {
                    this.samples.remove(0);
                }
                this.samples.add(bytesPerSecond);
            }
            this.repaint();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void paint(Graphics g) {
            Graphics2D g2d = (Graphics2D)g;
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            int width = this.getWidth();
            int height = this.getHeight();
            g.setColor(this.getBackground());
            g.fillRect(0, 0, width, height);
            g2d.setStroke(this.lineStroke);
            List<Long> list = this.samples;
            synchronized (list) {
                int l;
                int nbSamples = this.samples.size();
                int nbDisplayableSamples = (width - 2) / 6;
                int firstSample = nbSamples > nbDisplayableSamples ? nbSamples - nbDisplayableSamples : 0;
                int nbLines = Math.min(nbSamples, nbDisplayableSamples);
                long maxBps = 0L;
                for (int i = firstSample; i < firstSample + nbLines; ++i) {
                    long sample = this.samples.get(i);
                    if (sample <= maxBps) continue;
                    maxBps = sample;
                }
                float yRatio = (float)maxBps / ((float)height - 2.0f);
                long bpsLimit = ProgressDialog.this.transferFileJob.getThroughputLimit();
                if (bpsLimit > 0L) {
                    g.setColor(this.BPS_LIMIT_COLOR);
                    int y = height - 1 - (int)((float)bpsLimit / yRatio);
                    g.drawLine(0, y, width, y);
                }
                g.setColor(this.GRAPH_FILL_COLOR);
                int x = 1;
                Polygon p = new Polygon();
                int sampleOffset = firstSample;
                for (l = 0; l < nbLines; ++l) {
                    p.addPoint(x, height - 1 - (int)((float)this.samples.get(sampleOffset++).longValue() / yRatio));
                    x += 6;
                }
                p.addPoint(x - 6, height - 1);
                p.addPoint(0, height - 1);
                g.fillPolygon(p);
                g.setColor(this.GRAPH_OUTLINE_COLOR);
                x = 1;
                sampleOffset = firstSample;
                for (l = 0; l < nbLines - 1; ++l) {
                    g.drawLine(x, height - 1 - (int)((float)this.samples.get(sampleOffset).longValue() / yRatio), x += 6, height - 1 - (int)((float)this.samples.get(++sampleOffset).longValue() / yRatio));
                }
                g.drawLine(0, height - 1, width - 1, height - 1);
            }
        }
    }
}

