/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.ui.dialog.file;

import com.mucommander.commons.file.util.FileSet;
import com.mucommander.commons.file.util.PathUtils;
import com.mucommander.job.TransferFileJob;
import com.mucommander.text.Translator;
import com.mucommander.ui.dialog.DialogToolkit;
import com.mucommander.ui.dialog.file.FileCollisionDialog;
import com.mucommander.ui.dialog.file.JobDialog;
import com.mucommander.ui.dialog.file.PathFieldContent;
import com.mucommander.ui.dialog.file.ProgressDialog;
import com.mucommander.ui.icon.SpinningDial;
import com.mucommander.ui.layout.AsyncPanel;
import com.mucommander.ui.layout.YBoxPanel;
import com.mucommander.ui.main.MainFrame;
import com.mucommander.ui.text.FilePathField;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.lang.reflect.InvocationTargetException;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class TransferDestinationDialog
extends JobDialog
implements ActionListener,
DocumentListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(TransferDestinationDialog.class);
    protected String errorDialogTitle;
    private boolean enableTransferOptions;
    private YBoxPanel mainPanel;
    private FilePathField pathField;
    private SpinningDial spinningDial;
    private JComboBox fileExistsActionComboBox;
    private JCheckBox skipErrorsCheckBox;
    private JCheckBox verifyIntegrityCheckBox;
    private JButton okButton;
    private Thread thread;
    protected static final Dimension MINIMUM_DIALOG_DIMENSION = new Dimension(360, 0);
    protected static final Dimension MAXIMUM_DIALOG_DIMENSION = new Dimension(400, 10000);
    private static final int[] DEFAULT_ACTIONS = new int[]{0, 1, 2, 3, 4, 5};
    private static final String[] DEFAULT_ACTIONS_TEXT = new String[]{FileCollisionDialog.CANCEL_TEXT, FileCollisionDialog.SKIP_TEXT, FileCollisionDialog.OVERWRITE_TEXT, FileCollisionDialog.OVERWRITE_IF_OLDER_TEXT, FileCollisionDialog.RESUME_TEXT, FileCollisionDialog.RENAME_TEXT};

    public TransferDestinationDialog(MainFrame mainFrame, FileSet files, String title, String labelText, String okText, String errorDialogTitle, boolean enableTransferOptions) {
        super(mainFrame, title, files);
        this.errorDialogTitle = errorDialogTitle;
        this.enableTransferOptions = enableTransferOptions;
        this.mainPanel = new YBoxPanel();
        this.mainPanel.add(new JLabel(labelText + " :"));
        this.pathField = new FilePathField();
        JPanel borderPanel = new JPanel(new BorderLayout());
        borderPanel.add((Component)this.pathField, "Center");
        this.spinningDial = new SpinningDial(false);
        borderPanel.add((Component)new JLabel(this.spinningDial), "East");
        this.mainPanel.add(borderPanel);
        this.mainPanel.addSpace(10);
        this.pathField.getDocument().addDocumentListener(this);
        this.setInitialFocusComponent(this.pathField);
        if (enableTransferOptions) {
            this.mainPanel.add(new JLabel(Translator.get("destination_dialog.file_exists_action", new String[0]) + " :"));
            this.fileExistsActionComboBox = new JComboBox();
            this.fileExistsActionComboBox.addItem(Translator.get("ask", new String[0]));
            int nbChoices = DEFAULT_ACTIONS_TEXT.length;
            for (int i = 0; i < nbChoices; ++i) {
                this.fileExistsActionComboBox.addItem(DEFAULT_ACTIONS_TEXT[i]);
            }
            this.mainPanel.add(this.fileExistsActionComboBox);
            this.skipErrorsCheckBox = new JCheckBox(Translator.get("destination_dialog.skip_errors", new String[0]));
            this.mainPanel.add(this.skipErrorsCheckBox);
            this.verifyIntegrityCheckBox = new JCheckBox(Translator.get("destination_dialog.verify_integrity", new String[0]));
            this.mainPanel.add(this.verifyIntegrityCheckBox);
            this.mainPanel.addSpace(10);
        }
        this.getContentPane().add((Component)this.mainPanel, "North");
        AsyncPanel fileDetailsPanel = this.createFileDetailsPanel();
        this.okButton = new JButton(okText);
        this.okButton.setEnabled(false);
        JButton cancelButton = new JButton(Translator.get("cancel", new String[0]));
        YBoxPanel buttonsPanel = new YBoxPanel();
        buttonsPanel.add(this.createButtonsPanel(this.createFileDetailsButton(fileDetailsPanel), DialogToolkit.createOKCancelPanel(this.okButton, cancelButton, this.getRootPane(), this)));
        buttonsPanel.add(fileDetailsPanel);
        this.getContentPane().add((Component)buttonsPanel, "South");
        this.setMinimumSize(MINIMUM_DIALOG_DIMENSION);
        this.setMaximumSize(MAXIMUM_DIALOG_DIMENSION);
        this.setDefaultCloseOperation(2);
        this.addWindowListener(new WindowAdapter(){

            public void windowOpened(WindowEvent e) {
                TransferDestinationDialog.this.startThread(new InitialPathRetriever());
            }

            public void windowClosed(WindowEvent e) {
                TransferDestinationDialog.this.interruptOngoingThread();
            }
        });
    }

    protected YBoxPanel getMainPanel() {
        return this.mainPanel;
    }

    protected FilePathField getPathField() {
        return this.pathField;
    }

    private synchronized void startThread(Thread thread) {
        this.interruptOngoingThread();
        this.spinningDial.setAnimated(true);
        this.thread = thread;
        thread.start();
    }

    private synchronized void interruptOngoingThread() {
        if (this.thread != null) {
            LOGGER.trace("Calling interrupt() on " + this.thread);
            this.thread.interrupt();
            this.thread = null;
        }
    }

    protected boolean isValidDestination(PathUtils.ResolvedDestination resolvedDest, String destPath) {
        return resolvedDest != null && (this.files.size() == 1 || resolvedDest.getDestinationType() == 0);
    }

    private void startJob(PathUtils.ResolvedDestination resolvedDest) {
        boolean verifyIntegrity;
        boolean skipErrors;
        int defaultFileExistsAction;
        if (this.enableTransferOptions) {
            defaultFileExistsAction = this.fileExistsActionComboBox.getSelectedIndex();
            defaultFileExistsAction = defaultFileExistsAction == 0 ? -1 : DEFAULT_ACTIONS[defaultFileExistsAction - 1];
            skipErrors = this.skipErrorsCheckBox.isSelected();
            verifyIntegrity = this.verifyIntegrityCheckBox.isSelected();
        } else {
            defaultFileExistsAction = -1;
            skipErrors = false;
            verifyIntegrity = false;
        }
        ProgressDialog progressDialog = new ProgressDialog(this.mainFrame, this.getProgressDialogTitle());
        TransferFileJob job = this.createTransferFileJob(progressDialog, resolvedDest, defaultFileExistsAction);
        if (job != null) {
            job.setAutoSkipErrors(skipErrors);
            job.setIntegrityCheckEnabled(verifyIntegrity);
            progressDialog.start(job);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void textUpdated() {
        TransferDestinationDialog transferDestinationDialog = this;
        synchronized (transferDestinationDialog) {
            if (this.thread != null && this.thread instanceof InitialPathRetriever) {
                this.interruptOngoingThread();
                this.okButton.setEnabled(true);
                this.pathField.getDocument().removeDocumentListener(this);
            }
        }
    }

    public void insertUpdate(DocumentEvent e) {
        this.textUpdated();
    }

    public void removeUpdate(DocumentEvent e) {
        this.textUpdated();
    }

    public void changedUpdate(DocumentEvent e) {
    }

    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.okButton) {
            this.okButton.setEnabled(false);
            this.pathField.setEnabled(false);
            this.startThread(new PathResolver());
        } else {
            this.dispose();
        }
    }

    protected abstract PathFieldContent computeInitialPath(FileSet var1);

    protected abstract TransferFileJob createTransferFileJob(ProgressDialog var1, PathUtils.ResolvedDestination var2, int var3);

    protected abstract String getProgressDialogTitle();

    private class PathResolver
    extends Thread {
        private boolean interrupted;

        private PathResolver() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            TransferDestinationDialog.this.spinningDial.setAnimated(false);
            final String destPath = TransferDestinationDialog.this.pathField.getText();
            final PathUtils.ResolvedDestination resolvedDest = PathUtils.resolveDestination(destPath, TransferDestinationDialog.this.mainFrame.getActiveTable().getCurrentFolder());
            final boolean isValid = TransferDestinationDialog.this.isValidDestination(resolvedDest, destPath);
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    if (PathResolver.this.interrupted) {
                        TransferDestinationDialog.this.dispose();
                    } else if (isValid) {
                        TransferDestinationDialog.this.dispose();
                        TransferDestinationDialog.this.startJob(resolvedDest);
                    } else {
                        TransferDestinationDialog.this.showErrorDialog(Translator.get("invalid_path", destPath), TransferDestinationDialog.this.errorDialogTitle);
                        TransferDestinationDialog.this.okButton.setEnabled(true);
                        TransferDestinationDialog.this.pathField.setEnabled(true);
                    }
                }
            });
            TransferDestinationDialog transferDestinationDialog = TransferDestinationDialog.this;
            synchronized (transferDestinationDialog) {
                if (TransferDestinationDialog.this.thread == this) {
                    TransferDestinationDialog.this.thread = null;
                }
            }
        }

        public void interrupt() {
            super.interrupt();
            this.interrupted = true;
        }
    }

    private class InitialPathRetriever
    extends Thread {
        private boolean interrupted;

        private InitialPathRetriever() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            final PathFieldContent pathFieldContent = TransferDestinationDialog.this.computeInitialPath(TransferDestinationDialog.this.files);
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    public void run() {
                        TransferDestinationDialog.this.spinningDial.setAnimated(false);
                        if (!InitialPathRetriever.this.interrupted) {
                            TransferDestinationDialog.this.pathField.getDocument().removeDocumentListener(TransferDestinationDialog.this);
                            pathFieldContent.feedToPathField(TransferDestinationDialog.this.pathField);
                            TransferDestinationDialog.this.okButton.setEnabled(true);
                        }
                    }
                });
            }
            catch (InterruptedException e) {
                LOGGER.trace("Interrupted", e);
            }
            catch (InvocationTargetException e) {
                LOGGER.debug("Caught exception", e);
            }
            TransferDestinationDialog transferDestinationDialog = TransferDestinationDialog.this;
            synchronized (transferDestinationDialog) {
                if (TransferDestinationDialog.this.thread == this) {
                    TransferDestinationDialog.this.thread = null;
                }
            }
        }

        public void interrupt() {
            super.interrupt();
            this.interrupted = true;
        }
    }
}

