/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.ui.dialog.help;

import com.mucommander.text.Translator;
import com.mucommander.ui.action.ActionCategory;
import com.mucommander.ui.action.ActionKeymap;
import com.mucommander.ui.action.ActionManager;
import com.mucommander.ui.action.ActionProperties;
import com.mucommander.ui.dialog.DialogToolkit;
import com.mucommander.ui.dialog.FocusDialog;
import com.mucommander.ui.layout.XAlignedComponentPanel;
import com.mucommander.ui.main.MainFrame;
import com.mucommander.ui.text.KeyStrokeUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collections;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShortcutsDialog
extends FocusDialog
implements ActionListener {
    private static final Map<String, String> QUICK_SEARCH_SHORTCUTS = new Hashtable<String, String>(){
        {
            this.put("shortcuts_dialog.quick_search.start_search", "");
            this.put("shortcuts_dialog.quick_search.jump_to_previous", "UP");
            this.put("shortcuts_dialog.quick_search.jump_to_next", "DOWN");
            this.put("shortcuts_dialog.quick_search.remove_last_char", "BACKSPACE");
            this.put("shortcuts_dialog.quick_search.mark_jump_next", "INSERT");
            this.put("shortcuts_dialog.quick_search.cancel_search", "ESCAPE");
        }
    };
    private static final Comparator<String> ACTIONS_COMPARATOR = new Comparator<String>(){

        @Override
        public int compare(String id1, String id2) {
            String label1 = ActionProperties.getActionLabel(id1);
            if (label1 == null) {
                return 1;
            }
            String label2 = ActionProperties.getActionLabel(id2);
            if (label2 == null) {
                return -1;
            }
            return label1.compareTo(label2);
        }
    };

    public ShortcutsDialog(MainFrame mainFrame) {
        super((Frame)mainFrame, ActionProperties.getActionLabel("ShowKeyboardShortcuts"), (Component)mainFrame);
        Container contentPane = this.getContentPane();
        JTabbedPane tabbedPane = new JTabbedPane(1);
        Map<ActionCategory, LinkedList<String>> categoryToItsActionsWithShortcutsIdsMap = this.createCategoryToItsActionsWithShortcutsMap();
        for (ActionCategory category : categoryToItsActionsWithShortcutsIdsMap.keySet()) {
            LinkedList<String> categoryActionsWithShortcuts = categoryToItsActionsWithShortcutsIdsMap.get(category);
            Collections.sort(categoryActionsWithShortcuts, ACTIONS_COMPARATOR);
            if (categoryActionsWithShortcuts.isEmpty()) continue;
            this.addTopic(tabbedPane, "" + category, categoryActionsWithShortcuts.iterator());
        }
        this.addTopic(tabbedPane, Translator.get("shortcuts_dialog.quick_search", new String[0]), QUICK_SEARCH_SHORTCUTS);
        contentPane.add((Component)tabbedPane, "Center");
        JButton okButton = new JButton(Translator.get("ok", new String[0]));
        contentPane.add((Component)DialogToolkit.createOKPanel(okButton, this.getRootPane(), this), "South");
        this.getRootPane().setDefaultButton(okButton);
        this.setInitialFocusComponent(tabbedPane);
        this.setMaximumSize(new Dimension(600, 360));
    }

    private Map<ActionCategory, LinkedList<String>> createCategoryToItsActionsWithShortcutsMap() {
        Hashtable<ActionCategory, LinkedList<String>> categoryToItsActionsWithShortcutsIdsMap = new Hashtable<ActionCategory, LinkedList<String>>();
        for (ActionCategory category : ActionProperties.getActionCategories()) {
            categoryToItsActionsWithShortcutsIdsMap.put(category, new LinkedList());
        }
        Iterator<String> actionIds = ActionManager.getActionIds();
        while (actionIds.hasNext()) {
            String actionId = actionIds.next();
            ActionCategory category = ActionProperties.getActionCategory(actionId);
            if (category == null || !ActionKeymap.doesActionHaveShortcut(actionId)) continue;
            categoryToItsActionsWithShortcutsIdsMap.get(category).add(actionId);
        }
        return categoryToItsActionsWithShortcutsIdsMap;
    }

    private void addTopic(JTabbedPane tabbedPane, String titleKey, Iterator<String> descriptionsIterator) {
        XAlignedComponentPanel compPanel = new XAlignedComponentPanel(15);
        this.addShortcutList(compPanel, descriptionsIterator);
        JPanel northPanel = new JPanel(new BorderLayout());
        northPanel.add((Component)compPanel, "North");
        JScrollPane scrollPane = new JScrollPane(northPanel, 20, 30);
        scrollPane.setBorder(null);
        tabbedPane.addTab(titleKey, scrollPane);
    }

    private void addTopic(JTabbedPane tabbedPane, String titleKey, Map<String, String> actionsToShortcutsMap) {
        XAlignedComponentPanel compPanel = new XAlignedComponentPanel(15);
        this.addShortcutList(compPanel, actionsToShortcutsMap);
        JPanel northPanel = new JPanel(new BorderLayout());
        northPanel.add((Component)compPanel, "North");
        JScrollPane scrollPane = new JScrollPane(northPanel, 20, 30);
        scrollPane.setBorder(null);
        tabbedPane.addTab(titleKey, scrollPane);
    }

    private void addShortcutList(XAlignedComponentPanel compPanel, Iterator<String> muActionIdsIterator) {
        while (muActionIdsIterator.hasNext()) {
            String actionId = muActionIdsIterator.next();
            KeyStroke shortcut = ActionKeymap.getAccelerator(actionId);
            String shortcutsRep = KeyStrokeUtils.getKeyStrokeDisplayableRepresentation(shortcut);
            shortcut = ActionKeymap.getAlternateAccelerator(actionId);
            if (shortcut != null) {
                shortcutsRep = shortcutsRep + " / " + KeyStrokeUtils.getKeyStrokeDisplayableRepresentation(shortcut);
            }
            compPanel.addRow(shortcutsRep, (JComponent)new JLabel(ActionProperties.getActionDescription(actionId)), 5);
        }
    }

    private void addShortcutList(XAlignedComponentPanel compPanel, Map<String, String> actionsToShortcutsMap) {
        Vector<String> vec = new Vector<String>(actionsToShortcutsMap.keySet());
        Collections.sort(vec);
        for (String action : vec) {
            compPanel.addRow(actionsToShortcutsMap.get(action), (JComponent)new JLabel(Translator.get(action, new String[0])), 5);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.dispose();
    }
}

