/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.ui.dialog.pref;

import com.mucommander.text.Translator;
import com.mucommander.ui.dialog.FocusDialog;
import com.mucommander.ui.dialog.pref.PreferencesPanel;
import com.mucommander.ui.dialog.pref.component.PrefComponent;
import com.mucommander.ui.icon.IconManager;
import com.mucommander.ui.layout.XBoxPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;

public abstract class PreferencesDialog
extends FocusDialog
implements ActionListener {
    private JTabbedPane tabbedPane;
    private List<PreferencesPanel> prefPanels;
    private JButton applyButton;
    private JButton okButton;
    private JButton cancelButton;

    public PreferencesDialog(Frame parent, String title) {
        super(parent, title, (Component)parent);
        this.initUI();
    }

    public PreferencesDialog(Dialog parent, String title) {
        super(parent, title, (Component)parent);
        this.initUI();
    }

    private void initUI() {
        this.prefPanels = new Vector<PreferencesPanel>();
        this.tabbedPane = new JTabbedPane(1);
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        contentPane.add((Component)this.tabbedPane, "Center");
        XBoxPanel buttonsPanel = new XBoxPanel();
        this.applyButton = new JButton(Translator.get("apply", new String[0]));
        buttonsPanel.add(this.applyButton);
        buttonsPanel.addSpace(20);
        this.okButton = new JButton(Translator.get("ok", new String[0]));
        buttonsPanel.add(this.okButton);
        this.cancelButton = new JButton(Translator.get("cancel", new String[0]));
        buttonsPanel.add(this.cancelButton);
        this.okButton.setEnabled(false);
        this.applyButton.setEnabled(false);
        this.applyButton.addActionListener(this);
        this.okButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
        JPanel tempPanel = new JPanel(new FlowLayout(2));
        tempPanel.add(buttonsPanel);
        contentPane.add((Component)tempPanel, "South");
        this.getRootPane().setDefaultButton(this.okButton);
    }

    private Component getTabbedPanel(PreferencesPanel prefPanel, boolean scroll) {
        if (scroll) {
            JScrollPane scrollPane = new JScrollPane(prefPanel, 20, 31);
            scrollPane.setBorder(null);
            return scrollPane;
        }
        return prefPanel;
    }

    public void addPreferencesPanel(PreferencesPanel prefPanel, String iconName, boolean scroll) {
        this.tabbedPane.addTab(prefPanel.getTitle(), IconManager.getIcon(4, iconName), this.getTabbedPanel(prefPanel, scroll));
        this.prefPanels.add(prefPanel);
    }

    public void addPreferencesPanel(PreferencesPanel prefPanel, String iconName) {
        this.addPreferencesPanel(prefPanel, iconName, true);
    }

    public void addPreferencesPanel(PreferencesPanel prefPanel, boolean scroll) {
        this.tabbedPane.addTab(prefPanel.getTitle(), this.getTabbedPanel(prefPanel, scroll));
        this.prefPanels.add(prefPanel);
    }

    public void addPreferencesPanel(PreferencesPanel prefPanel) {
        this.addPreferencesPanel(prefPanel, true);
    }

    public void commit() {
        int nbPanels = this.prefPanels.size();
        for (int i = 0; i < nbPanels; ++i) {
            this.prefPanels.get(i).commit();
        }
        this.setCommitButtonsEnabled(false);
    }

    public boolean checkCommit() {
        int nbPanels = this.prefPanels.size();
        for (int i = 0; i < nbPanels; ++i) {
            if (this.prefPanels.get(i).checkCommit()) continue;
            return false;
        }
        return true;
    }

    public void setActiveTab(int index) {
        this.tabbedPane.setSelectedIndex(index);
    }

    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.okButton || source == this.applyButton) {
            if (!this.checkCommit()) {
                return;
            }
            this.commit();
        }
        if (source == this.okButton || source == this.cancelButton) {
            this.dispose();
        }
    }

    public int getSelectedPanelIndex() {
        return this.tabbedPane.getSelectedIndex();
    }

    protected void setCommitButtonsEnabled(boolean enable) {
        this.okButton.setEnabled(enable);
        this.applyButton.setEnabled(enable);
    }

    public abstract void componentChanged(PrefComponent var1);
}

