/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.ui.dialog.pref.general;

import com.mucommander.commons.file.AbstractFile;
import com.mucommander.commons.file.FileFactory;
import com.mucommander.commons.runtime.OsFamilies;
import com.mucommander.commons.runtime.OsVersions;
import com.mucommander.conf.MuConfigurations;
import com.mucommander.conf.MuPreference;
import com.mucommander.extension.ClassFinder;
import com.mucommander.extension.ExtensionManager;
import com.mucommander.extension.LookAndFeelFilter;
import com.mucommander.job.FileCollisionChecker;
import com.mucommander.text.Translator;
import com.mucommander.ui.dialog.InformationDialog;
import com.mucommander.ui.dialog.QuestionDialog;
import com.mucommander.ui.dialog.file.FileCollisionDialog;
import com.mucommander.ui.dialog.pref.PreferencesDialog;
import com.mucommander.ui.dialog.pref.PreferencesPanel;
import com.mucommander.ui.dialog.pref.component.PrefCheckBox;
import com.mucommander.ui.dialog.pref.component.PrefComboBox;
import com.mucommander.ui.dialog.pref.general.ThemeNameDialog;
import com.mucommander.ui.dialog.pref.theme.ThemeEditorDialog;
import com.mucommander.ui.icon.FileIcons;
import com.mucommander.ui.icon.IconManager;
import com.mucommander.ui.icon.SpinningDial;
import com.mucommander.ui.layout.ProportionalGridPanel;
import com.mucommander.ui.layout.YBoxPanel;
import com.mucommander.ui.main.WindowManager;
import com.mucommander.ui.theme.Theme;
import com.mucommander.ui.theme.ThemeManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.filechooser.FileFilter;
import javax.swing.plaf.basic.BasicComboBoxRenderer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class AppearancePanel
extends PreferencesPanel
implements ActionListener,
Runnable {
    private static final Logger LOGGER = LoggerFactory.getLogger(AppearancePanel.class);
    private PrefComboBox lookAndFeelComboBox;
    private UIManager.LookAndFeelInfo[] lookAndFeels;
    private PrefCheckBox brushedMetalCheckBox;
    private JButton importLookAndFeelButton;
    private JButton deleteLookAndFeelButton;
    private SpinningDial dial;
    private AbstractFile lookAndFeelLibrary;
    private PrefComboBox toolbarIconsSizeComboBox;
    private PrefComboBox commandBarIconsSizeComboBox;
    private PrefComboBox fileIconsSizeComboBox;
    private static final String[] ICON_SIZES = new String[]{"100%", "125%", "150%", "175%", "200%", "300%"};
    private static final float[] ICON_SCALE_FACTORS = new float[]{1.0f, 1.25f, 1.5f, 1.75f, 2.0f, 3.0f};
    private ImageIcon lockIcon;
    private ImageIcon transparentIcon;
    private PrefComboBox themeComboBox;
    private JButton editThemeButton;
    private JButton duplicateThemeButton;
    private JButton importThemeButton;
    private JButton exportThemeButton;
    private JButton renameThemeButton;
    private JButton deleteThemeButton;
    private JLabel typeLabel;
    private boolean ignoreComboChanges;
    private AbstractFile lastSelectedFolder;
    private PrefComboBox useSystemFileIconsComboBox;
    private List<String> customLookAndFeels;

    public AppearancePanel(PreferencesDialog parent) {
        super(parent, Translator.get("prefs_dialog.appearance_tab", new String[0]));
        this.initUI();
        this.initializeCustomLookAndFeels();
    }

    private void initUI() {
        YBoxPanel mainPanel = new YBoxPanel();
        mainPanel.add(this.createLookAndFeelPanel());
        mainPanel.add(Box.createRigidArea(new Dimension(0, 10)));
        mainPanel.add(this.createThemesPanel());
        mainPanel.add(Box.createRigidArea(new Dimension(0, 10)));
        mainPanel.add(this.createSystemIconsPanel());
        mainPanel.add(Box.createVerticalGlue());
        mainPanel.add(this.createIconSizePanel());
        mainPanel.add(Box.createRigidArea(new Dimension(0, 10)));
        this.setLayout(new BorderLayout());
        this.add((Component)mainPanel, "North");
        this.lookAndFeelComboBox.addDialogListener(this.parent);
        this.themeComboBox.addDialogListener(this.parent);
        this.useSystemFileIconsComboBox.addDialogListener(this.parent);
        this.toolbarIconsSizeComboBox.addDialogListener(this.parent);
        this.commandBarIconsSizeComboBox.addDialogListener(this.parent);
        this.fileIconsSizeComboBox.addDialogListener(this.parent);
        if (this.brushedMetalCheckBox != null) {
            this.brushedMetalCheckBox.addDialogListener(this.parent);
        }
    }

    private void populateLookAndFeels() {
        this.lookAndFeelComboBox.removeAllItems();
        this.initializeAvailableLookAndFeels();
        int currentIndex = -1;
        String currentName = UIManager.getLookAndFeel().getClass().getName();
        for (int i = 0; i < this.lookAndFeels.length; ++i) {
            if (this.lookAndFeels[i].getClassName().equals(currentName)) {
                currentIndex = i;
            }
            this.lookAndFeelComboBox.addItem(this.lookAndFeels[i].getName());
        }
        if (currentIndex == -1) {
            currentIndex = 0;
        }
        this.lookAndFeelComboBox.setSelectedIndex(currentIndex);
    }

    private JPanel createLookAndFeelPanel() {
        YBoxPanel lnfPanel = new YBoxPanel();
        lnfPanel.setAlignmentX(0.0f);
        lnfPanel.setBorder(BorderFactory.createTitledBorder(Translator.get("prefs_dialog.look_and_feel", new String[0])));
        this.lookAndFeelComboBox = new PrefComboBox(){

            public boolean hasChanged() {
                int selectedIndex = this.getSelectedIndex();
                if (selectedIndex < 0) {
                    return false;
                }
                return !AppearancePanel.this.lookAndFeels[selectedIndex].getClassName().equals(MuConfigurations.getPreferences().getVariable(MuPreference.LOOK_AND_FEEL));
            }
        };
        this.lookAndFeelComboBox.setRenderer(new BasicComboBoxRenderer(){

            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                JLabel label = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                if (index < 0) {
                    return label;
                }
                if (AppearancePanel.this.isLookAndFeelModifiable(AppearancePanel.this.lookAndFeels[index])) {
                    label.setIcon(AppearancePanel.this.transparentIcon);
                } else {
                    label.setIcon(AppearancePanel.this.lockIcon);
                }
                return label;
            }
        });
        this.populateLookAndFeels();
        this.importLookAndFeelButton = new JButton(Translator.get("prefs_dialog.import", new String[0]) + "...");
        this.deleteLookAndFeelButton = new JButton(Translator.get("delete", new String[0]));
        this.importLookAndFeelButton.addActionListener(this);
        this.deleteLookAndFeelButton.addActionListener(this);
        this.resetLookAndFeelButtons();
        this.lookAndFeelComboBox.addActionListener(this);
        JPanel flowPanel = new JPanel(new FlowLayout(0));
        flowPanel.add(this.lookAndFeelComboBox);
        flowPanel.add(this.importLookAndFeelButton);
        flowPanel.add(this.deleteLookAndFeelButton);
        this.dial = new SpinningDial();
        flowPanel.add(new JLabel(this.dial));
        ((Container)lnfPanel).add(flowPanel);
        if (OsFamilies.MAC_OS_X.isCurrent() && OsVersions.MAC_OS_X_10_4.isCurrentOrLower()) {
            this.brushedMetalCheckBox = new PrefCheckBox(Translator.get("prefs_dialog.use_brushed_metal", new String[0])){

                public boolean hasChanged() {
                    return !String.valueOf(this.isSelected()).equals(MuConfigurations.getPreferences().getVariable(MuPreference.USE_BRUSHED_METAL));
                }
            };
            this.brushedMetalCheckBox.setSelected(MuConfigurations.getPreferences().getVariable(MuPreference.USE_BRUSHED_METAL, false));
            flowPanel = new JPanel(new FlowLayout(0));
            flowPanel.add(this.brushedMetalCheckBox);
            ((Container)lnfPanel).add(flowPanel);
        }
        return lnfPanel;
    }

    private JPanel createIconSizePanel() {
        ProportionalGridPanel gridPanel = new ProportionalGridPanel(2);
        gridPanel.add(new JLabel(Translator.get("prefs_dialog.toolbar_icons", new String[0])));
        this.toolbarIconsSizeComboBox = this.createIconSizeCombo(MuPreference.TOOLBAR_ICON_SCALE, 1.0f);
        gridPanel.add(this.toolbarIconsSizeComboBox);
        gridPanel.add(new JLabel(Translator.get("prefs_dialog.command_bar_icons", new String[0])));
        this.commandBarIconsSizeComboBox = this.createIconSizeCombo(MuPreference.COMMAND_BAR_ICON_SCALE, 1.0f);
        gridPanel.add(this.commandBarIconsSizeComboBox);
        gridPanel.add(new JLabel(Translator.get("prefs_dialog.file_icons", new String[0])));
        this.fileIconsSizeComboBox = this.createIconSizeCombo(MuPreference.TABLE_ICON_SCALE, 1.0f);
        gridPanel.add(this.fileIconsSizeComboBox);
        JPanel flowPanel = new JPanel(new FlowLayout(3));
        flowPanel.setBorder(BorderFactory.createTitledBorder(Translator.get("prefs_dialog.icons_size", new String[0])));
        flowPanel.add(gridPanel);
        return flowPanel;
    }

    private JPanel createThemesPanel() {
        ProportionalGridPanel gridPanel = new ProportionalGridPanel(4);
        this.editThemeButton = new JButton(Translator.get("edit", new String[0]) + "...");
        this.importThemeButton = new JButton(Translator.get("prefs_dialog.import", new String[0]) + "...");
        this.exportThemeButton = new JButton(Translator.get("prefs_dialog.export", new String[0]) + "...");
        this.renameThemeButton = new JButton(Translator.get("rename", new String[0]));
        this.deleteThemeButton = new JButton(Translator.get("delete", new String[0]));
        this.duplicateThemeButton = new JButton(Translator.get("duplicate", new String[0]));
        this.editThemeButton.addActionListener(this);
        this.importThemeButton.addActionListener(this);
        this.exportThemeButton.addActionListener(this);
        this.renameThemeButton.addActionListener(this);
        this.deleteThemeButton.addActionListener(this);
        this.duplicateThemeButton.addActionListener(this);
        this.typeLabel = new JLabel("");
        this.themeComboBox = new PrefComboBox(){

            public boolean hasChanged() {
                return !ThemeManager.isCurrentTheme((Theme)this.getSelectedItem());
            }
        };
        this.themeComboBox.addActionListener(this);
        this.lockIcon = IconManager.getIcon(4, "lock.png");
        this.transparentIcon = new ImageIcon(new BufferedImage(this.lockIcon.getIconWidth(), this.lockIcon.getIconHeight(), 2));
        this.themeComboBox.setRenderer(new BasicComboBoxRenderer(){

            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                JLabel label = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                Theme theme = (Theme)value;
                if (ThemeManager.isCurrentTheme(theme)) {
                    label.setText(theme.getName() + " (" + Translator.get("theme.current", new String[0]) + ")");
                } else {
                    label.setText(theme.getName());
                }
                if (theme.getType() != 2) {
                    label.setIcon(AppearancePanel.this.lockIcon);
                } else {
                    label.setIcon(AppearancePanel.this.transparentIcon);
                }
                return label;
            }
        });
        this.populateThemes(ThemeManager.getCurrentTheme());
        ((Container)gridPanel).add(this.themeComboBox);
        ((Container)gridPanel).add(this.editThemeButton);
        ((Container)gridPanel).add(this.importThemeButton);
        ((Container)gridPanel).add(this.exportThemeButton);
        ((Container)gridPanel).add(this.typeLabel);
        ((Container)gridPanel).add(this.renameThemeButton);
        ((Container)gridPanel).add(this.deleteThemeButton);
        ((Container)gridPanel).add(this.duplicateThemeButton);
        JPanel flowPanel = new JPanel(new FlowLayout(3));
        flowPanel.setBorder(BorderFactory.createTitledBorder(Translator.get("prefs_dialog.themes", new String[0])));
        flowPanel.add(gridPanel);
        return flowPanel;
    }

    private void populateThemes(Theme currentTheme) {
        this.ignoreComboChanges = true;
        this.themeComboBox.removeAllItems();
        Iterator<Theme> themes = ThemeManager.availableThemes();
        while (themes.hasNext()) {
            this.themeComboBox.addItem(themes.next());
        }
        this.ignoreComboChanges = false;
        this.themeComboBox.setSelectedItem(currentTheme);
    }

    private JPanel createSystemIconsPanel() {
        this.useSystemFileIconsComboBox = new PrefComboBox(){

            public boolean hasChanged() {
                String systemIconsPolicy;
                switch (AppearancePanel.this.useSystemFileIconsComboBox.getSelectedIndex()) {
                    case 0: {
                        systemIconsPolicy = "never";
                        break;
                    }
                    case 1: {
                        systemIconsPolicy = "applications";
                        break;
                    }
                    default: {
                        systemIconsPolicy = "always";
                    }
                }
                return !systemIconsPolicy.equals(MuConfigurations.getPreferences().getVariable(MuPreference.USE_SYSTEM_FILE_ICONS, systemIconsPolicy));
            }
        };
        this.useSystemFileIconsComboBox.addItem(Translator.get("prefs_dialog.use_system_file_icons.never", new String[0]));
        this.useSystemFileIconsComboBox.addItem(Translator.get("prefs_dialog.use_system_file_icons.applications", new String[0]));
        this.useSystemFileIconsComboBox.addItem(Translator.get("prefs_dialog.use_system_file_icons.always", new String[0]));
        String systemIconsPolicy = FileIcons.getSystemIconsPolicy();
        this.useSystemFileIconsComboBox.setSelectedIndex("always".equals(systemIconsPolicy) ? 2 : ("applications".equals(systemIconsPolicy) ? 1 : 0));
        JPanel panel = new JPanel(new FlowLayout(0));
        panel.setBorder(BorderFactory.createTitledBorder(Translator.get("prefs_dialog.use_system_file_icons", new String[0])));
        panel.add(this.useSystemFileIconsComboBox);
        return panel;
    }

    private PrefComboBox createIconSizeCombo(final MuPreference preference, float defaultValue) {
        PrefComboBox iconSizeCombo = new PrefComboBox(){

            public boolean hasChanged() {
                return !String.valueOf(ICON_SCALE_FACTORS[this.getSelectedIndex()]).equals(MuConfigurations.getPreferences().getVariable(preference));
            }
        };
        for (String iconSize : ICON_SIZES) {
            iconSizeCombo.addItem(iconSize);
        }
        float scaleFactor = MuConfigurations.getPreferences().getVariable(preference, defaultValue);
        int index = 0;
        for (int i = 0; i < ICON_SCALE_FACTORS.length; ++i) {
            if (scaleFactor != ICON_SCALE_FACTORS[i]) continue;
            index = i;
            break;
        }
        iconSizeCombo.setSelectedIndex(index);
        return iconSizeCombo;
    }

    protected void commit() {
        int comboIndex;
        if (MuConfigurations.getPreferences().setVariable(MuPreference.LOOK_AND_FEEL, this.lookAndFeels[this.lookAndFeelComboBox.getSelectedIndex()].getClassName())) {
            this.resetLookAndFeelButtons();
            SwingUtilities.updateComponentTreeUI(this.parent);
        }
        if (this.brushedMetalCheckBox != null) {
            MuConfigurations.getPreferences().setVariable(MuPreference.USE_BRUSHED_METAL, this.brushedMetalCheckBox.isSelected());
        }
        float scaleFactor = ICON_SCALE_FACTORS[this.toolbarIconsSizeComboBox.getSelectedIndex()];
        MuConfigurations.getPreferences().setVariable(MuPreference.TOOLBAR_ICON_SCALE, scaleFactor);
        scaleFactor = ICON_SCALE_FACTORS[this.commandBarIconsSizeComboBox.getSelectedIndex()];
        MuConfigurations.getPreferences().setVariable(MuPreference.COMMAND_BAR_ICON_SCALE, scaleFactor);
        scaleFactor = ICON_SCALE_FACTORS[this.fileIconsSizeComboBox.getSelectedIndex()];
        FileIcons.setScaleFactor(scaleFactor);
        MuConfigurations.getPreferences().setVariable(MuPreference.TABLE_ICON_SCALE, scaleFactor);
        if (!ThemeManager.isCurrentTheme((Theme)this.themeComboBox.getSelectedItem())) {
            ThemeManager.setCurrentTheme((Theme)this.themeComboBox.getSelectedItem());
            this.resetThemeButtons((Theme)this.themeComboBox.getSelectedItem());
            this.themeComboBox.repaint();
        }
        String systemIconsPolicy = (comboIndex = this.useSystemFileIconsComboBox.getSelectedIndex()) == 0 ? "never" : (comboIndex == 1 ? "applications" : "always");
        FileIcons.setSystemIconsPolicy(systemIconsPolicy);
        MuConfigurations.getPreferences().setVariable(MuPreference.USE_SYSTEM_FILE_ICONS, systemIconsPolicy);
    }

    private void initializeCustomLookAndFeels() {
        this.customLookAndFeels = MuConfigurations.getPreferences().getListVariable(MuPreference.CUSTOM_LOOK_AND_FEELS, ";");
    }

    private void initializeAvailableLookAndFeels() {
        this.lookAndFeels = UIManager.getInstalledLookAndFeels();
        Arrays.sort(this.lookAndFeels, new Comparator<UIManager.LookAndFeelInfo>(){

            @Override
            public int compare(UIManager.LookAndFeelInfo a, UIManager.LookAndFeelInfo b) {
                return a.getName().compareTo(b.getName());
            }

            @Override
            public boolean equals(Object a) {
                return false;
            }
        });
    }

    private boolean isCustomLookAndFeel(String className) {
        return this.customLookAndFeels != null && this.customLookAndFeels.contains(className);
    }

    private boolean isLookAndFeelModifiable(UIManager.LookAndFeelInfo laf) {
        if (this.isCustomLookAndFeel(laf.getClassName())) {
            return !laf.getClassName().equals(UIManager.getLookAndFeel().getClass().getName());
        }
        return false;
    }

    private void resetLookAndFeelButtons() {
        int selectedIndex;
        if (!(this.dial != null && this.dial.isAnimated() || (selectedIndex = this.lookAndFeelComboBox.getSelectedIndex()) == -1)) {
            this.deleteLookAndFeelButton.setEnabled(this.isLookAndFeelModifiable(this.lookAndFeels[selectedIndex]));
        }
    }

    private void uninstallLookAndFeel(UIManager.LookAndFeelInfo selection) {
        UIManager.LookAndFeelInfo[] buffer = new UIManager.LookAndFeelInfo[this.lookAndFeels.length - 1];
        int bufferIndex = 0;
        for (UIManager.LookAndFeelInfo lookAndFeel : this.lookAndFeels) {
            if (selection.getClassName().equals(lookAndFeel.getClassName())) continue;
            buffer[bufferIndex] = lookAndFeel;
            ++bufferIndex;
        }
        this.lookAndFeels = buffer;
        UIManager.setInstalledLookAndFeels(buffer);
    }

    private void deleteCustomLookAndFeel(UIManager.LookAndFeelInfo selection) {
        if (this.customLookAndFeels != null && this.customLookAndFeels.remove(selection.getClassName())) {
            MuConfigurations.getPreferences().setVariable(MuPreference.CUSTOM_LOOK_AND_FEELS, this.customLookAndFeels, ";");
        }
    }

    private void deleteSelectedLookAndFeel() {
        UIManager.LookAndFeelInfo selection = this.lookAndFeels[this.lookAndFeelComboBox.getSelectedIndex()];
        if (new QuestionDialog(this.parent, null, Translator.get("prefs_dialog.delete_look_and_feel", selection.getName()), (Component)this.parent, new String[]{Translator.get("yes", new String[0]), Translator.get("no", new String[0])}, new int[]{0, 1}, 0).getActionValue() != 0) {
            return;
        }
        this.lookAndFeelComboBox.removeItem(selection.getName());
        this.uninstallLookAndFeel(selection);
        this.deleteCustomLookAndFeel(selection);
    }

    private void setLookAndFeelsLoading(boolean loading) {
        this.dial.setAnimated(loading);
        this.importLookAndFeelButton.setEnabled(!loading);
        this.deleteLookAndFeelButton.setEnabled(!loading);
        this.lookAndFeelComboBox.setEnabled(!loading);
        if (loading) {
            this.deleteLookAndFeelButton.setEnabled(false);
        } else {
            this.resetLookAndFeelButtons();
        }
    }

    private boolean importLookAndFeelLibrary(AbstractFile library) throws IOException {
        int action;
        AbstractFile destFile = ExtensionManager.getExtensionsFile(library.getName());
        int collision = FileCollisionChecker.checkForCollision(library, destFile);
        if (collision != 0 && (action = new FileCollisionDialog((Dialog)this.parent, (Component)this.parent, collision, library, destFile, false, false).getActionValue()) != 2) {
            if (action == 3) {
                if (library.getDate() <= destFile.getDate()) {
                    return false;
                }
            } else {
                return false;
            }
        }
        return ExtensionManager.importLibrary(library, true);
    }

    public void run() {
        this.setLookAndFeelsLoading(true);
        try {
            List<Class<?>> newLookAndFeels = new ClassFinder().find(this.lookAndFeelLibrary, new LookAndFeelFilter());
            if (newLookAndFeels.isEmpty()) {
                InformationDialog.showWarningDialog(this, Translator.get("prefs_dialog.no_look_and_feel", new String[0]));
            } else if (this.importLookAndFeelLibrary(this.lookAndFeelLibrary)) {
                if (this.customLookAndFeels == null) {
                    this.customLookAndFeels = new Vector<String>();
                }
                for (int i = 0; i < newLookAndFeels.size(); ++i) {
                    String currentName = newLookAndFeels.get(i).getName();
                    if (this.customLookAndFeels.contains(currentName)) continue;
                    this.customLookAndFeels.add(currentName);
                    try {
                        WindowManager.installLookAndFeel(currentName);
                        continue;
                    }
                    catch (Throwable e) {
                        // empty catch block
                    }
                }
                if (this.customLookAndFeels.isEmpty()) {
                    this.customLookAndFeels = null;
                } else {
                    MuConfigurations.getPreferences().setVariable(MuPreference.CUSTOM_LOOK_AND_FEELS, this.customLookAndFeels, ";");
                }
                this.populateLookAndFeels();
            }
        }
        catch (Exception e) {
            LOGGER.debug("Exception caught", e);
            InformationDialog.showErrorDialog(this);
        }
        this.setLookAndFeelsLoading(false);
    }

    private void importLookAndFeel() {
        JFileChooser chooser = this.createFileChooser();
        chooser.setFileSelectionMode(0);
        chooser.addChoosableFileFilter(new ExtensionFileFilter("jar", Translator.get("prefs_dialog.jar_file", new String[0])));
        chooser.setDialogTitle(Translator.get("prefs_dialog.import_look_and_feel", new String[0]));
        chooser.setDialogType(0);
        if (chooser.showDialog(this.parent, Translator.get("prefs_dialog.import", new String[0])) == 0) {
            AbstractFile file = FileFactory.getFile(chooser.getSelectedFile().getAbsolutePath());
            this.lastSelectedFolder = file.getParent();
            if (!file.exists()) {
                InformationDialog.showErrorDialog(this, Translator.get("this_file_does_not_exist", file.getName()));
                return;
            }
            this.lookAndFeelLibrary = file;
            new Thread(this).start();
        }
    }

    private void setTypeLabel(Theme theme) {
        String label = theme.getType() == 0 ? Translator.get("theme.custom", new String[0]) : (theme.getType() == 1 ? Translator.get("theme.built_in", new String[0]) : Translator.get("theme.add_on", new String[0]));
        this.typeLabel.setText(Translator.get("prefs_dialog.theme_type", label));
    }

    private void resetThemeButtons(Theme theme) {
        if (this.ignoreComboChanges) {
            return;
        }
        this.setTypeLabel(theme);
        if (theme.getType() != 2) {
            this.renameThemeButton.setEnabled(false);
            this.deleteThemeButton.setEnabled(false);
        } else {
            this.renameThemeButton.setEnabled(true);
            if (ThemeManager.isCurrentTheme(theme)) {
                this.deleteThemeButton.setEnabled(false);
            } else {
                this.deleteThemeButton.setEnabled(true);
            }
        }
    }

    private void renameTheme(Theme theme) {
        ThemeNameDialog themeNameDialog = new ThemeNameDialog((Dialog)this.parent, theme.getName());
        if (themeNameDialog.wasValidated()) {
            try {
                ThemeManager.renameCustomTheme(theme, themeNameDialog.getText());
                this.themeComboBox.removeItem(theme);
                this.insertTheme(theme);
            }
            catch (Exception exception) {
                InformationDialog.showErrorDialog(this, Translator.get("prefs_dialog.rename_failed", theme.getName()));
            }
        }
    }

    private void deleteTheme(Theme theme) {
        if (new QuestionDialog(this.parent, null, Translator.get("prefs_dialog.delete_theme", theme.getName()), (Component)this.parent, new String[]{Translator.get("yes", new String[0]), Translator.get("no", new String[0])}, new int[]{0, 1}, 0).getActionValue() != 0) {
            return;
        }
        try {
            ThemeManager.deleteCustomTheme(theme.getName());
            this.themeComboBox.removeItem(theme);
        }
        catch (Exception exception) {
            InformationDialog.showErrorDialog(this);
        }
    }

    private void editTheme(Theme theme) {
        if (new ThemeEditorDialog((Dialog)this.parent, theme).editTheme()) {
            this.populateThemes(ThemeManager.getCurrentTheme());
        }
    }

    private JFileChooser createFileChooser() {
        if (this.lastSelectedFolder == null) {
            return new JFileChooser();
        }
        return new JFileChooser((File)this.lastSelectedFolder.getUnderlyingFileObject());
    }

    private void insertTheme(Theme theme) {
        int i;
        int count = this.themeComboBox.getItemCount();
        for (i = 0; i < count; ++i) {
            if (((Theme)this.themeComboBox.getItemAt(i)).getName().compareTo(theme.getName()) < 0) continue;
            this.themeComboBox.insertItemAt(theme, i);
            break;
        }
        if (i == count) {
            this.themeComboBox.addItem(theme);
        }
        this.themeComboBox.setSelectedItem(theme);
    }

    private void importTheme() {
        JFileChooser jFileChooser = this.createFileChooser();
        jFileChooser.setFileSelectionMode(0);
        jFileChooser.addChoosableFileFilter(new ExtensionFileFilter("xml", Translator.get("prefs_dialog.xml_file", new String[0])));
        jFileChooser.setDialogTitle(Translator.get("prefs_dialog.import_theme", new String[0]));
        jFileChooser.setDialogType(0);
        if (jFileChooser.showDialog(this.parent, Translator.get("prefs_dialog.import", new String[0])) == 0) {
            AbstractFile abstractFile = FileFactory.getFile(jFileChooser.getSelectedFile().getAbsolutePath());
            this.lastSelectedFolder = abstractFile.getParent();
            if (!abstractFile.exists()) {
                InformationDialog.showErrorDialog(this, Translator.get("this_file_does_not_exist", abstractFile.getName()));
                return;
            }
            try {
                this.insertTheme(ThemeManager.importTheme((File)abstractFile.getUnderlyingFileObject()));
            }
            catch (Exception exception) {
                InformationDialog.showErrorDialog(this, Translator.get("prefs_dialog.error_in_import", abstractFile.getName()));
            }
        }
    }

    private void exportTheme(Theme theme) {
        JFileChooser jFileChooser = this.createFileChooser();
        jFileChooser.setFileSelectionMode(0);
        jFileChooser.addChoosableFileFilter(new ExtensionFileFilter("xml", Translator.get("prefs_dialog.xml_file", new String[0])));
        jFileChooser.setDialogTitle(Translator.get("prefs_dialog.export_theme", theme.getName()));
        if (jFileChooser.showDialog(this.parent, Translator.get("prefs_dialog.export", new String[0])) == 0) {
            AbstractFile abstractFile = FileFactory.getFile(jFileChooser.getSelectedFile().getAbsolutePath());
            this.lastSelectedFolder = abstractFile.getParent();
            try {
                int n;
                int n2;
                if (!"xml".equalsIgnoreCase(abstractFile.getExtension())) {
                    abstractFile = this.lastSelectedFolder.getDirectChild(abstractFile.getName() + ".xml");
                }
                if ((n2 = FileCollisionChecker.checkForCollision(null, abstractFile)) != 0 && (n = new FileCollisionDialog((Dialog)this.parent, (Component)this.parent, n2, null, abstractFile, false, false).getActionValue()) != 2) {
                    return;
                }
                ThemeManager.exportTheme(theme, (File)abstractFile.getUnderlyingFileObject());
                if (this.lastSelectedFolder.equals(ThemeManager.getCustomThemesFolder())) {
                    this.populateThemes(theme);
                }
            }
            catch (Exception exception) {
                InformationDialog.showErrorDialog(this, Translator.get("write_error", new String[0]), Translator.get("cannot_write_file", abstractFile.getName()));
            }
        }
    }

    private void duplicateTheme(Theme theme) {
        try {
            this.insertTheme(ThemeManager.duplicateTheme(theme));
        }
        catch (Exception e) {
            InformationDialog.showErrorDialog(this);
        }
    }

    public void actionPerformed(ActionEvent e) {
        Theme theme = (Theme)this.themeComboBox.getSelectedItem();
        if (e.getSource() == this.themeComboBox) {
            this.resetThemeButtons(theme);
        } else if (e.getSource() == this.lookAndFeelComboBox) {
            this.resetLookAndFeelButtons();
        } else if (e.getSource() == this.deleteLookAndFeelButton) {
            this.deleteSelectedLookAndFeel();
        } else if (e.getSource() == this.importLookAndFeelButton) {
            this.importLookAndFeel();
        } else if (e.getSource() == this.renameThemeButton) {
            this.renameTheme(theme);
        } else if (e.getSource() == this.deleteThemeButton) {
            this.deleteTheme(theme);
        } else if (e.getSource() == this.editThemeButton) {
            this.editTheme(theme);
        } else if (e.getSource() == this.importThemeButton) {
            this.importTheme();
        } else if (e.getSource() == this.exportThemeButton) {
            this.exportTheme(theme);
        } else if (e.getSource() == this.duplicateThemeButton) {
            this.duplicateTheme(theme);
        }
    }

    private static class ExtensionFileFilter
    extends FileFilter {
        private String extension;
        private String description;

        public ExtensionFileFilter(String extension, String description) {
            this.extension = extension;
            this.description = description;
        }

        public boolean accept(File file) {
            if (file.isDirectory()) {
                return true;
            }
            String ext = AbstractFile.getExtension(file.getName());
            if (ext != null) {
                return this.extension.equalsIgnoreCase(ext);
            }
            return false;
        }

        public String getDescription() {
            return this.description;
        }
    }
}

