/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.ui.dialog.pref.general;

import com.mucommander.commons.runtime.OsFamilies;
import com.mucommander.conf.MuConfigurations;
import com.mucommander.conf.MuPreference;
import com.mucommander.text.Translator;
import com.mucommander.ui.dialog.pref.PreferencesDialog;
import com.mucommander.ui.dialog.pref.PreferencesPanel;
import com.mucommander.ui.dialog.pref.component.PrefCheckBox;
import com.mucommander.ui.dialog.pref.component.PrefFilePathField;
import com.mucommander.ui.dialog.pref.component.PrefRadioButton;
import com.mucommander.ui.dialog.pref.component.PrefTextField;
import com.mucommander.ui.layout.XBoxPanel;
import com.mucommander.ui.layout.YBoxPanel;
import com.mucommander.ui.main.WindowManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;

class FoldersPanel
extends PreferencesPanel
implements ActionListener,
ItemListener,
KeyListener {
    private PrefRadioButton leftLastFolderRadioButton;
    private PrefRadioButton leftCustomFolderRadioButton;
    private PrefTextField leftCustomFolderTextField;
    private JButton leftCustomFolderButton;
    private PrefRadioButton rightLastFolderRadioButton;
    private PrefRadioButton rightCustomFolderRadioButton;
    private PrefTextField rightCustomFolderTextField;
    private JButton rightCustomFolderButton;
    private PrefCheckBox showHiddenFilesCheckBox;
    private PrefCheckBox showDSStoreFilesCheckBox;
    private PrefCheckBox showSystemFoldersCheckBox;
    private PrefCheckBox compactSizeCheckBox;
    private PrefCheckBox followSymlinksCheckBox;

    public FoldersPanel(PreferencesDialog parent) {
        super(parent, Translator.get("prefs_dialog.folders_tab", new String[0]));
        this.setLayout(new BorderLayout());
        YBoxPanel startupFolderPanel = new YBoxPanel();
        startupFolderPanel.setBorder(BorderFactory.createTitledBorder(Translator.get("prefs_dialog.startup_folders", new String[0])));
        JLabel leftFolderLabel = new JLabel(Translator.get("prefs_dialog.left_folder", new String[0]));
        leftFolderLabel.setAlignmentX(0.0f);
        startupFolderPanel.add(leftFolderLabel);
        startupFolderPanel.addSpace(5);
        XBoxPanel tempPanel = new XBoxPanel(5);
        tempPanel.setAlignmentX(0.0f);
        this.leftLastFolderRadioButton = new PrefRadioButton(Translator.get("prefs_dialog.last_folder", new String[0])){

            public boolean hasChanged() {
                return !(this.isSelected() ? "lastFolder" : "customFolder").equals(MuConfigurations.getPreferences().getVariable(MuPreference.LEFT_STARTUP_FOLDER));
            }
        };
        tempPanel.add(this.leftLastFolderRadioButton);
        startupFolderPanel.add(tempPanel);
        this.leftCustomFolderRadioButton = new PrefRadioButton(Translator.get("prefs_dialog.custom_folder", new String[0])){

            public boolean hasChanged() {
                return !(this.isSelected() ? "customFolder" : "lastFolder").equals(MuConfigurations.getPreferences().getVariable(MuPreference.LEFT_STARTUP_FOLDER));
            }
        };
        tempPanel = new XBoxPanel(5);
        tempPanel.setAlignmentX(0.0f);
        tempPanel.add(this.leftCustomFolderRadioButton);
        tempPanel.addSpace(5);
        this.leftCustomFolderTextField = new PrefFilePathField(MuConfigurations.getPreferences().getVariable(MuPreference.LEFT_CUSTOM_FOLDER, "")){

            public boolean hasChanged() {
                return !this.getText().equals(MuConfigurations.getPreferences().getVariable(MuPreference.LEFT_CUSTOM_FOLDER));
            }
        };
        this.leftCustomFolderTextField.addKeyListener(this);
        tempPanel.add(this.leftCustomFolderTextField);
        this.leftCustomFolderButton = new JButton("...");
        this.leftCustomFolderButton.addActionListener(this);
        tempPanel.add(this.leftCustomFolderButton);
        startupFolderPanel.add(tempPanel);
        if (MuConfigurations.getPreferences().getVariable(MuPreference.LEFT_STARTUP_FOLDER, "").equals("lastFolder")) {
            this.leftLastFolderRadioButton.setSelected(true);
            this.setCustomFolderComponentsEnabled(true, false);
        } else {
            this.leftCustomFolderRadioButton.setSelected(true);
        }
        this.leftCustomFolderRadioButton.addItemListener(this);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.leftLastFolderRadioButton);
        buttonGroup.add(this.leftCustomFolderRadioButton);
        startupFolderPanel.addSpace(15);
        JLabel rightFolderLabel = new JLabel(Translator.get("prefs_dialog.right_folder", new String[0]));
        rightFolderLabel.setAlignmentX(0.0f);
        startupFolderPanel.add(rightFolderLabel);
        startupFolderPanel.addSpace(5);
        tempPanel = new XBoxPanel(5);
        tempPanel.setAlignmentX(0.0f);
        this.rightLastFolderRadioButton = new PrefRadioButton(Translator.get("prefs_dialog.last_folder", new String[0])){

            public boolean hasChanged() {
                return !(this.isSelected() ? "lastFolder" : "customFolder").equals(MuConfigurations.getPreferences().getVariable(MuPreference.RIGHT_STARTUP_FOLDER));
            }
        };
        tempPanel.add(this.rightLastFolderRadioButton);
        startupFolderPanel.add(tempPanel);
        this.rightCustomFolderRadioButton = new PrefRadioButton(Translator.get("prefs_dialog.custom_folder", new String[0])){

            public boolean hasChanged() {
                return !(this.isSelected() ? "customFolder" : "lastFolder").equals(MuConfigurations.getPreferences().getVariable(MuPreference.RIGHT_STARTUP_FOLDER));
            }
        };
        tempPanel = new XBoxPanel(5);
        tempPanel.setAlignmentX(0.0f);
        tempPanel.add(this.rightCustomFolderRadioButton);
        tempPanel.addSpace(5);
        this.rightCustomFolderTextField = new PrefFilePathField(MuConfigurations.getPreferences().getVariable(MuPreference.RIGHT_CUSTOM_FOLDER, "")){

            public boolean hasChanged() {
                return !this.getText().equals(MuConfigurations.getPreferences().getVariable(MuPreference.RIGHT_CUSTOM_FOLDER));
            }
        };
        this.rightCustomFolderTextField.addKeyListener(this);
        tempPanel.add(this.rightCustomFolderTextField);
        this.rightCustomFolderButton = new JButton("...");
        this.rightCustomFolderButton.addActionListener(this);
        tempPanel.add(this.rightCustomFolderButton);
        startupFolderPanel.add(tempPanel);
        if (MuConfigurations.getPreferences().getVariable(MuPreference.RIGHT_STARTUP_FOLDER, "").equals("lastFolder")) {
            this.rightLastFolderRadioButton.setSelected(true);
            this.setCustomFolderComponentsEnabled(false, false);
        } else {
            this.rightCustomFolderRadioButton.setSelected(true);
        }
        this.rightCustomFolderRadioButton.addItemListener(this);
        buttonGroup = new ButtonGroup();
        buttonGroup.add(this.rightLastFolderRadioButton);
        buttonGroup.add(this.rightCustomFolderRadioButton);
        YBoxPanel northPanel = new YBoxPanel();
        northPanel.add(startupFolderPanel);
        northPanel.addSpace(5);
        this.showHiddenFilesCheckBox = new PrefCheckBox(Translator.get("prefs_dialog.show_hidden_files", new String[0])){

            public boolean hasChanged() {
                return this.isSelected() != MuConfigurations.getPreferences().getVariable(MuPreference.SHOW_HIDDEN_FILES, true);
            }
        };
        this.showHiddenFilesCheckBox.setSelected(MuConfigurations.getPreferences().getVariable(MuPreference.SHOW_HIDDEN_FILES, true));
        northPanel.add(this.showHiddenFilesCheckBox);
        if (OsFamilies.MAC_OS_X.isCurrent()) {
            this.showHiddenFilesCheckBox.addItemListener(this);
            this.showDSStoreFilesCheckBox = new PrefCheckBox(Translator.get("prefs_dialog.show_ds_store_files", new String[0])){

                public boolean hasChanged() {
                    return this.isSelected() != MuConfigurations.getPreferences().getVariable(MuPreference.SHOW_DS_STORE_FILES, true);
                }
            };
            this.showDSStoreFilesCheckBox.setSelected(MuConfigurations.getPreferences().getVariable(MuPreference.SHOW_DS_STORE_FILES, true));
            this.showDSStoreFilesCheckBox.setEnabled(this.showHiddenFilesCheckBox.isSelected());
            northPanel.add((Component)this.showDSStoreFilesCheckBox, 20);
            this.showSystemFoldersCheckBox = new PrefCheckBox(Translator.get("prefs_dialog.show_system_folders", new String[0])){

                public boolean hasChanged() {
                    return this.isSelected() != MuConfigurations.getPreferences().getVariable(MuPreference.SHOW_SYSTEM_FOLDERS, true);
                }
            };
            this.showSystemFoldersCheckBox.setSelected(MuConfigurations.getPreferences().getVariable(MuPreference.SHOW_SYSTEM_FOLDERS, true));
            northPanel.add(this.showSystemFoldersCheckBox);
        }
        this.compactSizeCheckBox = new PrefCheckBox(Translator.get("prefs_dialog.compact_file_size", new String[0])){

            public boolean hasChanged() {
                return this.isSelected() != MuConfigurations.getPreferences().getVariable(MuPreference.DISPLAY_COMPACT_FILE_SIZE, true);
            }
        };
        this.compactSizeCheckBox.setSelected(MuConfigurations.getPreferences().getVariable(MuPreference.DISPLAY_COMPACT_FILE_SIZE, true));
        northPanel.add(this.compactSizeCheckBox);
        this.followSymlinksCheckBox = new PrefCheckBox(Translator.get("prefs_dialog.follow_symlinks_when_cd", new String[0])){

            public boolean hasChanged() {
                return this.isSelected() != MuConfigurations.getPreferences().getVariable(MuPreference.CD_FOLLOWS_SYMLINKS, false);
            }
        };
        this.followSymlinksCheckBox.setSelected(MuConfigurations.getPreferences().getVariable(MuPreference.CD_FOLLOWS_SYMLINKS, false));
        northPanel.add(this.followSymlinksCheckBox);
        this.add((Component)northPanel, "North");
        this.leftLastFolderRadioButton.addDialogListener(parent);
        this.leftCustomFolderRadioButton.addDialogListener(parent);
        this.rightLastFolderRadioButton.addDialogListener(parent);
        this.rightCustomFolderRadioButton.addDialogListener(parent);
        this.rightCustomFolderTextField.addDialogListener(parent);
        this.leftCustomFolderTextField.addDialogListener(parent);
        this.showHiddenFilesCheckBox.addDialogListener(parent);
        this.compactSizeCheckBox.addDialogListener(parent);
        this.followSymlinksCheckBox.addDialogListener(parent);
        if (OsFamilies.MAC_OS_X.isCurrent()) {
            this.showDSStoreFilesCheckBox.addDialogListener(parent);
            this.showSystemFoldersCheckBox.addDialogListener(parent);
        }
    }

    private void setCustomFolderComponentsEnabled(boolean isLeft, boolean enabled) {
        (isLeft ? this.leftCustomFolderTextField : this.rightCustomFolderTextField).setEnabled(enabled);
        (isLeft ? this.leftCustomFolderButton : this.rightCustomFolderButton).setEnabled(enabled);
    }

    protected void commit() {
        MuConfigurations.getPreferences().setVariable(MuPreference.LEFT_STARTUP_FOLDER, this.leftLastFolderRadioButton.isSelected() ? "lastFolder" : "customFolder");
        MuConfigurations.getPreferences().setVariable(MuPreference.LEFT_CUSTOM_FOLDER, this.leftCustomFolderTextField.getText());
        MuConfigurations.getPreferences().setVariable(MuPreference.RIGHT_STARTUP_FOLDER, this.rightLastFolderRadioButton.isSelected() ? "lastFolder" : "customFolder");
        MuConfigurations.getPreferences().setVariable(MuPreference.RIGHT_CUSTOM_FOLDER, this.rightCustomFolderTextField.getText());
        MuConfigurations.getPreferences().setVariable(MuPreference.DISPLAY_COMPACT_FILE_SIZE, this.compactSizeCheckBox.isSelected());
        MuConfigurations.getPreferences().setVariable(MuPreference.CD_FOLLOWS_SYMLINKS, this.followSymlinksCheckBox.isSelected());
        boolean refreshFolders = MuConfigurations.getPreferences().setVariable(MuPreference.SHOW_HIDDEN_FILES, this.showHiddenFilesCheckBox.isSelected());
        if (OsFamilies.MAC_OS_X.isCurrent()) {
            refreshFolders |= MuConfigurations.getPreferences().setVariable(MuPreference.SHOW_DS_STORE_FILES, this.showDSStoreFilesCheckBox.isSelected());
            refreshFolders |= MuConfigurations.getPreferences().setVariable(MuPreference.SHOW_SYSTEM_FOLDERS, this.showSystemFoldersCheckBox.isSelected());
        }
        if (refreshFolders) {
            WindowManager.tryRefreshCurrentFolders();
        }
    }

    public void itemStateChanged(ItemEvent event) {
        Object source = event.getSource();
        if (source == this.showHiddenFilesCheckBox) {
            this.showDSStoreFilesCheckBox.setEnabled(this.showHiddenFilesCheckBox.isSelected());
        } else if (source == this.leftCustomFolderRadioButton) {
            this.setCustomFolderComponentsEnabled(true, this.leftCustomFolderRadioButton.isSelected());
        } else if (source == this.rightCustomFolderRadioButton) {
            this.setCustomFolderComponentsEnabled(false, this.rightCustomFolderRadioButton.isSelected());
        }
    }

    public void keyTyped(KeyEvent e) {
        Object source = e.getSource();
        if (source == this.leftCustomFolderTextField) {
            if (!this.leftCustomFolderRadioButton.isSelected()) {
                this.leftCustomFolderRadioButton.setSelected(true);
            }
        } else if (source == this.rightCustomFolderTextField && !this.rightCustomFolderRadioButton.isSelected()) {
            this.rightCustomFolderRadioButton.setSelected(true);
        }
    }

    public void keyPressed(KeyEvent e) {
    }

    public void keyReleased(KeyEvent e) {
    }

    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        JFileChooser chooser = new JFileChooser();
        chooser.setFileSelectionMode(1);
        chooser.setDialogTitle(Translator.get("choose_folder", new String[0]));
        chooser.setDialogType(0);
        if (chooser.showDialog(this.parent, Translator.get("choose", new String[0])) == 0) {
            File file = chooser.getSelectedFile();
            if (source == this.leftCustomFolderButton) {
                this.leftCustomFolderTextField.setText(file.getPath());
                if (!this.leftCustomFolderRadioButton.isSelected()) {
                    this.leftCustomFolderRadioButton.setSelected(true);
                }
            } else if (source == this.rightCustomFolderButton) {
                this.rightCustomFolderTextField.setText(file.getPath());
                if (!this.rightCustomFolderRadioButton.isSelected()) {
                    this.rightCustomFolderRadioButton.setSelected(true);
                }
            }
        }
    }
}

