/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.ui.dialog.pref.general;

import com.mucommander.conf.MuConfigurations;
import com.mucommander.conf.MuPreference;
import com.mucommander.text.CustomDateFormat;
import com.mucommander.text.Translator;
import com.mucommander.ui.dialog.pref.PreferencesDialog;
import com.mucommander.ui.dialog.pref.PreferencesPanel;
import com.mucommander.ui.dialog.pref.component.PrefCheckBox;
import com.mucommander.ui.dialog.pref.component.PrefComboBox;
import com.mucommander.ui.dialog.pref.component.PrefRadioButton;
import com.mucommander.ui.dialog.pref.component.PrefTextField;
import com.mucommander.ui.icon.IconManager;
import com.mucommander.ui.layout.YBoxPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.plaf.basic.BasicComboBoxRenderer;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

class GeneralPanel
extends PreferencesPanel
implements ActionListener,
ItemListener,
DocumentListener {
    private String[] languages;
    private PrefComboBox languageComboBox;
    private PrefRadioButton time12RadioButton;
    private PrefComboBox dateFormatComboBox;
    private PrefTextField dateSeparatorField;
    private PrefCheckBox showSecondsCheckBox;
    private PrefCheckBox showCenturyCheckBox;
    private JLabel previewLabel;
    private Date exampleDate;
    private static final String DAY = Translator.get("prefs_dialog.day", new String[0]);
    private static final String MONTH = Translator.get("prefs_dialog.month", new String[0]);
    private static final String YEAR = Translator.get("prefs_dialog.year", new String[0]);
    private static final String[] DATE_FORMAT_LABELS = new String[]{MONTH + "/" + DAY + "/" + YEAR, DAY + "/" + MONTH + "/" + YEAR, YEAR + "/" + MONTH + "/" + DAY, MONTH + "/" + YEAR + "/" + DAY, DAY + "/" + YEAR + "/" + MONTH, YEAR + "/" + DAY + "/" + MONTH};
    private static final String[] DATE_FORMATS = new String[]{"MM/dd/yy", "dd/MM/yy", "yy/MM/dd", "MM/yy/dd", "dd/yy/MM", "yy/dd/MM"};
    private static final String[] DATE_FORMATS_WITH_CENTURY = new String[]{"MM/dd/yyyy", "dd/MM/yyyy", "yyyy/MM/dd", "MM/yyyy/dd", "dd/yyyy/MM", "yyyy/dd/MM"};

    public GeneralPanel(PreferencesDialog parent) {
        super(parent, Translator.get("prefs_dialog.general_tab", new String[0]));
        this.setLayout(new BorderLayout());
        YBoxPanel mainPanel = new YBoxPanel();
        JPanel languagePanel = new JPanel(new FlowLayout(0));
        languagePanel.setBorder(BorderFactory.createTitledBorder(Translator.get("prefs_dialog.language", new String[0])));
        this.languages = Translator.getAvailableLanguages();
        String currentLang = MuConfigurations.getPreferences().getVariable(MuPreference.LANGUAGE);
        this.languageComboBox = new PrefComboBox(){

            public boolean hasChanged() {
                return !GeneralPanel.this.languages[this.getSelectedIndex()].equals(MuConfigurations.getPreferences().getVariable(MuPreference.LANGUAGE));
            }
        };
        class LanguageComboBoxRenderer
        extends BasicComboBoxRenderer {
            LanguageComboBoxRenderer() {
            }

            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                JLabel label = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                String language = (String)value;
                label.setText(Translator.get("language." + language, new String[0]));
                label.setIcon(IconManager.getIcon(6, language + ".png"));
                return label;
            }
        }
        this.languageComboBox.setRenderer(new LanguageComboBoxRenderer());
        int languageIndex = -1;
        for (int i = 0; i < this.languages.length; ++i) {
            String lang = this.languages[i];
            this.languageComboBox.addItem(lang);
            if (lang.equalsIgnoreCase(currentLang)) {
                languageIndex = i;
                continue;
            }
            if (languageIndex != -1 || !lang.equalsIgnoreCase("en")) continue;
            languageIndex = i;
        }
        this.languageComboBox.setSelectedIndex(languageIndex);
        languagePanel.add(this.languageComboBox);
        mainPanel.add(languagePanel);
        mainPanel.addSpace(10);
        YBoxPanel dateTimeFormatPanel = new YBoxPanel();
        dateTimeFormatPanel.setBorder(BorderFactory.createTitledBorder(Translator.get("prefs_dialog.date_time", new String[0])));
        JPanel gridPanel = new JPanel(new GridLayout(1, 2));
        YBoxPanel dateFormatPanel = new YBoxPanel();
        dateFormatPanel.setBorder(BorderFactory.createTitledBorder(Translator.get("prefs_dialog.date", new String[0])));
        this.dateFormatComboBox = new PrefComboBox(){

            public boolean hasChanged() {
                return !GeneralPanel.this.getDateFormatString().equals(MuConfigurations.getPreferences().getVariable(MuPreference.DATE_FORMAT));
            }
        };
        String dateFormat = MuConfigurations.getPreferences().getVariable(MuPreference.DATE_FORMAT);
        String separator = MuConfigurations.getPreferences().getVariable(MuPreference.DATE_SEPARATOR, "/");
        int dateFormatIndex = 0;
        String buffer = dateFormat.replace(separator.charAt(0), '/');
        for (int i = 0; i < DATE_FORMATS.length; ++i) {
            this.dateFormatComboBox.addItem(DATE_FORMAT_LABELS[i]);
            if (!buffer.equals(DATE_FORMATS[i]) && !buffer.equals(DATE_FORMATS_WITH_CENTURY[i])) continue;
            dateFormatIndex = i;
        }
        this.dateFormatComboBox.setSelectedIndex(dateFormatIndex);
        this.dateFormatComboBox.addItemListener(this);
        JPanel tempPanel = new JPanel(new FlowLayout(0));
        tempPanel.add(this.dateFormatComboBox);
        tempPanel.add(Box.createHorizontalGlue());
        dateFormatPanel.add(tempPanel);
        tempPanel = new JPanel(new FlowLayout(0));
        tempPanel.add(new JLabel(Translator.get("prefs_dialog.date_separator", new String[0]) + ": "));
        this.dateSeparatorField = new PrefTextField(1){

            public boolean hasChanged() {
                return !this.getText().equals(MuConfigurations.getPreferences().getVariable(MuPreference.DATE_SEPARATOR));
            }
        };
        PlainDocument doc = new PlainDocument(){

            public void insertString(int param, String str, AttributeSet attributeSet) throws BadLocationException {
                if (str != null && this.getLength() + str.length() > 1) {
                    return;
                }
                if (str != null) {
                    int len = str.length();
                    for (int i = 0; i < len; ++i) {
                        if (!Character.isLetterOrDigit(str.charAt(i))) continue;
                        return;
                    }
                }
                super.insertString(param, str, attributeSet);
            }
        };
        this.dateSeparatorField.setDocument(doc);
        this.dateSeparatorField.setText(separator);
        doc.addDocumentListener(this);
        tempPanel.add(this.dateSeparatorField);
        tempPanel.add(Box.createHorizontalGlue());
        dateFormatPanel.add(tempPanel);
        this.showCenturyCheckBox = new PrefCheckBox(Translator.get("prefs_dialog.show_century", new String[0])){

            public boolean hasChanged() {
                return this.isSelected() != (MuConfigurations.getPreferences().getVariable(MuPreference.DATE_FORMAT).indexOf("yyyy") != -1);
            }
        };
        this.showCenturyCheckBox.setSelected(dateFormat.indexOf("yyyy") != -1);
        this.showCenturyCheckBox.addItemListener(this);
        dateFormatPanel.add(this.showCenturyCheckBox);
        dateFormatPanel.addSpace(10);
        gridPanel.add(dateFormatPanel);
        YBoxPanel timeFormatPanel = new YBoxPanel();
        timeFormatPanel.setBorder(BorderFactory.createTitledBorder(Translator.get("prefs_dialog.time", new String[0])));
        this.time12RadioButton = new PrefRadioButton(Translator.get("prefs_dialog.time_12_hour", new String[0])){

            public boolean hasChanged() {
                String timeFormat = MuConfigurations.getPreferences().getVariable(MuPreference.TIME_FORMAT);
                return this.isSelected() != (timeFormat.equals("hh:mm a") || timeFormat.equals("hh:mm:ss a"));
            }
        };
        this.time12RadioButton.addActionListener(this);
        PrefRadioButton time24RadioButton = new PrefRadioButton(Translator.get("prefs_dialog.time_24_hour", new String[0])){

            public boolean hasChanged() {
                String timeFormat = MuConfigurations.getPreferences().getVariable(MuPreference.TIME_FORMAT);
                return this.isSelected() != (timeFormat.equals("HH:mm") || timeFormat.equals("HH:mm:ss"));
            }
        };
        time24RadioButton.addActionListener(this);
        String timeFormat = MuConfigurations.getPreferences().getVariable(MuPreference.TIME_FORMAT);
        if (timeFormat.equals("hh:mm a") || timeFormat.equals("hh:mm:ss a")) {
            this.time12RadioButton.setSelected(true);
        } else {
            time24RadioButton.setSelected(true);
        }
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.time12RadioButton);
        buttonGroup.add(time24RadioButton);
        timeFormatPanel.add(this.time12RadioButton);
        timeFormatPanel.add(time24RadioButton);
        timeFormatPanel.addSpace(10);
        this.showSecondsCheckBox = new PrefCheckBox(Translator.get("prefs_dialog.show_seconds", new String[0])){

            public boolean hasChanged() {
                return this.isSelected() != (MuConfigurations.getPreferences().getVariable(MuPreference.TIME_FORMAT).indexOf(":ss") != -1);
            }
        };
        this.showSecondsCheckBox.setSelected(timeFormat.indexOf(":ss") != -1);
        this.showSecondsCheckBox.addItemListener(this);
        timeFormatPanel.add(this.showSecondsCheckBox);
        timeFormatPanel.addSpace(10);
        gridPanel.add(timeFormatPanel);
        dateTimeFormatPanel.add(gridPanel);
        tempPanel = new JPanel(new FlowLayout(0));
        tempPanel.add(new JLabel(Translator.get("example", new String[0]) + ": "));
        this.previewLabel = new JLabel();
        Calendar calendar = Calendar.getInstance();
        calendar.set(calendar.get(1) - 1, 11, 31, 23, 59);
        this.exampleDate = calendar.getTime();
        this.updatePreviewLabel();
        tempPanel.add(this.previewLabel);
        dateTimeFormatPanel.add(tempPanel);
        mainPanel.add(dateTimeFormatPanel);
        this.add((Component)mainPanel, "North");
        this.languageComboBox.addDialogListener(parent);
        this.time12RadioButton.addDialogListener(parent);
        time24RadioButton.addDialogListener(parent);
        this.dateFormatComboBox.addDialogListener(parent);
        this.dateSeparatorField.addDialogListener(parent);
        this.showSecondsCheckBox.addDialogListener(parent);
        this.showCenturyCheckBox.addDialogListener(parent);
    }

    private String getTimeFormatString() {
        boolean showSeconds = this.showSecondsCheckBox.isSelected();
        if (this.time12RadioButton.isSelected()) {
            return showSeconds ? "hh:mm:ss a" : "hh:mm a";
        }
        return showSeconds ? "HH:mm:ss" : "HH:mm";
    }

    private String getDateFormatString() {
        int selectedIndex = this.dateFormatComboBox.getSelectedIndex();
        return CustomDateFormat.replaceDateSeparator(this.showCenturyCheckBox.isSelected() ? DATE_FORMATS_WITH_CENTURY[selectedIndex] : DATE_FORMATS[selectedIndex], this.dateSeparatorField.getText());
    }

    private void updatePreviewLabel() {
        SimpleDateFormat dateFormat = new SimpleDateFormat(this.getDateFormatString() + " " + this.getTimeFormatString());
        this.previewLabel.setText(dateFormat.format(this.exampleDate));
        this.previewLabel.repaint();
    }

    protected void commit() {
        MuConfigurations.getPreferences().setVariable(MuPreference.LANGUAGE, this.languages[this.languageComboBox.getSelectedIndex()]);
        MuConfigurations.getPreferences().setVariable(MuPreference.DATE_FORMAT, this.getDateFormatString());
        MuConfigurations.getPreferences().setVariable(MuPreference.DATE_SEPARATOR, this.dateSeparatorField.getText());
        MuConfigurations.getPreferences().setVariable(MuPreference.TIME_FORMAT, this.getTimeFormatString());
    }

    public void itemStateChanged(ItemEvent e) {
        this.updatePreviewLabel();
    }

    public void actionPerformed(ActionEvent e) {
        this.updatePreviewLabel();
    }

    public void changedUpdate(DocumentEvent e) {
        this.updatePreviewLabel();
    }

    public void insertUpdate(DocumentEvent e) {
        this.updatePreviewLabel();
    }

    public void removeUpdate(DocumentEvent e) {
        this.updatePreviewLabel();
    }
}

