/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.ui.dialog.pref.general;

import com.mucommander.bonjour.BonjourDirectory;
import com.mucommander.conf.MuConfigurations;
import com.mucommander.conf.MuPreference;
import com.mucommander.conf.MuPreferences;
import com.mucommander.desktop.DesktopManager;
import com.mucommander.text.Translator;
import com.mucommander.ui.dialog.DialogOwner;
import com.mucommander.ui.dialog.pref.PreferencesDialog;
import com.mucommander.ui.dialog.pref.PreferencesPanel;
import com.mucommander.ui.dialog.pref.component.PrefCheckBox;
import com.mucommander.ui.dialog.pref.component.PrefEncodingSelectBox;
import com.mucommander.ui.dialog.pref.component.PrefFilePathField;
import com.mucommander.ui.dialog.pref.component.PrefRadioButton;
import com.mucommander.ui.dialog.pref.component.PrefTextField;
import com.mucommander.ui.layout.XAlignedComponentPanel;
import com.mucommander.ui.layout.YBoxPanel;
import com.mucommander.ui.notifier.AbstractNotifier;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

class MiscPanel
extends PreferencesPanel
implements ItemListener {
    private PrefTextField customShellField;
    private PrefRadioButton useCustomShellRadioButton;
    private PrefCheckBox checkForUpdatesCheckBox;
    private PrefCheckBox quitConfirmationCheckBox;
    private PrefCheckBox showSplashScreenCheckBox;
    private PrefCheckBox systemNotificationsCheckBox;
    private PrefCheckBox bonjourDiscoveryCheckBox;
    private PrefCheckBox shellEncodingautoDetectCheckbox;
    private PrefEncodingSelectBox shellEncodingSelectBox;

    private JPanel createShellEncodingPanel(PreferencesDialog parent) {
        JPanel panel = new JPanel(new FlowLayout(3));
        this.shellEncodingautoDetectCheckbox = new PrefCheckBox(Translator.get("prefs_dialog.auto_detect_shell_encoding", new String[0])){

            public boolean hasChanged() {
                return this.isSelected() != MuConfigurations.getPreferences().getVariable(MuPreference.AUTODETECT_SHELL_ENCODING, true);
            }
        };
        boolean autoDetect = MuConfigurations.getPreferences().getVariable(MuPreference.AUTODETECT_SHELL_ENCODING, true);
        this.shellEncodingautoDetectCheckbox.setSelected(autoDetect);
        this.shellEncodingautoDetectCheckbox.addItemListener(this);
        panel.add(this.shellEncodingautoDetectCheckbox);
        this.shellEncodingSelectBox = new PrefEncodingSelectBox(new DialogOwner(parent), MuConfigurations.getPreferences().getVariable(MuPreference.SHELL_ENCODING)){

            public boolean hasChanged() {
                return !MuConfigurations.getPreferences().getVariable(MuPreference.SHELL_ENCODING).equals(this.getSelectedEncoding());
            }
        };
        this.shellEncodingSelectBox.setEnabled(!autoDetect);
        panel.add(this.shellEncodingSelectBox);
        return panel;
    }

    public MiscPanel(PreferencesDialog parent) {
        super(parent, Translator.get("prefs_dialog.misc_tab", new String[0]));
        this.setLayout(new BorderLayout());
        YBoxPanel northPanel = new YBoxPanel();
        JRadioButton useDefaultShellRadioButton = new JRadioButton(Translator.get("prefs_dialog.default_shell", new String[0]) + ':');
        this.useCustomShellRadioButton = new PrefRadioButton(Translator.get("prefs_dialog.custom_shell", new String[0]) + ':'){

            public boolean hasChanged() {
                return this.isSelected() != MuConfigurations.getPreferences().getVariable(MuPreference.USE_CUSTOM_SHELL, false);
            }
        };
        if (MuConfigurations.getPreferences().getVariable(MuPreference.USE_CUSTOM_SHELL, false)) {
            this.useCustomShellRadioButton.setSelected(true);
        } else {
            useDefaultShellRadioButton.setSelected(true);
        }
        this.useCustomShellRadioButton.addItemListener(this);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(useDefaultShellRadioButton);
        buttonGroup.add(this.useCustomShellRadioButton);
        XAlignedComponentPanel shellPanel = new XAlignedComponentPanel();
        shellPanel.setLabelLeftAligned(true);
        shellPanel.setBorder(BorderFactory.createTitledBorder(Translator.get("prefs_dialog.shell", new String[0])));
        this.customShellField = new PrefFilePathField(MuConfigurations.getPreferences().getVariable(MuPreference.CUSTOM_SHELL, "")){

            public boolean hasChanged() {
                return this.isEnabled() && !this.getText().equals(MuConfigurations.getPreferences().getVariable(MuPreference.CUSTOM_SHELL));
            }
        };
        this.customShellField.setEnabled(this.useCustomShellRadioButton.isSelected());
        shellPanel.addRow(useDefaultShellRadioButton, (JComponent)new JLabel(DesktopManager.getDefaultShell()), 5);
        shellPanel.addRow(this.useCustomShellRadioButton, (JComponent)this.customShellField, 10);
        shellPanel.addRow(Translator.get("prefs_dialog.shell_encoding", new String[0]), (JComponent)this.createShellEncodingPanel(parent), 5);
        northPanel.add((Component)shellPanel, 5);
        northPanel.addSpace(10);
        this.showSplashScreenCheckBox = new PrefCheckBox(Translator.get("prefs_dialog.show_splash_screen", new String[0])){

            public boolean hasChanged() {
                return this.isSelected() != MuConfigurations.getPreferences().getVariable(MuPreference.SHOW_SPLASH_SCREEN, true);
            }
        };
        this.showSplashScreenCheckBox.setSelected(MuConfigurations.getPreferences().getVariable(MuPreference.SHOW_SPLASH_SCREEN, true));
        northPanel.add(this.showSplashScreenCheckBox);
        this.checkForUpdatesCheckBox = new PrefCheckBox(Translator.get("prefs_dialog.check_for_updates_on_startup", new String[0])){

            public boolean hasChanged() {
                return this.isSelected() != MuConfigurations.getPreferences().getVariable(MuPreference.CHECK_FOR_UPDATE, true);
            }
        };
        this.checkForUpdatesCheckBox.setSelected(MuConfigurations.getPreferences().getVariable(MuPreference.CHECK_FOR_UPDATE, true));
        northPanel.add(this.checkForUpdatesCheckBox);
        this.quitConfirmationCheckBox = new PrefCheckBox(Translator.get("prefs_dialog.confirm_on_quit", new String[0])){

            public boolean hasChanged() {
                return this.isSelected() != MuConfigurations.getPreferences().getVariable(MuPreference.CONFIRM_ON_QUIT, true);
            }
        };
        this.quitConfirmationCheckBox.setSelected(MuConfigurations.getPreferences().getVariable(MuPreference.CONFIRM_ON_QUIT, true));
        northPanel.add(this.quitConfirmationCheckBox);
        if (AbstractNotifier.isAvailable()) {
            this.systemNotificationsCheckBox = new PrefCheckBox(Translator.get("prefs_dialog.enable_system_notifications", new String[0]) + " (" + AbstractNotifier.getNotifier().getPrettyName() + ")"){

                public boolean hasChanged() {
                    return this.isSelected() != MuConfigurations.getPreferences().getVariable(MuPreference.ENABLE_SYSTEM_NOTIFICATIONS, MuPreferences.DEFAULT_ENABLE_SYSTEM_NOTIFICATIONS);
                }
            };
            this.systemNotificationsCheckBox.setSelected(MuConfigurations.getPreferences().getVariable(MuPreference.ENABLE_SYSTEM_NOTIFICATIONS, MuPreferences.DEFAULT_ENABLE_SYSTEM_NOTIFICATIONS));
            northPanel.add(this.systemNotificationsCheckBox);
        }
        this.bonjourDiscoveryCheckBox = new PrefCheckBox(Translator.get("prefs_dialog.enable_bonjour_discovery", new String[0])){

            public boolean hasChanged() {
                return this.isSelected() != MuConfigurations.getPreferences().getVariable(MuPreference.ENABLE_BONJOUR_DISCOVERY, true);
            }
        };
        this.bonjourDiscoveryCheckBox.setSelected(MuConfigurations.getPreferences().getVariable(MuPreference.ENABLE_BONJOUR_DISCOVERY, true));
        northPanel.add(this.bonjourDiscoveryCheckBox);
        this.add((Component)northPanel, "North");
        this.customShellField.addDialogListener(parent);
        this.useCustomShellRadioButton.addDialogListener(parent);
        this.checkForUpdatesCheckBox.addDialogListener(parent);
        this.quitConfirmationCheckBox.addDialogListener(parent);
        this.showSplashScreenCheckBox.addDialogListener(parent);
        this.bonjourDiscoveryCheckBox.addDialogListener(parent);
        this.shellEncodingautoDetectCheckbox.addDialogListener(parent);
        this.shellEncodingSelectBox.addDialogListener(parent);
        if (this.systemNotificationsCheckBox != null) {
            this.systemNotificationsCheckBox.addDialogListener(parent);
        }
    }

    public void itemStateChanged(ItemEvent e) {
        Object source = e.getSource();
        if (source == this.useCustomShellRadioButton) {
            this.customShellField.setEnabled(this.useCustomShellRadioButton.isSelected());
        } else if (source == this.shellEncodingautoDetectCheckbox) {
            this.shellEncodingSelectBox.setEnabled(!this.shellEncodingautoDetectCheckbox.isSelected());
        }
    }

    protected void commit() {
        boolean enabled;
        MuConfigurations.getPreferences().setVariable(MuPreference.CHECK_FOR_UPDATE, this.checkForUpdatesCheckBox.isSelected());
        MuConfigurations.getPreferences().setVariable(MuPreference.USE_CUSTOM_SHELL, this.useCustomShellRadioButton.isSelected());
        MuConfigurations.getPreferences().setVariable(MuPreference.CUSTOM_SHELL, this.customShellField.getText());
        boolean isAutoDetect = this.shellEncodingautoDetectCheckbox.isSelected();
        MuConfigurations.getPreferences().setVariable(MuPreference.AUTODETECT_SHELL_ENCODING, isAutoDetect);
        if (!isAutoDetect) {
            MuConfigurations.getPreferences().setVariable(MuPreference.SHELL_ENCODING, this.shellEncodingSelectBox.getSelectedEncoding());
        }
        MuConfigurations.getPreferences().setVariable(MuPreference.CONFIRM_ON_QUIT, this.quitConfirmationCheckBox.isSelected());
        MuConfigurations.getPreferences().setVariable(MuPreference.SHOW_SPLASH_SCREEN, this.showSplashScreenCheckBox.isSelected());
        if (this.systemNotificationsCheckBox != null) {
            enabled = this.systemNotificationsCheckBox.isSelected();
            MuConfigurations.getPreferences().setVariable(MuPreference.ENABLE_SYSTEM_NOTIFICATIONS, enabled);
            AbstractNotifier.getNotifier().setEnabled(enabled);
        }
        enabled = this.bonjourDiscoveryCheckBox.isSelected();
        MuConfigurations.getPreferences().setVariable(MuPreference.ENABLE_BONJOUR_DISCOVERY, enabled);
        BonjourDirectory.setActive(enabled);
    }
}

