/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.ui.dialog.pref.general;

import com.mucommander.commons.runtime.OsFamilies;
import com.mucommander.commons.runtime.OsVersions;
import com.mucommander.commons.util.Pair;
import com.mucommander.text.Translator;
import com.mucommander.ui.action.ActionDescriptor;
import com.mucommander.ui.action.ActionKeymap;
import com.mucommander.ui.action.ActionManager;
import com.mucommander.ui.action.ActionProperties;
import com.mucommander.ui.dialog.pref.component.PrefTable;
import com.mucommander.ui.dialog.pref.general.ShortcutsPanel;
import com.mucommander.ui.icon.IconManager;
import com.mucommander.ui.main.table.CellLabel;
import com.mucommander.ui.table.CenteredTableHeaderRenderer;
import com.mucommander.ui.text.KeyStrokeUtils;
import com.mucommander.ui.theme.ColorChangedEvent;
import com.mucommander.ui.theme.FontChangedEvent;
import com.mucommander.ui.theme.ThemeCache;
import com.mucommander.ui.theme.ThemeListener;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.ImageIcon;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShortcutsTable
extends PrefTable
implements FocusListener,
KeyListener,
ListSelectionListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(ShortcutsTable.class);
    private static ImageIcon transparentIcon = new ImageIcon(new BufferedImage(16, 16, 2));
    public static final Object DELETE = new Object();
    private ShortcutsTableData data;
    private static final Comparator<String> ACTIONS_COMPARATOR = new Comparator<String>(){

        @Override
        public int compare(String id1, String id2) {
            String label1 = ActionProperties.getActionLabel(id1);
            if (label1 == null) {
                return 1;
            }
            String label2 = ActionProperties.getActionLabel(id2);
            if (label2 == null) {
                return -1;
            }
            return label1.compareTo(label2);
        }
    };
    private int lastSelectedRow = -1;
    private ShortcutsPanel.TooltipBar tooltipBar;
    private CancelEditingStateThread cancelEditingStateThread;
    private ShortcutsTableCellRenderer cellRenderer;

    public ShortcutsTable(ShortcutsPanel.TooltipBar tooltipBar) {
        this.tooltipBar = tooltipBar;
        this.data = new ShortcutsTableData();
        this.setModel(new KeymapTableModel(this.data));
        this.cellRenderer = new ShortcutsTableCellRenderer();
        this.setShowGrid(false);
        this.setIntercellSpacing(new Dimension(0, 0));
        this.setRowHeight(Math.max(this.getRowHeight(), 18));
        this.getTableHeader().setReorderingAllowed(false);
        this.setRowSelectionAllowed(false);
        this.setAutoCreateColumnsFromModel(false);
        this.setCellSelectionEnabled(false);
        this.setColumnSelectionAllowed(false);
        this.setDragEnabled(false);
        if (!ShortcutsTable.usesTableHeaderRenderingProperties()) {
            CenteredTableHeaderRenderer renderer = new CenteredTableHeaderRenderer();
            this.getColumnModel().getColumn(0).setHeaderRenderer(renderer);
            this.getColumnModel().getColumn(1).setHeaderRenderer(renderer);
            this.getColumnModel().getColumn(2).setHeaderRenderer(renderer);
        }
        this.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        this.addKeyListener(this);
        this.addFocusListener(this);
        this.getSelectionModel().addListSelectionListener(this);
        this.getColumnModel().getSelectionModel().addListSelectionListener(this);
    }

    private static void paintDottedBorder(Graphics g, int width, int height, Color color) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setStroke(new BasicStroke(1.0f, 1, 0, 2.0f, new float[]{2.0f}, 0.0f));
        g2.setColor(color);
        g2.drawLine(0, 0, width, 0);
        g2.drawLine(0, height - 1, width, height - 1);
        g2.drawLine(0, 0, 0, height - 1);
        g2.drawLine(width - 1, 0, width - 1, height - 1);
    }

    private static boolean usesTableHeaderRenderingProperties() {
        return OsFamilies.MAC_OS_X.isCurrent() && OsVersions.MAC_OS_X_10_5.isCurrentOrHigher();
    }

    public void scrollToVisible(int rowIndex, int vColIndex) {
        if (!(this.getParent() instanceof JViewport)) {
            return;
        }
        JViewport viewport = (JViewport)this.getParent();
        Rectangle rect = this.getCellRect(rowIndex, vColIndex, true);
        Point pt = viewport.getViewPosition();
        rect.setLocation(rect.x - pt.x, rect.y - pt.y);
        viewport.scrollRectToVisible(rect);
    }

    public void createCancelEditingStateThread(TableCellEditor cellEditor) {
        if (this.cancelEditingStateThread != null) {
            this.cancelEditingStateThread.neutralize();
        }
        this.cancelEditingStateThread = new CancelEditingStateThread(cellEditor);
        this.cancelEditingStateThread.start();
    }

    public TableCellRenderer getCellRenderer(int row, int column) {
        return this.cellRenderer;
    }

    public void valueChanged(ListSelectionEvent e) {
        super.valueChanged(e);
        int selectetRow = this.getSelectedRow();
        if (selectetRow == -1) {
            this.tooltipBar.showDefaultMessage();
        } else {
            this.tooltipBar.showActionTooltip(this.data.getCurrentTooltip());
        }
    }

    public void updateModel(ActionFilter filter) {
        this.data.filter(filter);
    }

    public void setModel(TableModel model) {
        super.setModel(model);
    }

    public boolean hasChanged() {
        return this.data.hasChanged();
    }

    public TableCellEditor getCellEditor(int row, int column) {
        return new KeyStrokeCellEditor(new RecordingKeyStrokeField((KeyStroke)this.getValueAt(row, column)));
    }

    public void commitChanges() {
        this.data.submitChanges();
    }

    public void restoreDefaults() {
        this.data.restoreDefaultAccelerators();
    }

    public void focusGained(FocusEvent e) {
        int currentSelectedRow = this.getSelectedRow();
        if (this.lastSelectedRow != currentSelectedRow) {
            this.tooltipBar.showActionTooltip(this.data.getCurrentTooltip());
        }
        this.lastSelectedRow = currentSelectedRow;
    }

    public void focusLost(FocusEvent e) {
    }

    public void keyPressed(KeyEvent e) {
        int keyCode = e.getKeyCode();
        if (keyCode == 10) {
            if (this.editCellAt(this.getSelectedRow(), this.getSelectedColumn())) {
                this.getEditorComponent().requestFocusInWindow();
            }
            e.consume();
        } else if (keyCode == 127 || keyCode == 8) {
            this.setValueAt(DELETE, this.getSelectedRow(), this.getSelectedColumn());
            this.repaint();
            e.consume();
        } else if (keyCode != 37 && keyCode != 39 && keyCode != 38 && keyCode != 40 && keyCode != 36 && keyCode != 35 && keyCode != 113 && keyCode != 27) {
            e.consume();
        }
    }

    public void keyReleased(KeyEvent e) {
    }

    public void keyTyped(KeyEvent e) {
    }

    private class DotBorderedCellLabel
    extends CellLabel {
        private DotBorderedCellLabel() {
        }

        protected void paintOutline(Graphics g) {
            ShortcutsTable.paintDottedBorder(g, this.getWidth(), this.getHeight(), this.outlineColor);
        }
    }

    private class ShortcutsTableCellRenderer
    implements ThemeListener,
    TableCellRenderer {
        private DotBorderedCellLabel[] cellLabels = new DotBorderedCellLabel[3];

        public ShortcutsTableCellRenderer() {
            for (int i = 0; i < 3; ++i) {
                this.cellLabels[i] = new DotBorderedCellLabel();
            }
            this.setCellLabelsFont(ThemeCache.tableFont);
            this.cellLabels[0].setHorizontalAlignment(2);
            this.cellLabels[1].setHorizontalAlignment(0);
            this.cellLabels[2].setHorizontalAlignment(0);
            ThemeCache.addThemeListener(this);
        }

        private void setCellLabelsFont(Font newFont) {
            for (int i = 0; i < 3; ++i) {
                this.cellLabels[i].setFont(newFont);
            }
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int rowIndex, int vColIndex) {
            int columnId = ShortcutsTable.this.convertColumnIndexToModel(vColIndex);
            DotBorderedCellLabel label = this.cellLabels[columnId];
            if (columnId == 0) {
                Pair description = (Pair)value;
                label.setIcon((ImageIcon)description.first);
                label.setText((String)description.second);
                label.setForeground(ThemeCache.foregroundColors[1][0][5]);
            } else {
                String text;
                KeyStroke key = (KeyStroke)value;
                String string = text = key == null ? "" : KeyStrokeUtils.getKeyStrokeDisplayableRepresentation(key);
                if ((double)table.getColumnModel().getColumn(vColIndex).getWidth() < label.getPreferredSize().getWidth()) {
                    label.setToolTipText(text);
                } else {
                    label.setToolTipText(null);
                }
                label.setText(text);
                if (key != null) {
                    boolean customized;
                    switch (columnId) {
                        case 1: {
                            customized = !key.equals(ActionProperties.getDefaultAccelerator(ShortcutsTable.this.data.getActionId(rowIndex)));
                            break;
                        }
                        case 2: {
                            customized = !key.equals(ActionProperties.getDefaultAlternativeAccelerator(ShortcutsTable.this.data.getActionId(rowIndex)));
                            break;
                        }
                        default: {
                            customized = false;
                        }
                    }
                    label.setForeground(ThemeCache.foregroundColors[1][0][customized ? 5 : 0]);
                }
            }
            label.setOutline(hasFocus ? ThemeCache.backgroundColors[1][1] : null);
            label.setBackground(ThemeCache.backgroundColors[1][rowIndex % 2 == 0 ? 0 : 2]);
            return label;
        }

        public void colorChanged(ColorChangedEvent event) {
        }

        public void fontChanged(FontChangedEvent event) {
            if (event.getFontId() == 0) {
                this.setCellLabelsFont(ThemeCache.tableFont);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ShortcutsTableData {
        private Object[][] data;
        private String[] actionIds;
        private String[] descriptions;
        private final Integer description = 0;
        private final Integer accelerator = 1;
        private final Integer alt_accelerator = 2;
        private final Integer tooltips = 3;
        private List<String> allActionIds = new ArrayList<String>();
        private HashMap<String, HashMap<Integer, Object>> db;

        public ShortcutsTableData() {
            Iterator<String> iterator = ActionManager.getActionIds();
            while (iterator.hasNext()) {
                this.allActionIds.add(iterator.next());
            }
            Collections.sort(this.allActionIds, ACTIONS_COMPARATOR);
            int nbActions = this.allActionIds.size();
            this.db = new HashMap(nbActions);
            int nbRows = this.allActionIds.size();
            this.data = new Object[nbRows][3];
            for (String actionId : this.allActionIds) {
                ActionDescriptor actionDescriptor = ActionProperties.getActionDescriptor(actionId);
                HashMap<Integer, Object> actionProperties = new HashMap<Integer, Object>();
                ImageIcon actionIcon = actionDescriptor.getIcon();
                if (actionIcon == null) {
                    actionIcon = transparentIcon;
                }
                String actionLabel = actionDescriptor.getLabel();
                actionProperties.put(this.description, new Pair<ImageIcon, String>(IconManager.getPaddedIcon(actionIcon, new Insets(0, 4, 0, 4)), actionLabel));
                actionProperties.put(this.accelerator, ActionKeymap.getAccelerator(actionId));
                actionProperties.put(this.alt_accelerator, ActionKeymap.getAlternateAccelerator(actionId));
                actionProperties.put(this.tooltips, actionDescriptor.getDescription());
                this.db.put(actionId, actionProperties);
            }
        }

        public void filter(ActionFilter filter) {
            List<String> filteredActionIds = this.filter(this.allActionIds, filter);
            int nbRows = filteredActionIds.size();
            this.actionIds = new String[nbRows];
            this.descriptions = new String[nbRows];
            this.data = new Object[nbRows][3];
            for (int i = 0; i < nbRows; ++i) {
                String actionId;
                this.actionIds[i] = actionId = filteredActionIds.get(i);
                ActionDescriptor actionDescriptor = ActionProperties.getActionDescriptor(actionId);
                this.data[i][0] = this.db.get(actionId).get(this.description);
                KeyStroke accelerator = (KeyStroke)this.db.get(actionId).get(this.accelerator);
                this.setAccelerator(accelerator, i);
                KeyStroke alternativeAccelerator = (KeyStroke)this.db.get(actionId).get(this.alt_accelerator);
                this.setAlternativeAccelerator(alternativeAccelerator, i);
                this.descriptions[i] = actionDescriptor.getDescription();
            }
            ShortcutsTable.this.clearSelection();
            ((DefaultTableModel)ShortcutsTable.this.getModel()).setRowCount(this.data.length);
            ShortcutsTable.this.repaint();
            ShortcutsTable.this.scrollToVisible(0, 0);
        }

        public Object[][] getTableData() {
            return this.data;
        }

        public Object getTableData(int row, int col) {
            return this.data[row][col];
        }

        public String getCurrentTooltip() {
            return this.descriptions[ShortcutsTable.this.getSelectedRow()];
        }

        public String getActionId(int row) {
            return this.actionIds[row];
        }

        public boolean hasChanged() {
            for (String actionId : this.db.keySet()) {
                HashMap<Integer, Object> actionProperties = this.db.get(actionId);
                if (this.equals(actionProperties.get(this.accelerator), ActionKeymap.getAccelerator(actionId)) && this.equals(actionProperties.get(this.alt_accelerator), ActionKeymap.getAlternateAccelerator(actionId))) continue;
                return true;
            }
            return false;
        }

        public void restoreDefaultAccelerators() {
            for (String actionId : this.allActionIds) {
                this.db.get(actionId).put(this.accelerator, ActionProperties.getDefaultAccelerator(actionId));
                this.db.get(actionId).put(this.alt_accelerator, ActionProperties.getDefaultAlternativeAccelerator(actionId));
            }
            int nbRows = this.actionIds.length;
            for (int i = 0; i < nbRows; ++i) {
                this.data[i][1] = this.db.get(this.actionIds[i]).get(this.accelerator);
                this.data[i][2] = this.db.get(this.actionIds[i]).get(this.alt_accelerator);
            }
            ((DefaultTableModel)ShortcutsTable.this.getModel()).fireTableDataChanged();
        }

        public void submitChanges() {
            for (String actionId : this.db.keySet()) {
                HashMap<Integer, Object> actionProperties = this.db.get(actionId);
                KeyStroke accelerator = (KeyStroke)actionProperties.get(this.accelerator);
                KeyStroke alternateAccelerator = (KeyStroke)actionProperties.get(this.alt_accelerator);
                if (this.equals(accelerator, ActionKeymap.getAccelerator(actionId)) && this.equals(alternateAccelerator, ActionKeymap.getAlternateAccelerator(actionId))) continue;
                ActionKeymap.changeActionAccelerators(actionId, accelerator, alternateAccelerator);
            }
        }

        public String contains(KeyStroke accelerator) {
            if (accelerator != null) {
                for (String actionId : this.db.keySet()) {
                    if (!accelerator.equals(this.db.get(actionId).get(this.accelerator)) && !accelerator.equals(this.db.get(actionId).get(this.alt_accelerator))) continue;
                    return actionId;
                }
            }
            return null;
        }

        private void setAccelerator(KeyStroke accelerator, int row) {
            this.data[row][1] = accelerator;
            this.db.get(this.getActionId(row)).put(this.accelerator, accelerator);
        }

        private void setAlternativeAccelerator(KeyStroke altAccelerator, int row) {
            this.data[row][2] = altAccelerator;
            this.db.get(this.getActionId(row)).put(this.alt_accelerator, altAccelerator);
        }

        private List<String> filter(List<String> actionIds, ActionFilter filter) {
            LinkedList<String> filteredActionsList = new LinkedList<String>();
            for (String actionId : actionIds) {
                if (ActionProperties.getActionDescriptor(actionId).isParameterized() || !filter.accept(actionId)) continue;
                filteredActionsList.add(actionId);
            }
            return filteredActionsList;
        }

        private boolean equals(Object obj1, Object obj2) {
            if (obj1 == null) {
                return obj2 == null;
            }
            return obj1.equals(obj2);
        }
    }

    private class RecordingKeyStrokeField
    extends JTextField
    implements KeyListener {
        private KeyStroke lastKeyStroke;

        public RecordingKeyStrokeField(KeyStroke currentKeyStroke) {
            super(Translator.get("shortcuts_table.type_in_a_shortcut", new String[0]));
            this.lastKeyStroke = currentKeyStroke;
            this.setBorder(BorderFactory.createEmptyBorder());
            this.setHorizontalAlignment(0);
            this.setEditable(false);
            this.setBackground(ThemeCache.backgroundColors[1][1]);
            this.setForeground(ThemeCache.foregroundColors[1][1][5]);
            this.addKeyListener(this);
        }

        public KeyStroke getLastKeyStroke() {
            return this.lastKeyStroke;
        }

        protected void paintBorder(Graphics g) {
            ShortcutsTable.paintDottedBorder(g, this.getWidth(), this.getHeight(), ThemeCache.backgroundColors[1][0]);
        }

        public void keyPressed(KeyEvent keyEvent) {
            LOGGER.trace("keyModifiers=" + keyEvent.getModifiers() + " keyCode=" + keyEvent.getKeyCode());
            int keyCode = keyEvent.getKeyCode();
            if (keyCode == 16 || keyCode == 17 || keyCode == 18 || keyCode == 157) {
                return;
            }
            KeyStroke pressedKeyStroke = KeyStroke.getKeyStrokeForEvent(keyEvent);
            if (pressedKeyStroke.equals(this.lastKeyStroke)) {
                TableCellEditor activeCellEditor = ShortcutsTable.this.getCellEditor();
                if (activeCellEditor != null) {
                    activeCellEditor.stopCellEditing();
                }
            } else {
                String actionId = ShortcutsTable.this.data.contains(pressedKeyStroke);
                if (actionId != null) {
                    String errorMessage = "The shortcut [" + KeyStrokeUtils.getKeyStrokeDisplayableRepresentation(pressedKeyStroke) + "] is already assigned to '" + ActionProperties.getActionDescription(actionId) + "'";
                    ShortcutsTable.this.tooltipBar.showErrorMessage(errorMessage);
                    ShortcutsTable.this.createCancelEditingStateThread(ShortcutsTable.this.getCellEditor());
                } else {
                    this.lastKeyStroke = pressedKeyStroke;
                    this.setText(KeyStrokeUtils.getKeyStrokeDisplayableRepresentation(this.lastKeyStroke));
                }
            }
            keyEvent.consume();
        }

        public void keyReleased(KeyEvent e) {
            e.consume();
        }

        public void keyTyped(KeyEvent e) {
            e.consume();
        }
    }

    private class KeymapTableModel
    extends DefaultTableModel {
        private ShortcutsTableData tableData;

        private KeymapTableModel(ShortcutsTableData data) {
            super(data.getTableData(), new String[]{Translator.get("shortcuts_table.action_description", new String[0]), Translator.get("shortcuts_table.shortcut", new String[0]), Translator.get("shortcuts_table.alternate_shortcut", new String[0])});
            this.tableData = null;
            this.tableData = data;
        }

        public boolean isCellEditable(int row, int column) {
            switch (column) {
                case 0: {
                    return false;
                }
                case 1: 
                case 2: {
                    return true;
                }
            }
            return false;
        }

        public Object getValueAt(int row, int column) {
            return this.tableData.getTableData(row, column);
        }

        public void setValueAt(Object value, int row, int column) {
            if (value == null) {
                return;
            }
            if (value == DELETE) {
                value = null;
            }
            KeyStroke typedKeyStroke = (KeyStroke)value;
            switch (column) {
                case 1: {
                    this.tableData.setAccelerator(typedKeyStroke, row);
                    break;
                }
                case 2: {
                    this.tableData.setAlternativeAccelerator(typedKeyStroke, row);
                    break;
                }
                default: {
                    LOGGER.debug("Unexpected column index: " + column);
                }
            }
            this.fireTableCellUpdated(row, column);
            LOGGER.trace("Value: " + value + ", row: " + row + ", col: " + column);
        }
    }

    private class CancelEditingStateThread
    extends Thread {
        private boolean stopped = false;
        private TableCellEditor cellEditor;

        public CancelEditingStateThread(TableCellEditor cellEditor) {
            this.cellEditor = cellEditor;
        }

        public void neutralize() {
            this.stopped = true;
        }

        public void run() {
            try {
                Thread.sleep(3000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (!this.stopped && this.cellEditor != null) {
                this.cellEditor.stopCellEditing();
            }
        }
    }

    private class KeyStrokeCellEditor
    extends DefaultCellEditor
    implements TableCellEditor {
        RecordingKeyStrokeField rec;

        public KeyStrokeCellEditor(RecordingKeyStrokeField rec) {
            super(rec);
            this.rec = rec;
            rec.setSelectionColor(rec.getBackground());
            rec.setSelectedTextColor(rec.getForeground());
            rec.getDocument().addDocumentListener(new DocumentListener(){

                public void insertUpdate(DocumentEvent e) {
                    KeyStrokeCellEditor.this.stopCellEditing();
                }

                public void changedUpdate(DocumentEvent e) {
                }

                public void removeUpdate(DocumentEvent e) {
                }
            });
            this.setClickCountToStart(2);
            ShortcutsTable.this.createCancelEditingStateThread(this);
        }

        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int col) {
            return this.rec;
        }

        public Object getCellEditorValue() {
            return this.rec.getLastKeyStroke();
        }
    }

    public static abstract class ActionFilter {
        public abstract boolean accept(String var1);
    }
}

