/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.ui.dialog.pref.general;

import com.mucommander.text.Translator;
import com.mucommander.ui.button.ButtonChoicePanel;
import com.mucommander.ui.dialog.FocusDialog;
import com.mucommander.ui.layout.XAlignedComponentPanel;
import com.mucommander.ui.layout.YBoxPanel;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class ThemeNameDialog
extends FocusDialog
implements ActionListener {
    private JTextField nameField;
    private JButton okButton;
    private JButton cancelButton;
    private boolean wasValidated;
    private static final Dimension MAXIMUM_DIALOG_DIMENSION = new Dimension(480, 10000);

    public ThemeNameDialog(Frame owner, String name) {
        super(owner, Translator.get("rename", new String[0]), (Component)owner);
        this.init(name);
    }

    public ThemeNameDialog(Dialog owner, String name) {
        super(owner, Translator.get("rename", new String[0]), (Component)owner);
        this.init(name);
    }

    private JPanel createNamePanel(String name) {
        XAlignedComponentPanel panel = new XAlignedComponentPanel(5);
        this.nameField = new JTextField();
        this.nameField.setText(name);
        this.nameField.setSelectionStart(0);
        this.nameField.setSelectionEnd(name.length());
        panel.addRow(Translator.get("name", new String[0]), (JComponent)this.nameField, 0);
        return panel;
    }

    private void init(String name) {
        this.setMaximumSize(MAXIMUM_DIALOG_DIMENSION);
        YBoxPanel panel = new YBoxPanel();
        panel.add(this.createNamePanel(name));
        this.okButton = new JButton(Translator.get("ok", new String[0]));
        panel.add(new ButtonChoicePanel(new JButton[]{this.okButton, this.cancelButton = new JButton(Translator.get("cancel", new String[0]))}, 2, this.getRootPane()));
        this.okButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
        this.getContentPane().add((Component)panel, "North");
        this.pack();
    }

    public String getText() {
        return this.nameField.getText();
    }

    public void cancel() {
        this.wasValidated = false;
        super.cancel();
    }

    public boolean wasValidated() {
        this.showDialog();
        return this.wasValidated;
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.okButton) {
            this.wasValidated = true;
        } else if (e.getSource() == this.cancelButton) {
            this.wasValidated = false;
        }
        this.dispose();
    }
}

