/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.ui.dialog.pref.theme;

import com.mucommander.text.Translator;
import com.mucommander.ui.chooser.FontChooser;
import com.mucommander.ui.dialog.pref.PreferencesDialog;
import com.mucommander.ui.dialog.pref.theme.ThemeEditorPanel;
import com.mucommander.ui.layout.ProportionalGridPanel;
import com.mucommander.ui.layout.YBoxPanel;
import com.mucommander.ui.theme.ThemeData;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.InputStreamReader;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

class FileEditorPanel
extends ThemeEditorPanel
implements PropertyChangeListener {
    private JTextArea preview;

    public FileEditorPanel(PreferencesDialog parent, ThemeData themeData) {
        super(parent, Translator.get("theme_editor.editor_tab", new String[0]), themeData);
        this.initUI();
    }

    private JPanel createColorsPanel(FontChooser fontChooser) {
        ProportionalGridPanel gridPanel = new ProportionalGridPanel(3);
        this.addLabelRow(gridPanel, false);
        this.addColorButtons(gridPanel, fontChooser, "theme_editor.normal", 41, 42).addPropertyChangeListener(this);
        this.addColorButtons(gridPanel, fontChooser, "theme_editor.selected", 43, 44).addPropertyChangeListener(this);
        JPanel colorsPanel = new JPanel(new FlowLayout(0));
        colorsPanel.add(gridPanel);
        colorsPanel.setBorder(BorderFactory.createTitledBorder(Translator.get("theme_editor.colors", new String[0])));
        return colorsPanel;
    }

    private void initUI() {
        JPanel mainPanel = new JPanel(new BorderLayout());
        FontChooser fontChooser = this.createFontChooser(2);
        mainPanel.add((Component)this.createPreviewPanel(), "East");
        this.addFontChooserListener(fontChooser, this.preview);
        YBoxPanel configurationPanel = new YBoxPanel();
        configurationPanel.add(fontChooser);
        configurationPanel.addSpace(10);
        configurationPanel.add(this.createColorsPanel(fontChooser));
        mainPanel.add((Component)configurationPanel, "Center");
        this.setLayout(new BorderLayout());
        this.add((Component)mainPanel, "North");
    }

    private JPanel createPreviewPanel() {
        this.preview = new JTextArea(15, 15);
        this.setBackgroundColors();
        this.setForegroundColors();
        JPanel panel = new JPanel(new BorderLayout());
        JScrollPane scroll = new JScrollPane(this.preview, 22, 30);
        panel.add((Component)scroll, "Center");
        scroll.getViewport().setPreferredSize(this.preview.getPreferredSize());
        panel.setBorder(BorderFactory.createTitledBorder(Translator.get("preview", new String[0])));
        this.loadText();
        this.preview.setCaretPosition(0);
        return panel;
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (event.getPropertyName().equals("PreviewLabel.BackgroundColor")) {
            this.setBackgroundColors();
        } else if (event.getPropertyName().equals("PreviewLabel.ForegroundColor")) {
            this.setForegroundColors();
        }
    }

    private void setBackgroundColors() {
        this.preview.setBackground(this.themeData.getColor(42));
        this.preview.setSelectionColor(this.themeData.getColor(44));
    }

    private void setForegroundColors() {
        this.preview.setForeground(this.themeData.getColor(41));
        this.preview.setCaretColor(this.themeData.getColor(41));
        this.preview.setSelectedTextColor(this.themeData.getColor(43));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadText() {
        InputStreamReader inputStreamReader = null;
        try {
            int n;
            inputStreamReader = new InputStreamReader(FileEditorPanel.class.getResourceAsStream("/license.txt"));
            char[] cArray = new char[2048];
            while ((n = inputStreamReader.read(cArray)) != -1) {
                this.preview.append(new String(cArray, 0, n));
            }
        }
        catch (Exception exception) {
        }
        finally {
            if (inputStreamReader != null) {
                try {
                    inputStreamReader.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public void commit() {
    }
}

