/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.ui.dialog.pref.theme;

import com.mucommander.text.Translator;
import com.mucommander.ui.chooser.FontChooser;
import com.mucommander.ui.chooser.PreviewLabel;
import com.mucommander.ui.dialog.pref.PreferencesDialog;
import com.mucommander.ui.dialog.pref.theme.ColorButton;
import com.mucommander.ui.dialog.pref.theme.FilePreviewPanel;
import com.mucommander.ui.dialog.pref.theme.ThemeEditorPanel;
import com.mucommander.ui.layout.ProportionalGridPanel;
import com.mucommander.ui.theme.ThemeData;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import javax.swing.JLabel;
import javax.swing.JPanel;

class FilePanel
extends ThemeEditorPanel {
    public FilePanel(PreferencesDialog parent, boolean isActive, ThemeData data, FontChooser fontChooser) {
        super(parent, Translator.get(isActive ? "theme_editor.active_panel" : "theme_editor.inactive_panel", new String[0]), data);
        this.initUI(isActive, fontChooser);
    }

    private void addForegroundColor(JPanel to, int colorId, ColorButton background, FontChooser fontChooser, FilePreviewPanel previewPanel) {
        PreviewLabel preview = new PreviewLabel();
        preview.setTextPainted(true);
        background.addUpdatedPreviewComponent(preview);
        this.addFontChooserListener(fontChooser, preview);
        ColorButton button = new ColorButton(this.parent, this.themeData, colorId, "PreviewLabel.ForegroundColor", preview);
        to.add(button);
        button.addUpdatedPreviewComponent(previewPanel);
    }

    private void initUI(boolean isActive, FontChooser fontChooser) {
        ProportionalGridPanel gridPanel = new ProportionalGridPanel(3);
        FilePreviewPanel preview = new FilePreviewPanel(this.themeData, isActive);
        this.addFontChooserListener(fontChooser, preview);
        ((Container)gridPanel).add(new JLabel());
        ((Container)gridPanel).add(this.createCaptionLabel("theme_editor.normal"));
        ((Container)gridPanel).add(this.createCaptionLabel("theme_editor.selected"));
        ((Container)gridPanel).add(this.createCaptionLabel("theme_editor.background"));
        ColorButton backgroundButton = new ColorButton(this.parent, this.themeData, isActive ? 1 : 3, "PreviewLabel.BackgroundColor", preview);
        ((Container)gridPanel).add(backgroundButton);
        ColorButton selectedBackgroundButton = new ColorButton(this.parent, this.themeData, isActive ? 7 : 8, "PreviewLabel.BackgroundColor", preview);
        ((Container)gridPanel).add(selectedBackgroundButton);
        ((Container)gridPanel).add(this.createCaptionLabel("theme_editor.alternate_background"));
        ((Container)gridPanel).add(new ColorButton(this.parent, this.themeData, isActive ? 2 : 4, "PreviewLabel.BackgroundColor", preview));
        ((Container)gridPanel).add(new JLabel());
        ((Container)gridPanel).add(this.createCaptionLabel("theme_editor.folder"));
        this.addForegroundColor(gridPanel, isActive ? 13 : 14, backgroundButton, fontChooser, preview);
        this.addForegroundColor(gridPanel, isActive ? 15 : 16, selectedBackgroundButton, fontChooser, preview);
        ((Container)gridPanel).add(this.createCaptionLabel("theme_editor.plain_file"));
        this.addForegroundColor(gridPanel, isActive ? 29 : 30, backgroundButton, fontChooser, preview);
        this.addForegroundColor(gridPanel, isActive ? 31 : 32, selectedBackgroundButton, fontChooser, preview);
        ((Container)gridPanel).add(this.createCaptionLabel("theme_editor.archive_file"));
        this.addForegroundColor(gridPanel, isActive ? 17 : 18, backgroundButton, fontChooser, preview);
        this.addForegroundColor(gridPanel, isActive ? 19 : 20, selectedBackgroundButton, fontChooser, preview);
        ((Container)gridPanel).add(this.createCaptionLabel("theme_editor.hidden_file"));
        this.addForegroundColor(gridPanel, isActive ? 9 : 10, backgroundButton, fontChooser, preview);
        this.addForegroundColor(gridPanel, isActive ? 11 : 12, selectedBackgroundButton, fontChooser, preview);
        ((Container)gridPanel).add(this.createCaptionLabel("theme_editor.symbolic_link"));
        this.addForegroundColor(gridPanel, isActive ? 21 : 22, backgroundButton, fontChooser, preview);
        this.addForegroundColor(gridPanel, isActive ? 23 : 24, selectedBackgroundButton, fontChooser, preview);
        ((Container)gridPanel).add(this.createCaptionLabel("theme_editor.marked_file"));
        this.addForegroundColor(gridPanel, isActive ? 25 : 26, backgroundButton, fontChooser, preview);
        this.addForegroundColor(gridPanel, isActive ? 27 : 28, selectedBackgroundButton, fontChooser, preview);
        ((Container)gridPanel).add(this.createCaptionLabel("theme_editor.border"));
        ColorButton borderButton = new ColorButton(this.parent, this.themeData, isActive ? 0 : 56, "PreviewLabel.BorderColor");
        ((Container)gridPanel).add(borderButton);
        borderButton.addUpdatedPreviewComponent(preview);
        borderButton = new ColorButton(this.parent, this.themeData, isActive ? 57 : 58, "PreviewLabel.BorderColor");
        ((Container)gridPanel).add(borderButton);
        borderButton.addUpdatedPreviewComponent(preview);
        this.setLayout(new BorderLayout());
        this.add((Component)gridPanel, "West");
        this.add((Component)preview, "East");
    }

    public void commit() {
    }
}

