/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.ui.dialog.pref.theme;

import com.mucommander.text.Translator;
import com.mucommander.ui.chooser.FontChooser;
import com.mucommander.ui.dialog.pref.PreferencesDialog;
import com.mucommander.ui.dialog.pref.theme.FilePanel;
import com.mucommander.ui.dialog.pref.theme.ThemeEditorPanel;
import com.mucommander.ui.layout.ProportionalGridPanel;
import com.mucommander.ui.layout.YBoxPanel;
import com.mucommander.ui.theme.ThemeData;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;

class FolderPanePanel
extends ThemeEditorPanel {
    public FolderPanePanel(PreferencesDialog parent, ThemeData themeData) {
        super(parent, Translator.get("theme_editor.folder_tab", new String[0]), themeData);
        this.initUI();
    }

    private void initUI() {
        JTabbedPane tabbedPane = new JTabbedPane(1);
        FontChooser fontChooser = this.createFontChooser(0);
        tabbedPane.add(Translator.get("theme_editor.general", new String[0]), this.createScrollPane(this.createGeneralPanel(fontChooser)));
        FilePanel filePanel = new FilePanel(this.parent, true, this.themeData, fontChooser);
        tabbedPane.add(filePanel.getTitle(), this.createScrollPane(filePanel));
        filePanel = new FilePanel(this.parent, false, this.themeData, fontChooser);
        tabbedPane.add(filePanel.getTitle(), this.createScrollPane(filePanel));
        this.setLayout(new BorderLayout());
        this.add((Component)tabbedPane, "North");
    }

    private JPanel createGeneralPanel(FontChooser chooser) {
        ProportionalGridPanel panel = new ProportionalGridPanel(4);
        this.addLabelRow(panel);
        panel.add(this.addColorButtons(panel, chooser, "theme_editor.quick_search.unmatched_file", 6, 5));
        JPanel quickSearchPanel = new JPanel(new FlowLayout(0));
        quickSearchPanel.add(panel);
        quickSearchPanel.setBorder(BorderFactory.createTitledBorder(Translator.get("theme_editor.quick_search", new String[0])));
        YBoxPanel mainPanel = new YBoxPanel();
        mainPanel.add(chooser);
        mainPanel.addSpace(10);
        mainPanel.add(quickSearchPanel);
        JPanel wrapper = new JPanel(new BorderLayout());
        wrapper.add((Component)mainPanel, "North");
        return wrapper;
    }

    public void commit() {
    }
}

