/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.ui.dialog.pref.theme;

import com.mucommander.text.Translator;
import com.mucommander.ui.chooser.FontChooser;
import com.mucommander.ui.chooser.PreviewLabel;
import com.mucommander.ui.dialog.pref.PreferencesDialog;
import com.mucommander.ui.dialog.pref.theme.ColorButton;
import com.mucommander.ui.dialog.pref.theme.ThemeEditorPanel;
import com.mucommander.ui.icon.IconManager;
import com.mucommander.ui.layout.ProportionalGridPanel;
import com.mucommander.ui.layout.YBoxPanel;
import com.mucommander.ui.quicklist.QuickList;
import com.mucommander.ui.quicklist.item.DataList;
import com.mucommander.ui.quicklist.item.DataListWithIcons;
import com.mucommander.ui.quicklist.item.QuickListHeaderItem;
import com.mucommander.ui.theme.ThemeData;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.KeyListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;

public class QuickListPanel
extends ThemeEditorPanel
implements PropertyChangeListener {
    private JPanel quickListPreviewPanel;
    private QuickListHeaderItem header = new QuickListHeaderItem(Translator.get("sample_text", new String[0]));
    private static final String[] sampleData;
    private final Icon sampleIcon = IconManager.getIcon(0, "folder.png");
    private DataList<String> list = new DataListWithIcons<String>(sampleData){
        {
            for (KeyListener listener : this.getKeyListeners()) {
                this.removeKeyListener(listener);
            }
        }

        @Override
        public Icon getImageIconOfItem(String item) {
            return QuickListPanel.this.sampleIcon;
        }

        @Override
        protected void addMouseListenerToList() {
        }
    };

    private JPanel createPreviewPanel() {
        JScrollPane scroll = new JScrollPane(this.list, 20, 31);
        scroll.setBorder(null);
        scroll.getVerticalScrollBar().setFocusable(false);
        scroll.getHorizontalScrollBar().setFocusable(false);
        JPanel panel = new JPanel();
        this.quickListPreviewPanel = new YBoxPanel();
        this.quickListPreviewPanel.add(this.header);
        this.quickListPreviewPanel.add(scroll);
        this.quickListPreviewPanel.setBorder(new QuickList.PopupsBorder());
        panel.add(this.quickListPreviewPanel);
        panel.setBorder(BorderFactory.createTitledBorder(Translator.get("preview", new String[0])));
        return panel;
    }

    public QuickListPanel(PreferencesDialog parent, ThemeData themeData) {
        super(parent, Translator.get("quick_lists_menu", new String[0]), themeData);
        this.initUI();
    }

    private JPanel createItemColorsPanel(FontChooser fontChooser) {
        ProportionalGridPanel gridPanel = new ProportionalGridPanel(3);
        this.addLabelRow(gridPanel, false);
        PreviewLabel label = new PreviewLabel();
        this.addColorButtons(gridPanel, fontChooser, "theme_editor.normal", 65, 64, label).addPropertyChangeListener(this);
        this.addColorButtons(gridPanel, fontChooser, "theme_editor.selected", 67, 66, label).addPropertyChangeListener(this);
        label.addPropertyChangeListener(this);
        JPanel colorsPanel = new JPanel(new FlowLayout(0));
        colorsPanel.add(gridPanel);
        colorsPanel.setBorder(BorderFactory.createTitledBorder(Translator.get("theme_editor.colors", new String[0])));
        return colorsPanel;
    }

    private JPanel createHeaderColorsPanel(FontChooser fontChooser) {
        ProportionalGridPanel gridPanel = new ProportionalGridPanel(3);
        this.addLabelRow(gridPanel, false);
        PreviewLabel label = new PreviewLabel();
        this.addColorButtons(gridPanel, fontChooser, "", 63, 61, label).addPropertyChangeListener(this);
        label.addPropertyChangeListener(this);
        gridPanel.add(this.createCaptionLabel(""));
        gridPanel.add(new JLabel());
        PreviewLabel label3 = new PreviewLabel();
        ColorButton butt = new ColorButton(this.parent, this.themeData, 62, "PreviewLabel.BackgroundColor", label3);
        gridPanel.add(butt);
        label3.setTextPainted(true);
        label3.addPropertyChangeListener(this);
        butt.addUpdatedPreviewComponent(label3);
        JPanel colorsPanel = new JPanel(new FlowLayout(0));
        colorsPanel.add(gridPanel);
        colorsPanel.setBorder(BorderFactory.createTitledBorder(Translator.get("theme_editor.colors", new String[0])));
        return colorsPanel;
    }

    private void initUI() {
        this.header.addComponentListener(new ComponentListener(){

            public void componentHidden(ComponentEvent e) {
            }

            public void componentMoved(ComponentEvent e) {
            }

            public void componentResized(ComponentEvent e) {
                QuickListPanel.this.quickListPreviewPanel.repaint();
            }

            public void componentShown(ComponentEvent e) {
            }
        });
        FontChooser fontChooser1 = this.createFontChooser(6);
        FontChooser fontChooser2 = this.createFontChooser(7);
        this.addFontChooserListener(fontChooser1, this.header);
        this.addFontChooserListener(fontChooser2, this.list);
        YBoxPanel headerConfigurationPanel = new YBoxPanel();
        headerConfigurationPanel.add(fontChooser1);
        headerConfigurationPanel.addSpace(10);
        headerConfigurationPanel.add(this.createHeaderColorsPanel(fontChooser1));
        YBoxPanel itemConfigurationPanel = new YBoxPanel();
        itemConfigurationPanel.add(fontChooser2);
        itemConfigurationPanel.addSpace(10);
        itemConfigurationPanel.add(this.createItemColorsPanel(fontChooser1));
        JTabbedPane tabbedPane = new JTabbedPane();
        tabbedPane.add(Translator.get("theme_editor.header", new String[0]), headerConfigurationPanel);
        tabbedPane.add(Translator.get("theme_editor.item", new String[0]), itemConfigurationPanel);
        JPanel mainPanel = new JPanel(new BorderLayout());
        mainPanel.add((Component)tabbedPane, "Center");
        mainPanel.add((Component)this.createPreviewPanel(), "East");
        this.setLayout(new BorderLayout());
        this.add((Component)mainPanel, "North");
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (event.getPropertyName().equals("PreviewLabel.BackgroundColor")) {
            this.header.setBackgroundColors(this.themeData.getColor(61), this.themeData.getColor(62));
            this.list.setBackgroundColors(this.themeData.getColor(64), this.themeData.getColor(66));
        } else if (event.getPropertyName().equals("PreviewLabel.ForegroundColor")) {
            this.header.setForegroundColor(this.themeData.getColor(63));
            this.list.setForegroundColors(this.themeData.getColor(65), this.themeData.getColor(67));
        }
    }

    public void commit() {
    }

    static {
        String sampleText = Translator.get("sample_text", new String[0]);
        sampleData = new String[10];
        for (int i = 0; i < sampleData.length; ++i) {
            QuickListPanel.sampleData[i] = sampleText + " " + (i + 1) + "   ";
        }
    }
}

