/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.ui.dialog.pref.theme;

import com.mucommander.RuntimeConstants;
import com.mucommander.text.Translator;
import com.mucommander.ui.chooser.FontChooser;
import com.mucommander.ui.combobox.EditableComboBox;
import com.mucommander.ui.dialog.pref.PreferencesDialog;
import com.mucommander.ui.dialog.pref.theme.ThemeEditorPanel;
import com.mucommander.ui.layout.ProportionalGridPanel;
import com.mucommander.ui.layout.YBoxPanel;
import com.mucommander.ui.theme.ThemeData;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

class ShellPanel
extends ThemeEditorPanel
implements PropertyChangeListener {
    private JTextArea shellPreview;
    private EditableComboBox historyPreview;

    public ShellPanel(PreferencesDialog parent, ThemeData themeData) {
        super(parent, Translator.get("theme_editor.shell_tab", new String[0]), themeData);
        this.initUI();
    }

    private JComponent createConfigurationPanel(int fontId, int foregroundId, int backgroundId, int selectedForegroundId, int selectedBackgroundId, JComponent fontListener) {
        YBoxPanel mainPanel = new YBoxPanel();
        FontChooser fontChooser = this.createFontChooser(fontId);
        mainPanel.add(fontChooser);
        mainPanel.addSpace(10);
        this.addFontChooserListener(fontChooser, fontListener);
        ProportionalGridPanel colorPanel = new ProportionalGridPanel(3);
        this.addLabelRow(colorPanel, false);
        this.addColorButtons(colorPanel, fontChooser, "theme_editor.normal", foregroundId, backgroundId).addPropertyChangeListener(this);
        this.addColorButtons(colorPanel, fontChooser, "theme_editor.selected", selectedForegroundId, selectedBackgroundId).addPropertyChangeListener(this);
        JPanel flowPanel = new JPanel(new FlowLayout(0));
        flowPanel.add(colorPanel);
        flowPanel.setBorder(BorderFactory.createTitledBorder(Translator.get("theme_editor.colors", new String[0])));
        mainPanel.add(flowPanel);
        return this.createScrollPane(mainPanel);
    }

    private JPanel createPreviewPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        panel.setBorder(BorderFactory.createTitledBorder(Translator.get("preview", new String[0])));
        YBoxPanel headerPanel = new YBoxPanel();
        headerPanel.add(new JLabel(Translator.get("run_dialog.run_command_description", new String[0]) + ":"));
        this.historyPreview = new EditableComboBox(new JTextField("mucommander -v"));
        headerPanel.add(this.historyPreview);
        this.historyPreview.addItem("mucommander -v");
        this.historyPreview.addItem("java -version");
        headerPanel.addSpace(10);
        headerPanel.add(new JLabel(Translator.get("run_dialog.command_output", new String[0]) + ":"));
        panel.add((Component)headerPanel, "North");
        this.shellPreview = new JTextArea(15, 15);
        JScrollPane scroll = new JScrollPane(this.shellPreview, 22, 30);
        panel.add((Component)scroll, "Center");
        scroll.getViewport().setPreferredSize(this.shellPreview.getPreferredSize());
        this.shellPreview.append(RuntimeConstants.APP_STRING);
        this.shellPreview.append("\nCopyright (C) ");
        this.shellPreview.append(RuntimeConstants.COPYRIGHT);
        this.shellPreview.append(" Maxence Bernard\nThis is free software, distributed under the terms of the GNU General Public License.");
        this.shellPreview.setCaretPosition(0);
        this.setForegroundColors();
        this.setBackgroundColors();
        return panel;
    }

    private void initUI() {
        this.setLayout(new BorderLayout());
        JTabbedPane tabbedPane = new JTabbedPane();
        JPanel previewPanel = this.createPreviewPanel();
        tabbedPane.add(Translator.get("theme_editor.shell_tab", new String[0]), this.createConfigurationPanel(1, 33, 34, 35, 36, this.shellPreview));
        tabbedPane.add(Translator.get("theme_editor.shell_history_tab", new String[0]), this.createConfigurationPanel(4, 37, 38, 39, 40, this.historyPreview));
        JPanel mainPanel = new JPanel(new BorderLayout());
        mainPanel.add((Component)tabbedPane, "Center");
        mainPanel.add((Component)previewPanel, "East");
        this.add((Component)mainPanel, "North");
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (event.getPropertyName().equals("PreviewLabel.BackgroundColor")) {
            this.setBackgroundColors();
        } else if (event.getPropertyName().equals("PreviewLabel.ForegroundColor")) {
            this.setForegroundColors();
        }
    }

    private void setBackgroundColors() {
        this.shellPreview.setBackground(this.themeData.getColor(34));
        this.shellPreview.setSelectionColor(this.themeData.getColor(36));
        this.historyPreview.setBackground(this.themeData.getColor(38));
        this.historyPreview.setSelectionBackground(this.themeData.getColor(40));
    }

    private void setForegroundColors() {
        this.shellPreview.setForeground(this.themeData.getColor(33));
        this.shellPreview.setSelectedTextColor(this.themeData.getColor(35));
        this.shellPreview.setCaretColor(this.themeData.getColor(33));
        this.historyPreview.setForeground(this.themeData.getColor(37));
        this.historyPreview.setSelectionForeground(this.themeData.getColor(39));
    }

    public void commit() {
    }
}

