/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.ui.dialog.pref.theme;

import com.mucommander.text.Translator;
import com.mucommander.ui.dialog.InformationDialog;
import com.mucommander.ui.dialog.QuestionDialog;
import com.mucommander.ui.dialog.pref.PreferencesDialog;
import com.mucommander.ui.dialog.pref.PreferencesPanel;
import com.mucommander.ui.dialog.pref.component.PrefComponent;
import com.mucommander.ui.dialog.pref.theme.FileEditorPanel;
import com.mucommander.ui.dialog.pref.theme.FolderPanePanel;
import com.mucommander.ui.dialog.pref.theme.LocationBarPanel;
import com.mucommander.ui.dialog.pref.theme.QuickListPanel;
import com.mucommander.ui.dialog.pref.theme.ShellPanel;
import com.mucommander.ui.dialog.pref.theme.StatusBarPanel;
import com.mucommander.ui.theme.Theme;
import com.mucommander.ui.theme.ThemeData;
import com.mucommander.ui.theme.ThemeManager;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;

public class ThemeEditorDialog
extends PreferencesDialog {
    private static final Dimension MINIMUM_DIALOG_DIMENSION = new Dimension(580, 0);
    private static final Dimension MAXIMUM_DIALOG_DIMENSION = new Dimension(620, 500);
    private ThemeData data;
    private Theme theme;
    private boolean wasThemeModified;

    public ThemeEditorDialog(Dialog parent, Theme theme) {
        super(parent, ThemeEditorDialog.createTitle(theme));
        this.initUI(theme);
    }

    public ThemeEditorDialog(Frame parent, Theme theme) {
        super(parent, ThemeEditorDialog.createTitle(theme));
        this.initUI(theme);
    }

    private static String createTitle(Theme theme) {
        return Translator.get("theme_editor.title", new String[0]) + ": " + theme.getName();
    }

    private void initUI(Theme theme) {
        this.theme = theme;
        this.data = theme.cloneData();
        this.wasThemeModified = false;
        this.addPreferencesPanel((PreferencesPanel)new FolderPanePanel((PreferencesDialog)this, this.data), false);
        this.addPreferencesPanel(new LocationBarPanel((PreferencesDialog)this, this.data));
        this.addPreferencesPanel(new StatusBarPanel((PreferencesDialog)this, this.data));
        this.addPreferencesPanel(new ShellPanel((PreferencesDialog)this, this.data));
        this.addPreferencesPanel(new FileEditorPanel((PreferencesDialog)this, this.data));
        this.addPreferencesPanel(new QuickListPanel((PreferencesDialog)this, this.data));
        this.setMinimumSize(MINIMUM_DIALOG_DIMENSION);
        this.setMaximumSize(MAXIMUM_DIALOG_DIMENSION);
    }

    public boolean editTheme() {
        this.showDialog();
        return this.wasThemeModified;
    }

    public boolean checkCommit() {
        super.checkCommit();
        return this.theme.isIdentical(this.data) || this.theme.canModify() || new QuestionDialog(this, Translator.get("warning", new String[0]), Translator.get("theme_editor.theme_warning", new String[0]), (Component)this, new String[]{Translator.get("yes", new String[0]), Translator.get("no", new String[0])}, new int[]{0, 1}, 0).getActionValue() == 0;
    }

    public void commit() {
        super.commit();
        if (!this.theme.isIdentical(this.data)) {
            this.wasThemeModified = true;
            try {
                if (!this.theme.canModify()) {
                    boolean updateCurrentTheme = ThemeManager.isCurrentTheme(this.theme);
                    this.theme = ThemeManager.overwriteUserTheme(this.data);
                    this.setTitle(ThemeEditorDialog.createTitle(this.theme));
                    if (updateCurrentTheme) {
                        ThemeManager.setCurrentTheme(this.theme);
                    }
                } else {
                    this.theme.importData(this.data);
                    ThemeManager.writeTheme(this.theme);
                }
            }
            catch (Exception exception) {
                try {
                    InformationDialog.showErrorDialog(this, Translator.get("write_error", new String[0]), Translator.get("cannot_write_file", ThemeManager.getUserThemeFile().getAbsolutePath()));
                }
                catch (Exception exception2) {
                    // empty catch block
                }
            }
        }
    }

    public void componentChanged(PrefComponent component) {
        this.setCommitButtonsEnabled(!this.theme.isIdentical(this.data));
    }
}

