/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.ui.dialog.pref.theme;

import com.mucommander.text.Translator;
import com.mucommander.ui.chooser.FontChooser;
import com.mucommander.ui.chooser.PreviewLabel;
import com.mucommander.ui.dialog.pref.PreferencesDialog;
import com.mucommander.ui.dialog.pref.PreferencesPanel;
import com.mucommander.ui.dialog.pref.theme.ColorButton;
import com.mucommander.ui.layout.ProportionalGridPanel;
import com.mucommander.ui.theme.ThemeData;
import java.awt.Color;
import java.awt.Font;
import java.util.List;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

abstract class ThemeEditorPanel
extends PreferencesPanel {
    protected ThemeData themeData;
    private List<ChangeListener> listenerReferences = new Vector<ChangeListener>();
    private Font captionLabelFont;
    private Color captionTextColor = new Color(48, 48, 48);

    public ThemeEditorPanel(PreferencesDialog parent, String title, ThemeData themeData) {
        super(parent, title);
        this.themeData = themeData;
        this.captionLabelFont = new JLabel().getFont();
        this.captionLabelFont = this.captionLabelFont.deriveFont(1, (float)this.captionLabelFont.getSize() - 1.5f);
    }

    protected JLabel createCaptionLabel(String dictionaryKey) {
        JLabel captionLabel = new JLabel(Translator.get(dictionaryKey, new String[0]));
        captionLabel.setFont(this.captionLabelFont);
        captionLabel.setForeground(this.captionTextColor);
        return captionLabel;
    }

    protected void addLabelRow(ProportionalGridPanel panel) {
        this.addLabelRow(panel, true);
    }

    protected void addLabelRow(ProportionalGridPanel panel, boolean includePreview) {
        panel.add(new JLabel());
        panel.add(this.createCaptionLabel("theme_editor.text"));
        panel.add(this.createCaptionLabel("theme_editor.background"));
        if (includePreview) {
            panel.add(this.createCaptionLabel("preview"));
        }
    }

    protected FontChooser createFontChooser(int fontId) {
        FontChooser fontChooser = new FontChooser(this.themeData.getFont(fontId));
        fontChooser.setBorder(BorderFactory.createTitledBorder(Translator.get("theme_editor.font", new String[0])));
        ThemeFontChooserListener listener = new ThemeFontChooserListener(this.themeData, fontId, this.parent);
        fontChooser.addChangeListener(listener);
        this.listenerReferences.add(listener);
        return fontChooser;
    }

    protected void addFontChooserListener(FontChooser fontChooser, JComponent previewComponent) {
        if (fontChooser != null) {
            PreviewFontChooserListener listener = new PreviewFontChooserListener(previewComponent);
            fontChooser.addChangeListener(listener);
            previewComponent.setFont(fontChooser.getCurrentFont());
            this.listenerReferences.add(listener);
        }
    }

    protected JComponent createScrollPane(JPanel panel) {
        JScrollPane scrollPane = new JScrollPane(panel, 20, 31);
        scrollPane.setBorder(null);
        return scrollPane;
    }

    protected PreviewLabel addColorButtons(ProportionalGridPanel gridPanel, FontChooser fontChooser, String label, int foregroundId, int backgroundId) {
        return this.addColorButtons(gridPanel, fontChooser, label, foregroundId, backgroundId, null);
    }

    protected PreviewLabel addColorButtons(ProportionalGridPanel gridPanel, FontChooser fontChooser, String label, int foregroundId, int backgroundId, JComponent comp) {
        gridPanel.add(this.createCaptionLabel(label));
        PreviewLabel previewLabel = new PreviewLabel();
        previewLabel.setTextPainted(true);
        this.addFontChooserListener(fontChooser, previewLabel);
        ColorButton colorButton = new ColorButton(this.parent, this.themeData, foregroundId, "PreviewLabel.ForegroundColor", previewLabel);
        gridPanel.add(colorButton);
        if (comp != null) {
            colorButton.addUpdatedPreviewComponent(comp);
        }
        colorButton = new ColorButton(this.parent, this.themeData, backgroundId, "PreviewLabel.BackgroundColor", previewLabel);
        gridPanel.add(colorButton);
        if (comp != null) {
            colorButton.addUpdatedPreviewComponent(comp);
        }
        return previewLabel;
    }

    private static class PreviewFontChooserListener
    implements ChangeListener {
        private JComponent preview;

        public PreviewFontChooserListener(JComponent preview) {
            this.preview = preview;
        }

        public void stateChanged(ChangeEvent event) {
            this.preview.setFont(((FontChooser)event.getSource()).getCurrentFont());
        }
    }

    private static class ThemeFontChooserListener
    implements ChangeListener {
        private ThemeData data;
        private int fontId;
        private PreferencesDialog dialog;

        public ThemeFontChooserListener(ThemeData data, int fontId, PreferencesDialog dialog) {
            this.data = data;
            this.fontId = fontId;
            this.dialog = dialog;
        }

        public void stateChanged(ChangeEvent event) {
            this.data.setFont(this.fontId, ((FontChooser)event.getSource()).getCurrentFont());
            this.dialog.componentChanged(null);
        }
    }
}

