/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.ui.dialog.server;

import com.mucommander.commons.file.Credentials;
import com.mucommander.commons.file.FileURL;
import com.mucommander.text.Translator;
import com.mucommander.ui.dialog.DialogOwner;
import com.mucommander.ui.dialog.server.ServerConnectDialog;
import com.mucommander.ui.dialog.server.ServerPanel;
import com.mucommander.ui.encoding.EncodingListener;
import com.mucommander.ui.encoding.EncodingSelectBox;
import com.mucommander.ui.main.MainFrame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.MalformedURLException;
import java.text.ParseException;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPasswordField;
import javax.swing.JSpinner;
import javax.swing.JTextField;

public class FTPPanel
extends ServerPanel
implements EncodingListener,
ActionListener {
    private static final int STANDARD_PORT = FileURL.getRegisteredHandler("ftp").getStandardPort();
    private static Credentials ANONYMOUS_CREDENTIALS = FileURL.getRegisteredHandler("ftp").getGuestCredentials();
    private JTextField serverField = new JTextField(lastServer);
    private JTextField usernameField;
    private JPasswordField passwordField;
    private JTextField initialDirField;
    private JSpinner portSpinner;
    private JSpinner nbRetriesSpinner;
    private JSpinner retryDelaySpinner;
    private EncodingSelectBox encodingSelectBox;
    private JCheckBox passiveCheckBox;
    private JCheckBox anonymousCheckBox;
    private static String lastServer = "";
    private static String lastUsername = "";
    private static String lastInitialDir = "/";
    private static int lastPort = STANDARD_PORT;
    private static String lastEncoding = "UTF-8";
    private String lastPassword = "";
    private static boolean passiveMode = true;
    private static boolean anonymousUser;

    FTPPanel(ServerConnectDialog dialog, MainFrame mainFrame) {
        super(dialog, mainFrame);
        this.serverField.selectAll();
        this.addTextFieldListeners(this.serverField, true);
        this.addRow(Translator.get("server_connect_dialog.server", new String[0]), (JComponent)this.serverField, 15);
        this.usernameField = new JTextField(anonymousUser ? ANONYMOUS_CREDENTIALS.getLogin() : lastUsername);
        this.usernameField.selectAll();
        this.usernameField.setEditable(!anonymousUser);
        this.addTextFieldListeners(this.usernameField, false);
        this.addRow(Translator.get("server_connect_dialog.username", new String[0]), (JComponent)this.usernameField, 5);
        this.passwordField = new JPasswordField();
        this.addTextFieldListeners(this.passwordField, false);
        this.addRow(Translator.get("password", new String[0]), (JComponent)this.passwordField, 15);
        this.initialDirField = new JTextField(lastInitialDir);
        this.initialDirField.selectAll();
        this.addTextFieldListeners(this.initialDirField, true);
        this.addRow(Translator.get("server_connect_dialog.initial_dir", new String[0]), (JComponent)this.initialDirField, 5);
        this.portSpinner = this.createPortSpinner(lastPort);
        this.addRow(Translator.get("server_connect_dialog.port", new String[0]), (JComponent)this.portSpinner, 15);
        this.encodingSelectBox = new EncodingSelectBox(new DialogOwner(mainFrame), lastEncoding);
        this.encodingSelectBox.addEncodingListener(this);
        this.addRow(Translator.get("encoding", new String[0]), (JComponent)this.encodingSelectBox, 15);
        this.nbRetriesSpinner = this.createIntSpinner(0, 0, Integer.MAX_VALUE, 1);
        this.addRow(Translator.get("ftp_connect.nb_connection_retries", new String[0]), (JComponent)this.nbRetriesSpinner, 5);
        this.retryDelaySpinner = this.createIntSpinner(15, 0, Integer.MAX_VALUE, 1);
        this.addRow(Translator.get("ftp_connect.retry_delay", new String[0]), (JComponent)this.retryDelaySpinner, 15);
        this.anonymousCheckBox = new JCheckBox(Translator.get("ftp_connect.anonymous_user", new String[0]), anonymousUser);
        this.anonymousCheckBox.addActionListener(this);
        this.addRow("", (JComponent)this.anonymousCheckBox, 5);
        this.passiveCheckBox = new JCheckBox(Translator.get("ftp_connect.passive_mode", new String[0]), passiveMode);
        this.passiveCheckBox.addActionListener(this);
        this.addRow("", (JComponent)this.passiveCheckBox, 0);
    }

    private void updateValues() {
        lastServer = this.serverField.getText();
        if (!anonymousUser) {
            lastUsername = this.usernameField.getText();
            this.lastPassword = new String(this.passwordField.getPassword());
        }
        lastInitialDir = this.initialDirField.getText();
        lastPort = (Integer)this.portSpinner.getValue();
    }

    FileURL getServerURL() throws MalformedURLException {
        this.updateValues();
        if (!lastInitialDir.startsWith("/")) {
            lastInitialDir = "/" + lastInitialDir;
        }
        FileURL url = FileURL.getFileURL("ftp://" + lastServer + lastInitialDir);
        if (anonymousUser) {
            url.setCredentials(new Credentials(ANONYMOUS_CREDENTIALS.getLogin(), new String(this.passwordField.getPassword())));
        } else {
            url.setCredentials(new Credentials(lastUsername, this.lastPassword));
        }
        url.setPort(lastPort);
        url.setProperty("passiveMode", "" + passiveMode);
        url.setProperty("encoding", this.encodingSelectBox.getSelectedEncoding());
        url.setProperty("nbConnectionRetries", "" + this.nbRetriesSpinner.getValue());
        url.setProperty("connectionRetryDelay", "" + this.retryDelaySpinner.getValue());
        return url;
    }

    boolean usesCredentials() {
        return true;
    }

    public void dialogValidated() {
        try {
            this.portSpinner.commitEdit();
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        this.updateValues();
    }

    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.passiveCheckBox) {
            passiveMode = this.passiveCheckBox.isSelected();
        } else if (source == this.anonymousCheckBox) {
            this.updateValues();
            anonymousUser = this.anonymousCheckBox.isSelected();
            if (anonymousUser) {
                this.usernameField.setEnabled(false);
                this.usernameField.setText(ANONYMOUS_CREDENTIALS.getLogin());
                this.passwordField.setEnabled(false);
                this.passwordField.setText(ANONYMOUS_CREDENTIALS.getPassword());
            } else {
                this.usernameField.setEnabled(true);
                this.usernameField.setText(lastUsername);
                this.passwordField.setEnabled(true);
                this.passwordField.setText(this.lastPassword);
            }
        }
    }

    public void encodingChanged(Object source, String oldEncoding, String newEncoding) {
        lastEncoding = newEncoding;
    }
}

